/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dependency;

import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.openapi.util.Key;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class DependencyUtils {
    private static final Key<Set<RefClass>> DEPENDENT_CLASSES_KEY = new Key("DEPENDENT_CLASSES");
    private static final Key<Set<RefClass>> DEPENDENCY_CLASSES_KEY = new Key("DEPENDENCY_CLASSES");
    private static final Key<Set<RefClass>> TRANSITIVE_DEPENDENT_CLASSES_KEY = new Key("TRANSITIVE_DEPENDENT_CLASSES");
    private static final Key<Set<RefClass>> TRANSITIVE_DEPENDENCY_CLASSES_KEY = new Key("TRANSITIVE_DEPENDENCY_CLASSES");
    private static final Key<Set<RefPackage>> DEPENDENT_PACKAGES_KEY = new Key("DEPENDENT_PACKAGES");
    private static final Key<Set<RefPackage>> DEPENDENCY_PACKAGES_KEY = new Key("DEPENDENCY_PACKAGES");
    private static final Key<Set<RefPackage>> TRANSITIVE_DEPENDENT_PACKAGES_KEY = new Key("TRANSITIVE_DEPENDENT_PACKAGES");
    private static final Key<Set<RefPackage>> TRANSITIVE_DEPENDENCY_PACKAGES_KEY = new Key("TRANSITIVE_DEPENDENCY_PACKAGES");

    private DependencyUtils() {
    }

    public static Set<RefClass> calculateDependenciesForClass(RefClass refClass) {
        Set<RefClass> dependencies2 = refClass.getUserData(DEPENDENCY_CLASSES_KEY);
        if (dependencies2 != null) {
            return dependencies2;
        }
        HashSet<RefClass> newDependencies = new HashSet<RefClass>();
        DependencyUtils.tabulateDependencyClasses(refClass, newDependencies);
        newDependencies.remove(refClass);
        refClass.putUserData(DEPENDENCY_CLASSES_KEY, newDependencies);
        return newDependencies;
    }

    private static void tabulateDependencyClasses(RefJavaElement element, Set<RefClass> dependencies2) {
        DependencyUtils.addOwnerClassesToSet(element.getOutReferences(), dependencies2);
        DependencyUtils.addOwnerClassesToSet(element.getOutTypeReferences(), dependencies2);
        List<RefEntity> children2 = element.getChildren();
        for (RefEntity child : children2) {
            if (!(child instanceof RefJavaElement) || child instanceof RefClass) continue;
            DependencyUtils.tabulateDependencyClasses((RefJavaElement)child, dependencies2);
        }
    }

    private static void addOwnerClassesToSet(Collection<? extends RefElement> references, Set<RefClass> set) {
        RefJavaUtil refUtil = RefJavaUtil.getInstance();
        for (RefElement refElement : references) {
            RefClass refClass = refElement instanceof RefClass ? (RefClass)refElement : refUtil.getOwnerClass(refElement);
            if (refClass == null || refClass.isAnonymous() || refClass.isLocalClass()) continue;
            set.add(refClass);
        }
    }

    static Set<RefClass> calculateTransitiveDependenciesForClass(RefClass refClass) {
        Set<RefClass> dependencies2 = refClass.getUserData(TRANSITIVE_DEPENDENCY_CLASSES_KEY);
        if (dependencies2 != null) {
            return dependencies2;
        }
        HashSet<RefClass> newDependencies = new HashSet<RefClass>();
        DependencyUtils.tabulateTransitiveDependencyClasses(refClass, newDependencies);
        refClass.putUserData(TRANSITIVE_DEPENDENCY_CLASSES_KEY, newDependencies);
        return newDependencies;
    }

    private static void tabulateTransitiveDependencyClasses(RefClass refClass, Set<RefClass> newDependencies) {
        LinkedList<RefClass> pendingClasses = new LinkedList<RefClass>();
        pendingClasses.addLast(refClass);
        HashSet<RefClass> processedClasses = new HashSet<RefClass>();
        while (!pendingClasses.isEmpty()) {
            RefClass classToProcess = (RefClass)pendingClasses.removeFirst();
            newDependencies.add(classToProcess);
            processedClasses.add(classToProcess);
            Set<RefClass> dependencies2 = DependencyUtils.calculateDependenciesForClass(classToProcess);
            for (RefClass dependency : dependencies2) {
                if (pendingClasses.contains(dependency) || processedClasses.contains(dependency)) continue;
                pendingClasses.addLast(dependency);
            }
        }
        newDependencies.remove(refClass);
    }

    public static Set<RefClass> calculateDependentsForClass(RefClass refClass) {
        Set<RefClass> dependents = refClass.getUserData(DEPENDENT_CLASSES_KEY);
        if (dependents != null) {
            return dependents;
        }
        HashSet<RefClass> newDependents = new HashSet<RefClass>();
        DependencyUtils.tabulateDependentClasses(refClass, newDependents);
        newDependents.remove(refClass);
        refClass.putUserData(DEPENDENT_CLASSES_KEY, newDependents);
        return newDependents;
    }

    private static void tabulateDependentClasses(RefElement element, Set<RefClass> dependents) {
        DependencyUtils.addOwnerClassesToSet(element.getInReferences(), dependents);
        if (element instanceof RefClass) {
            RefClass refClass = (RefClass)element;
            DependencyUtils.addOwnerClassesToSet(refClass.getInTypeReferences(), dependents);
        }
        List<RefEntity> children2 = element.getChildren();
        for (RefEntity child : children2) {
            if (!(child instanceof RefElement) || child instanceof RefClass) continue;
            DependencyUtils.tabulateDependentClasses((RefElement)child, dependents);
        }
    }

    static Set<RefClass> calculateTransitiveDependentsForClass(RefClass refClass) {
        Set<RefClass> dependents = refClass.getUserData(TRANSITIVE_DEPENDENT_CLASSES_KEY);
        if (dependents != null) {
            return dependents;
        }
        HashSet<RefClass> newDependents = new HashSet<RefClass>();
        DependencyUtils.tabulateTransitiveDependentClasses(refClass, newDependents);
        refClass.putUserData(TRANSITIVE_DEPENDENT_CLASSES_KEY, newDependents);
        return newDependents;
    }

    private static void tabulateTransitiveDependentClasses(RefClass refClass, Set<RefClass> newDependents) {
        LinkedList<RefClass> pendingClasses = new LinkedList<RefClass>();
        pendingClasses.addLast(refClass);
        HashSet<RefClass> processedClasses = new HashSet<RefClass>();
        while (!pendingClasses.isEmpty()) {
            RefClass classToProcess = (RefClass)pendingClasses.removeFirst();
            newDependents.add(classToProcess);
            processedClasses.add(classToProcess);
            Set<RefClass> dependents = DependencyUtils.calculateDependentsForClass(classToProcess);
            for (RefClass dependent : dependents) {
                if (pendingClasses.contains(dependent) || processedClasses.contains(dependent)) continue;
                pendingClasses.addLast(dependent);
            }
        }
        newDependents.remove(refClass);
    }

    private static Set<RefPackage> calculateDependenciesForPackage(RefPackage refPackage) {
        Set<RefPackage> dependencies2 = refPackage.getUserData(DEPENDENCY_PACKAGES_KEY);
        if (dependencies2 != null) {
            return dependencies2;
        }
        HashSet<RefPackage> newDependencies = new HashSet<RefPackage>();
        DependencyUtils.tabulateDependencyPackages(refPackage, newDependencies);
        newDependencies.remove(refPackage);
        refPackage.putUserData(DEPENDENCY_PACKAGES_KEY, newDependencies);
        return newDependencies;
    }

    private static void tabulateDependencyPackages(RefEntity entity, Set<RefPackage> dependencies2) {
        if (entity instanceof RefElement) {
            RefElement element = (RefElement)entity;
            Collection<RefElement> references = element.getOutReferences();
            for (RefElement reference : references) {
                RefPackage refPackage = RefJavaUtil.getPackage(reference);
                if (refPackage == null) continue;
                dependencies2.add(refPackage);
            }
        }
        List<RefEntity> children2 = entity.getChildren();
        for (RefEntity child : children2) {
            if (child instanceof RefPackage) continue;
            DependencyUtils.tabulateDependencyPackages(child, dependencies2);
        }
    }

    private static Set<RefPackage> calculateDependentsForPackage(RefPackage refPackage) {
        Set<RefPackage> dependents = refPackage.getUserData(DEPENDENT_PACKAGES_KEY);
        if (dependents != null) {
            return dependents;
        }
        HashSet<RefPackage> newDependents = new HashSet<RefPackage>();
        DependencyUtils.tabulateDependentPackages(refPackage, newDependents);
        newDependents.remove(refPackage);
        refPackage.putUserData(DEPENDENT_PACKAGES_KEY, newDependents);
        return newDependents;
    }

    private static void tabulateDependentPackages(RefEntity entity, Set<RefPackage> dependents) {
        if (entity instanceof RefElement) {
            RefElement element = (RefElement)entity;
            Collection<RefElement> references = element.getInReferences();
            for (RefElement reference : references) {
                RefPackage refPackage = RefJavaUtil.getPackage(reference);
                if (refPackage == null) continue;
                dependents.add(refPackage);
            }
        }
        List<RefEntity> children2 = entity.getChildren();
        for (RefEntity child : children2) {
            if (child instanceof RefPackage) continue;
            DependencyUtils.tabulateDependentPackages(child, dependents);
        }
    }

    static Set<RefPackage> calculateTransitiveDependentsForPackage(RefPackage refPackage) {
        Set<RefPackage> dependents = refPackage.getUserData(TRANSITIVE_DEPENDENT_PACKAGES_KEY);
        if (dependents != null) {
            return dependents;
        }
        HashSet<RefPackage> newDependents = new HashSet<RefPackage>();
        DependencyUtils.tabulateTransitiveDependentPackages(refPackage, newDependents);
        refPackage.putUserData(TRANSITIVE_DEPENDENT_PACKAGES_KEY, newDependents);
        return newDependents;
    }

    private static void tabulateTransitiveDependentPackages(RefPackage refPackage, Set<RefPackage> newDependents) {
        LinkedList<RefPackage> pendingPackages = new LinkedList<RefPackage>();
        pendingPackages.addLast(refPackage);
        HashSet<RefPackage> processedPackages = new HashSet<RefPackage>();
        while (!pendingPackages.isEmpty()) {
            RefPackage packageToProcess = (RefPackage)pendingPackages.removeFirst();
            newDependents.add(packageToProcess);
            processedPackages.add(packageToProcess);
            Set<RefPackage> dependents = DependencyUtils.calculateDependentsForPackage(packageToProcess);
            for (RefPackage dependent : dependents) {
                if (pendingPackages.contains(dependent) || processedPackages.contains(dependent)) continue;
                pendingPackages.addLast(dependent);
            }
        }
        newDependents.remove(refPackage);
    }

    static Set<RefPackage> calculateTransitiveDependenciesForPackage(RefPackage refPackage) {
        Set<RefPackage> dependencies2 = refPackage.getUserData(TRANSITIVE_DEPENDENCY_PACKAGES_KEY);
        if (dependencies2 != null) {
            return dependencies2;
        }
        HashSet<RefPackage> newDependencies = new HashSet<RefPackage>();
        DependencyUtils.tabulateTransitiveDependencyPackages(refPackage, newDependencies);
        refPackage.putUserData(TRANSITIVE_DEPENDENCY_PACKAGES_KEY, newDependencies);
        return newDependencies;
    }

    private static void tabulateTransitiveDependencyPackages(RefPackage refPackage, Set<RefPackage> newDependencies) {
        LinkedList<RefPackage> pendingPackages = new LinkedList<RefPackage>();
        pendingPackages.addLast(refPackage);
        HashSet<RefPackage> processedPackages = new HashSet<RefPackage>();
        while (!pendingPackages.isEmpty()) {
            RefPackage packageToProcess = (RefPackage)pendingPackages.removeFirst();
            newDependencies.add(packageToProcess);
            processedPackages.add(packageToProcess);
            Set<RefPackage> dependencies2 = DependencyUtils.calculateDependenciesForPackage(packageToProcess);
            for (RefPackage dependency : dependencies2) {
                if (pendingPackages.contains(dependency) || processedPackages.contains(dependency)) continue;
                pendingPackages.addLast(dependency);
            }
        }
        newDependencies.remove(refPackage);
    }
}

