/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class ContinueOrBreakFromFinallyBlockInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("continue.or.break.from.finally.block.display.name", new Object[0]);
        if (string == null) {
            ContinueOrBreakFromFinallyBlockInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("continue.or.break.from.finally.block.problem.descriptor", new Object[0]);
        if (string == null) {
            ContinueOrBreakFromFinallyBlockInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ContinueOrBreakFromFinallyBlockVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/errorhandling/ContinueOrBreakFromFinallyBlockInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ContinueOrBreakFromFinallyBlockVisitor
    extends BaseInspectionVisitor {
        private ContinueOrBreakFromFinallyBlockVisitor() {
        }

        @Override
        public void visitContinueStatement(@NotNull PsiContinueStatement statement2) {
            if (statement2 == null) {
                ContinueOrBreakFromFinallyBlockVisitor.$$$reportNull$$$0(0);
            }
            super.visitContinueStatement(statement2);
            if (!ControlFlowUtils.isInFinallyBlock(statement2)) {
                return;
            }
            PsiStatement continuedStatement = statement2.findContinuedStatement();
            if (continuedStatement == null) {
                return;
            }
            if (ControlFlowUtils.isInFinallyBlock(continuedStatement)) {
                return;
            }
            this.registerStatementError(statement2, new Object[0]);
        }

        @Override
        public void visitBreakStatement(@NotNull PsiBreakStatement statement2) {
            if (statement2 == null) {
                ContinueOrBreakFromFinallyBlockVisitor.$$$reportNull$$$0(1);
            }
            super.visitBreakStatement(statement2);
            if (!ControlFlowUtils.isInFinallyBlock(statement2)) {
                return;
            }
            PsiStatement exitedStatement = statement2.findExitedStatement();
            if (exitedStatement == null) {
                return;
            }
            if (ControlFlowUtils.isInFinallyBlock(exitedStatement)) {
                return;
            }
            this.registerStatementError(statement2, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "statement";
            objectArray2[1] = "com/siyeh/ig/errorhandling/ContinueOrBreakFromFinallyBlockInspection$ContinueOrBreakFromFinallyBlockVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitContinueStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBreakStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

