/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExceptionUtils;
import org.jetbrains.annotations.NotNull;

public class ThreadDeathRethrownInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("ThreadDeathNotRethrown" == null) {
            ThreadDeathRethrownInspection.$$$reportNull$$$0(0);
        }
        return "ThreadDeathNotRethrown";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("thread.death.rethrown.display.name", new Object[0]);
        if (string == null) {
            ThreadDeathRethrownInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("thread.death.rethrown.problem.descriptor", new Object[0]);
        if (string == null) {
            ThreadDeathRethrownInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThreadDeathRethrownVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/errorhandling/ThreadDeathRethrownInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ThreadDeathRethrownVisitor
    extends BaseInspectionVisitor {
        private ThreadDeathRethrownVisitor() {
        }

        @Override
        public void visitCatchSection(PsiCatchSection section2) {
            super.visitCatchSection(section2);
            PsiParameter parameter = section2.getParameter();
            if (parameter == null) {
                return;
            }
            PsiCodeBlock catchBlock = section2.getCatchBlock();
            if (catchBlock == null) {
                return;
            }
            PsiTypeElement typeElement = parameter.getTypeElement();
            if (typeElement == null) {
                return;
            }
            PsiType type2 = typeElement.getType();
            if (!ThreadDeathRethrownVisitor.hasJavaLangThreadDeathType(type2) || ExceptionUtils.isThrowableRethrown(parameter, catchBlock)) {
                return;
            }
            this.registerVariableError(parameter, new Object[0]);
        }

        private static boolean hasJavaLangThreadDeathType(PsiType type2) {
            PsiClassType classType;
            PsiClass aClass2;
            if (type2 instanceof PsiDisjunctionType) {
                PsiDisjunctionType disjunctionType = (PsiDisjunctionType)type2;
                for (PsiType disjunction : disjunctionType.getDisjunctions()) {
                    if (!ThreadDeathRethrownVisitor.hasJavaLangThreadDeathType(disjunction)) continue;
                    return true;
                }
            } else if (type2 instanceof PsiClassType && InheritanceUtil.isInheritor(aClass2 = (classType = (PsiClassType)type2).resolve(), "java.lang.ThreadDeath")) {
                return true;
            }
            return false;
        }
    }
}

