/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.errorhandling.CatchParameterUsedVisitor;
import com.siyeh.ig.psiutils.TestUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class UnusedCatchParameterInspectionBase
extends BaseInspection {
    public boolean m_ignoreCatchBlocksWithComments = false;
    public boolean m_ignoreTestCases = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unused.catch.parameter.display.name", new Object[0]);
        if (string == null) {
            UnusedCatchParameterInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("unused.catch.parameter.ignore.catch.option", new Object[0]), "m_ignoreCatchBlocksWithComments");
        return optionsPanel;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        boolean namedIgnoreButUsed = (Boolean)infos2[0];
        if (namedIgnoreButUsed) {
            String string = InspectionGadgetsBundle.message("used.catch.parameter.named.ignore.problem.descriptor", new Object[0]);
            if (string == null) {
                UnusedCatchParameterInspectionBase.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("unused.catch.parameter.problem.descriptor", new Object[0]);
        if (string == null) {
            UnusedCatchParameterInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnusedCatchParameterVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/errorhandling/UnusedCatchParameterInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class UnusedCatchParameterVisitor
    extends BaseInspectionVisitor {
        private UnusedCatchParameterVisitor() {
        }

        @Override
        public void visitTryStatement(@NotNull PsiTryStatement statement2) {
            PsiCatchSection[] catchSections;
            if (statement2 == null) {
                UnusedCatchParameterVisitor.$$$reportNull$$$0(0);
            }
            super.visitTryStatement(statement2);
            if (UnusedCatchParameterInspectionBase.this.m_ignoreTestCases && TestUtils.isInTestCode(statement2)) {
                return;
            }
            for (PsiCatchSection catchSection : catchSections = statement2.getCatchSections()) {
                this.checkCatchSection(catchSection);
            }
        }

        private void checkCatchSection(PsiCatchSection section2) {
            PsiParameter parameter = section2.getParameter();
            if (parameter == null) {
                return;
            }
            String parameterName = parameter.getName();
            PsiCodeBlock block = section2.getCatchBlock();
            if (block == null) {
                return;
            }
            if (UnusedCatchParameterInspectionBase.this.m_ignoreCatchBlocksWithComments && PsiTreeUtil.getChildOfType(block, PsiComment.class) != null) {
                return;
            }
            CatchParameterUsedVisitor visitor2 = new CatchParameterUsedVisitor(parameter);
            block.accept(visitor2);
            boolean namedIgnore = PsiUtil.isIgnoredName(parameterName);
            if (visitor2.isUsed()) {
                if (namedIgnore) {
                    this.registerVariableError(parameter, Boolean.TRUE, parameter);
                }
                return;
            }
            if (namedIgnore) {
                return;
            }
            this.registerVariableError(parameter, Boolean.FALSE, parameter);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/errorhandling/UnusedCatchParameterInspectionBase$UnusedCatchParameterVisitor", "visitTryStatement"));
        }
    }
}

