/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.FinalUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakeFieldFinalFix
extends InspectionGadgetsFix {
    private final String fieldName;

    private MakeFieldFinalFix(String fieldName) {
        this.fieldName = fieldName;
    }

    @Nullable
    public static InspectionGadgetsFix buildFix(PsiField field) {
        if (!FinalUtils.canBeFinal(field)) {
            return null;
        }
        String name = field.getName();
        return new MakeFieldFinalFix(name);
    }

    @NotNull
    public static InspectionGadgetsFix buildFixUnconditional(PsiField field) {
        MakeFieldFinalFix makeFieldFinalFix = new MakeFieldFinalFix(field.getName());
        if (makeFieldFinalFix == null) {
            MakeFieldFinalFix.$$$reportNull$$$0(0);
        }
        return makeFieldFinalFix;
    }

    @Override
    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("make.field.final.quickfix", this.fieldName);
        if (string == null) {
            MakeFieldFinalFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        if ("Make final" == null) {
            MakeFieldFinalFix.$$$reportNull$$$0(2);
        }
        return "Make final";
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor2) {
        PsiField field;
        PsiElement element = descriptor2.getPsiElement();
        if (element instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiField)) {
                return;
            }
            field = (PsiField)target;
        } else {
            PsiElement parent2 = element.getParent();
            if (!(parent2 instanceof PsiField)) {
                return;
            }
            field = (PsiField)parent2;
        }
        field.normalizeDeclaration();
        PsiModifierList modifierList = field.getModifierList();
        if (modifierList == null) {
            return;
        }
        modifierList.setModifierProperty("volatile", false);
        modifierList.setModifierProperty("final", true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/fixes/MakeFieldFinalFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixUnconditional";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

