/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MakeInitializerExplicitFix
extends InspectionGadgetsFix {
    @Override
    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("make.initialization.explicit.quickfix", new Object[0]);
        if (string == null) {
            MakeInitializerExplicitFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor2) {
        PsiElement fieldName = descriptor2.getPsiElement();
        PsiElement parent2 = fieldName.getParent();
        if (!(parent2 instanceof PsiField)) {
            return;
        }
        PsiField field = (PsiField)parent2;
        if (field.getInitializer() != null) {
            return;
        }
        PsiType type2 = field.getType();
        PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(project);
        PsiExpression initializer2 = factory2.createExpressionFromText(MakeInitializerExplicitFix.getDefaultValue(type2), field);
        field.setInitializer(initializer2);
    }

    @NonNls
    private static String getDefaultValue(PsiType type2) {
        if (PsiType.INT.equals(type2)) {
            return "0";
        }
        if (PsiType.LONG.equals(type2)) {
            return "0L";
        }
        if (PsiType.DOUBLE.equals(type2)) {
            return "0.0";
        }
        if (PsiType.FLOAT.equals(type2)) {
            return "0.0F";
        }
        if (PsiType.SHORT.equals(type2)) {
            return "(short)0";
        }
        if (PsiType.BYTE.equals(type2)) {
            return "(byte)0";
        }
        if (PsiType.BOOLEAN.equals(type2)) {
            return "false";
        }
        if (PsiType.CHAR.equals(type2)) {
            return "(char)0";
        }
        return "null";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/MakeInitializerExplicitFix", "getFamilyName"));
    }
}

