/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.imports;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.FileTypeUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.DeleteImportFix;
import com.siyeh.ig.psiutils.ImportUtils;
import org.jetbrains.annotations.NotNull;

public class JavaLangImportInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("java.lang.import.display.name", new Object[0]);
        if (string == null) {
            JavaLangImportInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("java.lang.import.problem.descriptor", new Object[0]);
        if (string == null) {
            JavaLangImportInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos2) {
        return new DeleteImportFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return !FileTypeUtils.isInServerPageFile(file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new JavaLangImportVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/imports/JavaLangImportInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class JavaLangImportVisitor
    extends BaseInspectionVisitor {
        private JavaLangImportVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass2) {
            PsiImportStatement[] importStatements;
            if (aClass2 == null) {
                JavaLangImportVisitor.$$$reportNull$$$0(0);
            }
            if (!(aClass2.getParent() instanceof PsiJavaFile)) {
                return;
            }
            PsiJavaFile file2 = (PsiJavaFile)aClass2.getContainingFile();
            if (!file2.getClasses()[0].equals(aClass2)) {
                return;
            }
            PsiImportList importList = file2.getImportList();
            if (importList == null) {
                return;
            }
            for (PsiImportStatement importStatement : importStatements = importList.getImportStatements()) {
                this.checkImportStatement(importStatement, file2);
            }
        }

        private void checkImportStatement(PsiImportStatement importStatement, PsiJavaFile file2) {
            PsiJavaCodeReferenceElement reference = importStatement.getImportReference();
            if (reference == null) {
                return;
            }
            String text2 = importStatement.getQualifiedName();
            if (text2 == null) {
                return;
            }
            if (importStatement.isOnDemand()) {
                if ("java.lang".equals(text2)) {
                    this.registerError((PsiElement)importStatement, new Object[0]);
                }
            } else {
                int classNameIndex = text2.lastIndexOf(46);
                if (classNameIndex < 0) {
                    return;
                }
                String parentName = text2.substring(0, classNameIndex);
                if (!"java.lang".equals(parentName)) {
                    return;
                }
                if (ImportUtils.hasOnDemandImportConflict(text2, file2)) {
                    return;
                }
                this.registerError((PsiElement)importStatement, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/imports/JavaLangImportInspection$JavaLangImportVisitor", "visitClass"));
        }
    }
}

