/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.imports;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.OrderedSet;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class StaticImportInspectionBase
extends BaseInspection {
    public boolean ignoreSingleFieldImports = false;
    public boolean ignoreSingeMethodImports = false;
    public boolean ignoreInTestCode = false;
    public OrderedSet<String> allowedClasses = new OrderedSet();

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("static.import.display.name", new Object[0]);
        if (string == null) {
            StaticImportInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("static.import.problem.descriptor", new Object[0]);
        if (string == null) {
            StaticImportInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return !FileTypeUtils.isInServerPageFile(file2);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        return new StaticImportFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StaticImportVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/imports/StaticImportInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class StaticImportVisitor
    extends BaseInspectionVisitor {
        private StaticImportVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass2) {
            PsiImportStaticStatement[] importStatements;
            PsiElement parent2;
            if (aClass2 == null) {
                StaticImportVisitor.$$$reportNull$$$0(0);
            }
            if (!((parent2 = aClass2.getParent()) instanceof PsiJavaFile)) {
                return;
            }
            PsiJavaFile file2 = (PsiJavaFile)parent2;
            if (!file2.getClasses()[0].equals(aClass2)) {
                return;
            }
            PsiImportList importList = file2.getImportList();
            if (importList == null) {
                return;
            }
            for (PsiImportStaticStatement importStatement : importStatements = importList.getImportStaticStatements()) {
                if (!this.shouldReportImportStatement(importStatement)) continue;
                this.registerError((PsiElement)importStatement, importStatement);
            }
        }

        private boolean shouldReportImportStatement(PsiImportStaticStatement importStatement) {
            PsiJavaCodeReferenceElement importReference = importStatement.getImportReference();
            if (importReference == null) {
                return false;
            }
            boolean checked = false;
            for (PsiClass targetClass = importStatement.resolveTargetClass(); targetClass != null; targetClass = targetClass.getContainingClass()) {
                String qualifiedName2 = targetClass.getQualifiedName();
                if (StaticImportInspectionBase.this.allowedClasses.contains(qualifiedName2)) {
                    return false;
                }
                if (checked) break;
                checked = true;
            }
            if (importStatement.isOnDemand()) {
                return true;
            }
            if (StaticImportInspectionBase.this.ignoreSingleFieldImports || StaticImportInspectionBase.this.ignoreSingeMethodImports) {
                JavaResolveResult[] results;
                boolean field = false;
                boolean method = false;
                for (JavaResolveResult result2 : results = importReference.multiResolve(false)) {
                    PsiElement element = result2.getElement();
                    if (element instanceof PsiField) {
                        field = true;
                        continue;
                    }
                    if (!(element instanceof PsiMethod)) continue;
                    method = true;
                }
                if (field && !method ? StaticImportInspectionBase.this.ignoreSingleFieldImports : method && !field && StaticImportInspectionBase.this.ignoreSingeMethodImports) {
                    return false;
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/imports/StaticImportInspectionBase$StaticImportVisitor", "visitClass"));
        }
    }

    private static class StaticImportFix
    extends InspectionGadgetsFix {
        private StaticImportFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("static.import.replace.quickfix", new Object[0]);
            if (string == null) {
                StaticImportFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiImportStaticStatement importStatement = (PsiImportStaticStatement)descriptor2.getPsiElement();
            PsiJavaCodeReferenceElement importReference = importStatement.getImportReference();
            if (importReference == null) {
                return;
            }
            JavaResolveResult[] importTargets = importReference.multiResolve(false);
            if (importTargets.length == 0) {
                return;
            }
            boolean onDemand = importStatement.isOnDemand();
            StaticImportReferenceCollector referenceCollector = new StaticImportReferenceCollector(importTargets, onDemand);
            PsiJavaFile file2 = (PsiJavaFile)importStatement.getContainingFile();
            file2.accept(referenceCollector);
            List<PsiJavaCodeReferenceElement> references = referenceCollector.getReferences();
            HashMap<PsiJavaCodeReferenceElement, PsiMember> referenceTargetMap = new HashMap<PsiJavaCodeReferenceElement, PsiMember>();
            for (PsiJavaCodeReferenceElement psiJavaCodeReferenceElement : references) {
                PsiElement target = psiJavaCodeReferenceElement.resolve();
                if (target instanceof PsiEnumConstant && psiJavaCodeReferenceElement.getParent() instanceof PsiSwitchLabelStatement || !(target instanceof PsiMember)) continue;
                PsiMember member = (PsiMember)target;
                referenceTargetMap.put(psiJavaCodeReferenceElement, member);
            }
            importStatement.delete();
            for (Map.Entry entry : referenceTargetMap.entrySet()) {
                StaticImportFix.removeReference((PsiJavaCodeReferenceElement)entry.getKey(), (PsiMember)entry.getValue());
            }
        }

        private static void removeReference(PsiJavaCodeReferenceElement reference, PsiMember target) {
            PsiManager manager = reference.getManager();
            Project project = manager.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
            PsiElementFactory factory2 = psiFacade.getElementFactory();
            PsiClass aClass2 = target.getContainingClass();
            if (aClass2 == null) {
                return;
            }
            String qualifiedName2 = aClass2.getQualifiedName();
            String text2 = reference.getText();
            String referenceText = qualifiedName2 + '.' + text2;
            if (reference instanceof PsiReferenceExpression) {
                PsiExpression newReference = factory2.createExpressionFromText(referenceText, reference);
                PsiElement insertedElement = reference.replace(newReference);
                JavaCodeStyleManager.getInstance(project).shortenClassReferences(insertedElement);
            } else {
                PsiJavaCodeReferenceElement referenceElement = factory2.createReferenceElementByFQClassName(referenceText, reference.getResolveScope());
                PsiElement insertedElement = reference.replace(referenceElement);
                JavaCodeStyleManager.getInstance(project).shortenClassReferences(insertedElement);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/imports/StaticImportInspectionBase$StaticImportFix", "getFamilyName"));
        }

        static class StaticImportReferenceCollector
        extends JavaRecursiveElementVisitor {
            private final JavaResolveResult[] importTargets;
            private final boolean onDemand;
            private final List<PsiJavaCodeReferenceElement> references;

            StaticImportReferenceCollector(@NotNull JavaResolveResult[] importTargets, boolean onDemand) {
                if (importTargets == null) {
                    StaticImportReferenceCollector.$$$reportNull$$$0(0);
                }
                this.references = new ArrayList<PsiJavaCodeReferenceElement>();
                this.importTargets = importTargets;
                this.onDemand = onDemand;
            }

            @Override
            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                if (StaticImportReferenceCollector.isFullyQualifiedReference(reference)) {
                    return;
                }
                PsiElement parent2 = reference.getParent();
                if (parent2 instanceof PsiImportStatementBase) {
                    return;
                }
                while (parent2 instanceof PsiJavaCodeReferenceElement) {
                    if (!((parent2 = parent2.getParent()) instanceof PsiImportStatementBase)) continue;
                    return;
                }
                this.checkStaticImportReference(reference);
            }

            private void checkStaticImportReference(PsiJavaCodeReferenceElement reference) {
                if (reference.isQualified()) {
                    return;
                }
                PsiElement target = reference.resolve();
                if (!(target instanceof PsiMethod || target instanceof PsiClass || target instanceof PsiField)) {
                    return;
                }
                PsiMember member = (PsiMember)target;
                if (!member.hasModifierProperty("static")) {
                    return;
                }
                for (JavaResolveResult importTarget : this.importTargets) {
                    PsiElement targetElement = importTarget.getElement();
                    if (targetElement instanceof PsiMethod || targetElement instanceof PsiField) {
                        if (!member.equals(targetElement)) continue;
                        this.addReference(reference);
                        continue;
                    }
                    if (!(targetElement instanceof PsiClass)) continue;
                    if (this.onDemand) {
                        PsiClass containingClass = member.getContainingClass();
                        if (!InheritanceUtil.isInheritorOrSelf((PsiClass)targetElement, containingClass, true)) continue;
                        this.addReference(reference);
                        continue;
                    }
                    if (!targetElement.equals(member)) continue;
                    this.addReference(reference);
                }
            }

            private void addReference(PsiJavaCodeReferenceElement reference) {
                this.references.add(reference);
            }

            public List<PsiJavaCodeReferenceElement> getReferences() {
                return this.references;
            }

            public static boolean isFullyQualifiedReference(PsiJavaCodeReferenceElement reference) {
                if (!reference.isQualified()) {
                    return false;
                }
                PsiElement directParent = reference.getParent();
                if (directParent instanceof PsiMethodCallExpression || directParent instanceof PsiAssignmentExpression || directParent instanceof PsiVariable) {
                    return false;
                }
                Object parent2 = PsiTreeUtil.getParentOfType((PsiElement)reference, PsiImportStatementBase.class, PsiPackageStatement.class, JavaCodeFragment.class);
                if (parent2 != null) {
                    return false;
                }
                PsiElement target = reference.resolve();
                if (!(target instanceof PsiClass)) {
                    return false;
                }
                PsiClass aClass2 = (PsiClass)target;
                String fqName2 = aClass2.getQualifiedName();
                if (fqName2 == null) {
                    return false;
                }
                String text2 = StringUtils.stripAngleBrackets(reference.getText());
                return text2.equals(fqName2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importTargets", "com/siyeh/ig/imports/StaticImportInspectionBase$StaticImportFix$StaticImportReferenceCollector", "<init>"));
            }
        }
    }
}

