/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.util.containers.ContainerUtilRt;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterTypePreventsOverridingInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("parameter.type.prevents.overriding.display.name", new Object[0]);
        if (string == null) {
            ParameterTypePreventsOverridingInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String qualifiedName1 = (String)infos2[0];
        String packageName = StringUtil.getPackageName(qualifiedName1);
        String qualifiedName2 = (String)infos2[1];
        String superPackageName = StringUtil.getPackageName(qualifiedName2);
        String string = InspectionGadgetsBundle.message("parameter.type.prevents.overriding.problem.descriptor", packageName, superPackageName);
        if (string == null) {
            ParameterTypePreventsOverridingInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        return new ParameterTypePreventsOverridingFix((String)infos2[1]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ParameterTypePreventsOverridingVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/inheritance/ParameterTypePreventsOverridingInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ParameterTypePreventsOverridingVisitor
    extends BaseInspectionVisitor {
        private ParameterTypePreventsOverridingVisitor() {
        }

        @Override
        public void visitMethod(PsiMethod method) {
            PsiMethod[] superMethods;
            super.visitMethod(method);
            if (method.hasModifierProperty("static")) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            int parameterCount = parameterList.getParametersCount();
            if (parameterCount == 0) {
                return;
            }
            PsiType returnType = method.getReturnType();
            if (returnType == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            PsiClass superClass = containingClass.getSuperClass();
            if (superClass == null) {
                return;
            }
            if (MethodUtils.hasSuper(method)) {
                return;
            }
            PsiParameter[] parameters2 = parameterList.getParameters();
            String name = method.getName();
            block0: for (PsiMethod superMethod : superMethods = superClass.findMethodsByName(name, true)) {
                PsiType type2;
                PsiParameterList superParameterList;
                PsiType superReturnType = superMethod.getReturnType();
                if (superReturnType == null || !superReturnType.isAssignableFrom(returnType) || (superParameterList = superMethod.getParameterList()).getParametersCount() != parameterCount) continue;
                PsiParameter[] superParameters = superParameterList.getParameters();
                Map<PsiTypeElement, PsiClassType> problemTypeElements = ContainerUtilRt.newHashMap(2);
                for (int i2 = 0; i2 < parameters2.length; ++i2) {
                    PsiParameter parameter = parameters2[i2];
                    PsiParameter superParameter = superParameters[i2];
                    type2 = parameter.getType();
                    PsiType superType = superParameter.getType();
                    if (!(superType instanceof PsiClassType) || type2.equals(superType)) continue;
                    if (!(type2 instanceof PsiClassType) || !type2.getPresentableText().equals(superType.getPresentableText())) {
                        return;
                    }
                    PsiTypeElement typeElement = parameter.getTypeElement();
                    if (typeElement == null) {
                        return;
                    }
                    PsiTypeElement superParameterTypeElement = superParameter.getTypeElement();
                    if (superParameterTypeElement == null) continue block0;
                    problemTypeElements.put(typeElement, (PsiClassType)superType);
                }
                for (Map.Entry entry : problemTypeElements.entrySet()) {
                    PsiTypeElement typeElement = (PsiTypeElement)entry.getKey();
                    type2 = (PsiClassType)typeElement.getType();
                    PsiClass aClass1 = ((PsiClassType)type2).resolve();
                    if (aClass1 == null || aClass1 instanceof PsiTypeParameter) {
                        return;
                    }
                    PsiClassType classType = (PsiClassType)entry.getValue();
                    PsiClass aClass2 = classType.resolve();
                    if (aClass2 == null || aClass2 instanceof PsiTypeParameter) continue;
                    this.registerError((PsiElement)typeElement, type2.getCanonicalText(), classType.getCanonicalText());
                }
            }
        }
    }

    private static class ParameterTypePreventsOverridingFix
    extends InspectionGadgetsFix {
        private final String myNewTypeText;

        public ParameterTypePreventsOverridingFix(String newTypeText) {
            this.myNewTypeText = newTypeText;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("parameter.type.prevents.overriding.quickfix", this.myNewTypeText);
            if (string == null) {
                ParameterTypePreventsOverridingFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("parameter.type.prevents.overriding.family.quickfix", new Object[0]);
            if (string == null) {
                ParameterTypePreventsOverridingFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement element = descriptor2.getPsiElement();
            if (!(element instanceof PsiTypeElement)) {
                return;
            }
            PsiTypeElement typeElement = (PsiTypeElement)element;
            PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(typeElement.getProject());
            PsiTypeElement newTypeElement = factory2.createTypeElementFromText(this.myNewTypeText, typeElement);
            typeElement.replace(newTypeElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/inheritance/ParameterTypePreventsOverridingInspection$ParameterTypePreventsOverridingFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

