/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.ConvertToVarargsMethodFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProblematicVarargsMethodOverrideInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("problematic.varargs.method.display.name", new Object[0]);
        if (string == null) {
            ProblematicVarargsMethodOverrideInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("problematic.varargs.method.override.problem.descriptor", new Object[0]);
        if (string == null) {
            ProblematicVarargsMethodOverrideInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        return new ConvertToVarargsMethodFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonVarargsMethodOverridesVarArgsMethodVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/inheritance/ProblematicVarargsMethodOverrideInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class NonVarargsMethodOverridesVarArgsMethodVisitor
    extends BaseInspectionVisitor {
        private NonVarargsMethodOverridesVarArgsMethodVisitor() {
        }

        @Override
        public void visitMethod(PsiMethod method) {
            PsiMethod[] superMethods;
            super.visitMethod(method);
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters2 = parameterList.getParameters();
            if (parameters2.length == 0) {
                return;
            }
            PsiParameter parameter = parameters2[parameters2.length - 1];
            PsiType type2 = parameter.getType();
            if (!(type2 instanceof PsiArrayType) || type2 instanceof PsiEllipsisType) {
                return;
            }
            for (PsiMethod superMethod : superMethods = method.findDeepestSuperMethods()) {
                if (!superMethod.isVarArgs()) continue;
                PsiIdentifier nameIdentifier = method.getNameIdentifier();
                if (nameIdentifier != null) {
                    this.registerErrorAtOffset((PsiElement)method, nameIdentifier.getStartOffsetInParent(), nameIdentifier.getTextLength(), new Object[0]);
                }
                return;
            }
        }
    }
}

