/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.initialization;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MakeInitializerExplicitFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.InitializationUtils;
import com.siyeh.ig.psiutils.TestUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstanceVariableInitializationInspection
extends BaseInspection {
    public boolean m_ignorePrimitives = false;

    @Override
    @NotNull
    public String getID() {
        if ("InstanceVariableMayNotBeInitialized" == null) {
            InstanceVariableInitializationInspection.$$$reportNull$$$0(0);
        }
        return "InstanceVariableMayNotBeInitialized";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("instance.variable.may.not.be.initialized.display.name", new Object[0]);
        if (string == null) {
            InstanceVariableInitializationInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        Boolean junitTestCase = (Boolean)infos2[0];
        if (junitTestCase.booleanValue()) {
            String string = InspectionGadgetsBundle.message("instance.Variable.may.not.be.initialized.problem.descriptor.junit", new Object[0]);
            if (string == null) {
                InstanceVariableInitializationInspection.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("instance.variable.may.not.be.initialized.problem.descriptor", new Object[0]);
        if (string == null) {
            InstanceVariableInitializationInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("primitive.fields.ignore.option", new Object[0]), this, "m_ignorePrimitives");
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos2) {
        return new MakeInitializerExplicitFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InstanceVariableInitializationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/initialization/InstanceVariableInitializationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class InstanceVariableInitializationVisitor
    extends BaseInspectionVisitor {
        private InstanceVariableInitializationVisitor() {
        }

        @Override
        public void visitField(@NotNull PsiField field) {
            ImplicitUsageProvider[] implicitUsageProviders;
            PsiType fieldType;
            if (field == null) {
                InstanceVariableInitializationVisitor.$$$reportNull$$$0(0);
            }
            if (field.hasModifierProperty("static") || field.hasModifierProperty("final")) {
                return;
            }
            if (field.getInitializer() != null) {
                return;
            }
            if (InstanceVariableInitializationInspection.this.m_ignorePrimitives && ClassUtils.isPrimitive(fieldType = field.getType())) {
                return;
            }
            PsiClass aClass2 = field.getContainingClass();
            if (aClass2 == null) {
                return;
            }
            for (ImplicitUsageProvider provider : implicitUsageProviders = Extensions.getExtensions(ImplicitUsageProvider.EP_NAME)) {
                if (!provider.isImplicitWrite(field)) continue;
                return;
            }
            boolean isTestClass = TestUtils.isJUnitTestClass(aClass2);
            if (isTestClass && this.isInitializedInSetup(field, aClass2)) {
                return;
            }
            if (this.isInitializedInInitializer(field)) {
                return;
            }
            if (this.isInitializedInConstructors(field, aClass2)) {
                return;
            }
            if (isTestClass) {
                this.registerFieldError(field, Boolean.TRUE);
            } else {
                this.registerFieldError(field, Boolean.FALSE);
            }
        }

        private boolean isInitializedInConstructors(PsiField field, PsiClass aClass2) {
            PsiMethod[] constructors2 = aClass2.getConstructors();
            if (constructors2.length == 0) {
                return false;
            }
            for (PsiMethod constructor : constructors2) {
                if (InitializationUtils.methodAssignsVariableOrFails(constructor, field)) continue;
                return false;
            }
            return true;
        }

        private boolean isInitializedInSetup(PsiField field, PsiClass aClass2) {
            PsiMethod setupMethod = this.getSetupMethod(aClass2);
            return InitializationUtils.methodAssignsVariableOrFails(setupMethod, field);
        }

        @Nullable
        private PsiMethod getSetupMethod(@NotNull PsiClass aClass2) {
            PsiMethod[] methods2;
            if (aClass2 == null) {
                InstanceVariableInitializationVisitor.$$$reportNull$$$0(1);
            }
            for (PsiMethod method : methods2 = aClass2.findMethodsByName("setUp", false)) {
                PsiParameterList parameterList;
                if (method.hasModifierProperty("static") || (parameterList = method.getParameterList()).getParametersCount() != 0 || !PsiType.VOID.equals(method.getReturnType())) continue;
                return method;
            }
            return null;
        }

        private boolean isInitializedInInitializer(@NotNull PsiField field) {
            PsiField[] fields2;
            PsiClassInitializer[] initializers;
            PsiClass aClass2;
            if (field == null) {
                InstanceVariableInitializationVisitor.$$$reportNull$$$0(2);
            }
            if ((aClass2 = field.getContainingClass()) == null) {
                return false;
            }
            for (PsiClassInitializer initializer2 : initializers = aClass2.getInitializers()) {
                PsiCodeBlock body2;
                if (initializer2.hasModifierProperty("static") || !InitializationUtils.blockAssignsVariableOrFails(body2 = initializer2.getBody(), field)) continue;
                return true;
            }
            for (PsiField otherField : fields2 = aClass2.getFields()) {
                PsiExpression initializer3;
                if (field.equals(otherField) || otherField.hasModifierProperty("static") || !InitializationUtils.expressionAssignsVariableOrFails(initializer3 = otherField.getInitializer(), field)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/initialization/InstanceVariableInitializationInspection$InstanceVariableInitializationVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSetupMethod";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isInitializedInInitializer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

