/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.initialization;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.AddToIgnoreIfAnnotatedByListQuickFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.UninitializedReadCollector;
import java.util.ArrayList;
import java.util.List;
import org.intellij.lang.annotations.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class InstanceVariableUninitializedUseInspectionBase
extends BaseInspection {
    protected final List<String> annotationNames = new ArrayList<String>();
    public boolean m_ignorePrimitives = false;
    @NonNls
    public String annotationNamesString = "";

    public InstanceVariableUninitializedUseInspectionBase() {
        InstanceVariableUninitializedUseInspectionBase.parseString(this.annotationNamesString, this.annotationNames);
    }

    @Override
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("InstanceVariableUsedBeforeInitialized" == null) {
            InstanceVariableUninitializedUseInspectionBase.$$$reportNull$$$0(0);
        }
        return "InstanceVariableUsedBeforeInitialized";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("instance.variable.used.before.initialized.display.name", new Object[0]);
        if (string == null) {
            InstanceVariableUninitializedUseInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("instance.variable.used.before.initialized.problem.descriptor", new Object[0]);
        if (string == null) {
            InstanceVariableUninitializedUseInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            InstanceVariableUninitializedUseInspectionBase.$$$reportNull$$$0(3);
        }
        super.readSettings(element);
        InstanceVariableUninitializedUseInspectionBase.parseString(this.annotationNamesString, this.annotationNames);
    }

    @Override
    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            InstanceVariableUninitializedUseInspectionBase.$$$reportNull$$$0(4);
        }
        this.annotationNamesString = InstanceVariableUninitializedUseInspectionBase.formatString(this.annotationNames);
        super.writeSettings(element);
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos2) {
        PsiField field = (PsiField)infos2[0];
        InspectionGadgetsFix[] inspectionGadgetsFixArray = AddToIgnoreIfAnnotatedByListQuickFix.build(field, this.annotationNames);
        if (inspectionGadgetsFixArray == null) {
            InstanceVariableUninitializedUseInspectionBase.$$$reportNull$$$0(5);
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InstanceVariableInitializationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/initialization/InstanceVariableUninitializedUseInspectionBase";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/initialization/InstanceVariableUninitializedUseInspectionBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class InstanceVariableInitializationVisitor
    extends BaseInspectionVisitor {
        private InstanceVariableInitializationVisitor() {
        }

        @Override
        public void visitField(@NotNull PsiField field) {
            PsiExpression[] badReads;
            PsiType fieldType;
            if (field == null) {
                InstanceVariableInitializationVisitor.$$$reportNull$$$0(0);
            }
            if (field.hasModifierProperty("static") || field.hasModifierProperty("final")) {
                return;
            }
            if (field.getInitializer() != null) {
                return;
            }
            PsiAnnotation annotation2 = AnnotationUtil.findAnnotation((PsiModifierListOwner)field, InstanceVariableUninitializedUseInspectionBase.this.annotationNames);
            if (annotation2 != null) {
                return;
            }
            if (InstanceVariableUninitializedUseInspectionBase.this.m_ignorePrimitives && ClassUtils.isPrimitive(fieldType = field.getType())) {
                return;
            }
            PsiClass aClass2 = field.getContainingClass();
            if (aClass2 == null) {
                return;
            }
            for (ImplicitUsageProvider provider : Extensions.getExtensions(ImplicitUsageProvider.EP_NAME)) {
                if (!provider.isImplicitWrite(field)) continue;
                return;
            }
            UninitializedReadCollector uninitializedReadsCollector = new UninitializedReadCollector();
            if (!this.isInitializedInInitializer(field, uninitializedReadsCollector)) {
                PsiMethod[] constructors2;
                PsiMethod[] psiMethodArray = constructors2 = aClass2.getConstructors();
                int n = psiMethodArray.length;
                for (int j = 0; j < n; ++j) {
                    PsiMethod constructor = psiMethodArray[j];
                    PsiCodeBlock body2 = constructor.getBody();
                    uninitializedReadsCollector.blockAssignsVariable(body2, field);
                }
            }
            for (PsiExpression expression2 : badReads = uninitializedReadsCollector.getUninitializedReads()) {
                this.registerError((PsiElement)expression2, field);
            }
        }

        private boolean isInitializedInInitializer(@NotNull PsiField field, UninitializedReadCollector uninitializedReadsCollector) {
            PsiClassInitializer[] initializers;
            PsiClass aClass2;
            if (field == null) {
                InstanceVariableInitializationVisitor.$$$reportNull$$$0(1);
            }
            if ((aClass2 = field.getContainingClass()) == null) {
                return false;
            }
            for (PsiClassInitializer initializer2 : initializers = aClass2.getInitializers()) {
                PsiCodeBlock body2;
                if (initializer2.hasModifierProperty("static") || !uninitializedReadsCollector.blockAssignsVariable(body2 = initializer2.getBody(), field)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "field";
            objectArray2[1] = "com/siyeh/ig/initialization/InstanceVariableUninitializedUseInspectionBase$InstanceVariableInitializationVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isInitializedInInitializer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

