/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.internationalization;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.Nullable;

public class NonNlsUtils {
    private static final Key<Boolean> KEY = new Key("IG_NON_NLS_ANNOTATED_USE");

    private NonNlsUtils() {
    }

    @Nullable
    public static PsiModifierListOwner getAnnotatableArgument(PsiMethodCallExpression methodCallExpression) {
        PsiReferenceExpression referenceExpression;
        PsiElement element;
        PsiExpressionList argumentList2 = methodCallExpression.getArgumentList();
        PsiExpression[] arguments2 = argumentList2.getExpressions();
        if (arguments2.length < 1) {
            return null;
        }
        PsiExpression argument = arguments2[0];
        if (argument instanceof PsiReferenceExpression && (element = (referenceExpression = (PsiReferenceExpression)argument).resolve()) instanceof PsiModifierListOwner) {
            return (PsiModifierListOwner)element;
        }
        return null;
    }

    @Nullable
    public static PsiModifierListOwner getAnnotatableQualifier(PsiReferenceExpression expression2) {
        PsiReferenceExpression referenceExpression;
        PsiElement element;
        PsiExpression qualifierExpression = expression2.getQualifierExpression();
        if (qualifierExpression instanceof PsiReferenceExpression && (element = (referenceExpression = (PsiReferenceExpression)qualifierExpression).resolve()) instanceof PsiModifierListOwner) {
            return (PsiModifierListOwner)element;
        }
        return null;
    }

    public static boolean isNonNlsAnnotated(@Nullable PsiExpression expression2) {
        if (NonNlsUtils.isReferenceToNonNlsAnnotatedElement(expression2)) {
            return true;
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (NonNlsUtils.isNonNlsAnnotatedModifierListOwner(method)) {
                return true;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            return NonNlsUtils.isNonNlsAnnotated(qualifier);
        }
        if (expression2 instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)expression2;
            PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            return NonNlsUtils.isNonNlsAnnotated(arrayExpression);
        }
        return false;
    }

    public static boolean isNonNlsAnnotatedUse(@Nullable PsiExpression expression2) {
        boolean result2;
        if (expression2 == null) {
            return false;
        }
        Boolean value = NonNlsUtils.getCachedValue(expression2, KEY);
        if (value != null) {
            return value;
        }
        Object element = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiExpressionList.class, PsiAssignmentExpression.class, PsiVariable.class, PsiReturnStatement.class);
        if (element instanceof PsiExpressionList) {
            PsiExpressionList expressionList = (PsiExpressionList)element;
            result2 = NonNlsUtils.isNonNlsAnnotatedParameter(expression2, expressionList);
        } else if (element instanceof PsiVariable) {
            result2 = NonNlsUtils.isNonNlsAnnotatedModifierListOwner(element);
        } else if (element instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)element;
            result2 = NonNlsUtils.isAssignmentToNonNlsAnnotatedVariable(assignmentExpression);
        } else if (element instanceof PsiReturnStatement) {
            PsiMethod method = PsiTreeUtil.getParentOfType(element, PsiMethod.class);
            result2 = NonNlsUtils.isNonNlsAnnotatedModifierListOwner(method);
        } else {
            result2 = false;
        }
        NonNlsUtils.putCachedValue(expression2, KEY, result2);
        return result2;
    }

    private static <T> void putCachedValue(PsiExpression expression2, Key<T> key, T value) {
        if (expression2 instanceof PsiBinaryExpression) {
            expression2.putUserData(key, value);
        }
    }

    @Nullable
    private static <T> T getCachedValue(PsiExpression expression2, Key<T> key) {
        PsiExpression rhs;
        T data2 = expression2.getUserData(key);
        if (!(expression2 instanceof PsiBinaryExpression)) {
            return data2;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
        PsiExpression lhs = binaryExpression.getLOperand();
        Object childData = null;
        if (lhs instanceof PsiBinaryExpression) {
            childData = lhs.getUserData(key);
        }
        if (childData == null && (rhs = binaryExpression.getROperand()) instanceof PsiBinaryExpression) {
            childData = rhs.getUserData(key);
        }
        if (childData != data2) {
            expression2.putUserData(key, childData);
        }
        return childData;
    }

    private static boolean isAssignmentToNonNlsAnnotatedVariable(PsiAssignmentExpression assignmentExpression) {
        PsiExpression lhs = assignmentExpression.getLExpression();
        return NonNlsUtils.isReferenceToNonNlsAnnotatedElement(lhs);
    }

    private static boolean isReferenceToNonNlsAnnotatedElement(@Nullable PsiExpression expression2) {
        if (!(expression2 instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
        PsiElement target = referenceExpression.resolve();
        return NonNlsUtils.isNonNlsAnnotatedModifierListOwner(target);
    }

    private static boolean isNonNlsAnnotatedParameter(PsiExpression expression2, PsiExpressionList expressionList) {
        PsiParameterList parameterList;
        PsiElement parent2 = expressionList.getParent();
        if (parent2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)parent2;
            if (NonNlsUtils.isQualifierNonNlsAnnotated(methodCallExpression)) {
                return true;
            }
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            parameterList = method.getParameterList();
        } else if (parent2 instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)parent2;
            PsiMethod constructor = newExpression.resolveConstructor();
            if (constructor == null) {
                return false;
            }
            parameterList = constructor.getParameterList();
        } else {
            return false;
        }
        PsiExpression[] expressions = expressionList.getExpressions();
        int index2 = -1;
        for (int i2 = 0; i2 < expressions.length; ++i2) {
            PsiExpression argument = expressions[i2];
            if (!PsiTreeUtil.isAncestor(argument, expression2, false)) continue;
            index2 = i2;
        }
        PsiParameter[] parameters2 = parameterList.getParameters();
        if (parameters2.length == 0) {
            return false;
        }
        PsiParameter parameter = index2 < parameters2.length ? parameters2[index2] : parameters2[parameters2.length - 1];
        return NonNlsUtils.isNonNlsAnnotatedModifierListOwner(parameter);
    }

    private static boolean isQualifierNonNlsAnnotated(PsiMethodCallExpression methodCallExpression) {
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (NonNlsUtils.isReferenceToNonNlsAnnotatedElement(qualifier)) {
            return true;
        }
        if (qualifier instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression expression2;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            if (MethodUtils.isChainable(method) && NonNlsUtils.isQualifierNonNlsAnnotated(expression2 = (PsiMethodCallExpression)qualifier)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isNonNlsAnnotatedModifierListOwner(@Nullable PsiElement element) {
        if (!(element instanceof PsiModifierListOwner)) {
            return false;
        }
        PsiModifierListOwner variable2 = (PsiModifierListOwner)element;
        return AnnotationUtil.isAnnotated(variable2, "org.jetbrains.annotations.NonNls", false, false);
    }
}

