/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javabeans;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PropertyUtilBase;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class FieldHasSetterButNoGetterInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("field.has.setter.but.no.getter.display.name", new Object[0]);
        if (string == null) {
            FieldHasSetterButNoGetterInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("field.has.setter.but.no.getter.problem.descriptor", new Object[0]);
        if (string == null) {
            FieldHasSetterButNoGetterInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FieldHasSetterButNoGetterVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/javabeans/FieldHasSetterButNoGetterInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class FieldHasSetterButNoGetterVisitor
    extends BaseInspectionVisitor {
        private FieldHasSetterButNoGetterVisitor() {
        }

        @Override
        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                FieldHasSetterButNoGetterVisitor.$$$reportNull$$$0(0);
            }
            String propertyName = PropertyUtilBase.suggestPropertyName(field);
            boolean isStatic = field.hasModifierProperty("static");
            PsiClass containingClass = field.getContainingClass();
            PsiMethod setter2 = PropertyUtilBase.findPropertySetter(containingClass, propertyName, isStatic, false);
            if (setter2 == null) {
                return;
            }
            PsiMethod getter2 = PropertyUtilBase.findPropertyGetter(containingClass, propertyName, isStatic, false);
            if (getter2 != null) {
                return;
            }
            this.registerFieldError(field, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/javabeans/FieldHasSetterButNoGetterInspection$FieldHasSetterButNoGetterVisitor", "visitField"));
        }
    }
}

