/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ImportUtils;
import org.jetbrains.annotations.NotNull;

class ReplaceAssertEqualsFix
extends InspectionGadgetsFix {
    private final String myMethodName;

    public ReplaceAssertEqualsFix(String methodName) {
        this.myMethodName = methodName;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("replace.assertequals.quickfix", this.myMethodName);
        if (string == null) {
            ReplaceAssertEqualsFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
        PsiElement element = descriptor2.getPsiElement();
        PsiElement parent2 = element.getParent();
        if (!(parent2 instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression methodExpression = (PsiReferenceExpression)parent2;
        PsiElement grandParent = methodExpression.getParent();
        if (!(grandParent instanceof PsiMethodCallExpression)) {
            return;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return;
        }
        String className2 = containingClass.getQualifiedName();
        if (className2 == null) {
            return;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier == null && ImportUtils.addStaticImport(className2, this.myMethodName, methodExpression)) {
            PsiReplacementUtil.replaceExpression(methodExpression, this.myMethodName);
        } else {
            PsiReplacementUtil.replaceExpression(methodExpression, StringUtil.getQualifiedName(className2, this.myMethodName));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/ReplaceAssertEqualsFix", "getFamilyName"));
    }
}

