/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.maturity;

import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressionAnnotationInspectionBase
extends BaseInspection {
    public List<String> myAllowedSuppressions = new ArrayList<String>();

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("inspection.suppression.annotation.display.name", new Object[0]);
        if (string == null) {
            SuppressionAnnotationInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("inspection.suppression.annotation.problem.descriptor", new Object[0]);
        if (string == null) {
            SuppressionAnnotationInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isSuppressedFor(@NotNull PsiElement element) {
        if (element == null) {
            SuppressionAnnotationInspectionBase.$$$reportNull$$$0(2);
        }
        return false;
    }

    @Override
    @NotNull
    public SuppressQuickFix[] getBatchSuppressActions(@Nullable PsiElement element) {
        if (SuppressQuickFix.EMPTY_ARRAY == null) {
            SuppressionAnnotationInspectionBase.$$$reportNull$$$0(3);
        }
        return SuppressQuickFix.EMPTY_ARRAY;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SuppressionAnnotationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/maturity/SuppressionAnnotationInspectionBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/maturity/SuppressionAnnotationInspectionBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBatchSuppressActions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SuppressionAnnotationVisitor
    extends BaseInspectionVisitor {
        private SuppressionAnnotationVisitor() {
        }

        @Override
        public void visitComment(PsiComment comment) {
            super.visitComment(comment);
            IElementType tokenType = comment.getTokenType();
            if (!tokenType.equals(JavaTokenType.END_OF_LINE_COMMENT) && !tokenType.equals(JavaTokenType.C_STYLE_COMMENT)) {
                return;
            }
            String commentText = comment.getText();
            if (commentText.length() <= 2) {
                return;
            }
            String strippedComment = commentText.substring(2).trim();
            if (!strippedComment.startsWith("noinspection")) {
                return;
            }
            String suppressedIds = JavaSuppressionUtil.getSuppressedInspectionIdsIn(comment);
            if (suppressedIds == null) {
                this.registerError((PsiElement)comment, comment, Boolean.FALSE);
                return;
            }
            Iterable<String> ids = StringUtil.tokenize(suppressedIds, ",");
            for (String id : ids) {
                if (SuppressionAnnotationInspectionBase.this.myAllowedSuppressions.contains(id)) continue;
                this.registerError((PsiElement)comment, comment, Boolean.TRUE);
                break;
            }
        }

        @Override
        public void visitAnnotation(PsiAnnotation annotation2) {
            PsiElement annotationParent;
            super.visitAnnotation(annotation2);
            PsiJavaCodeReferenceElement reference = annotation2.getNameReferenceElement();
            if (reference == null) {
                return;
            }
            String text2 = reference.getText();
            if (("SuppressWarnings".equals(text2) || "java.lang.SuppressWarnings".equals(text2)) && (annotationParent = annotation2.getParent()) instanceof PsiModifierList) {
                Collection<String> ids = JavaSuppressionUtil.getInspectionIdsSuppressedInAnnotation((PsiModifierList)annotationParent);
                if (!SuppressionAnnotationInspectionBase.this.myAllowedSuppressions.containsAll(ids)) {
                    this.registerError((PsiElement)annotation2, annotation2, Boolean.TRUE);
                } else if (ids.isEmpty()) {
                    this.registerError((PsiElement)annotation2, annotation2, Boolean.FALSE);
                }
            }
        }
    }
}

