/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.memory;

import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiNewExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public class ZeroLengthArrayInitializationInspectionBase
extends BaseInspection {
    @Override
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("ZeroLengthArrayAllocation" == null) {
            ZeroLengthArrayInitializationInspectionBase.$$$reportNull$$$0(0);
        }
        return "ZeroLengthArrayAllocation";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("array.allocation.zero.length.display.name", new Object[0]);
        if (string == null) {
            ZeroLengthArrayInitializationInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("array.allocation.zero.length.problem.descriptor", new Object[0]);
        if (string == null) {
            ZeroLengthArrayInitializationInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ZeroLengthArrayInitializationVisitor();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/memory/ZeroLengthArrayInitializationInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ZeroLengthArrayInitializationVisitor
    extends BaseInspectionVisitor {
        private ZeroLengthArrayInitializationVisitor() {
        }

        @Override
        public void visitNewExpression(@NotNull PsiNewExpression expression2) {
            if (expression2 == null) {
                ZeroLengthArrayInitializationVisitor.$$$reportNull$$$0(0);
            }
            super.visitNewExpression(expression2);
            if (!ConstructionUtils.isEmptyArrayInitializer(expression2)) {
                return;
            }
            if (ExpressionUtils.isDeclaredConstant(expression2)) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }

        @Override
        public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression2) {
            super.visitArrayInitializerExpression(expression2);
            PsiExpression[] initializers = expression2.getInitializers();
            if (initializers.length > 0) {
                return;
            }
            if (expression2.getParent() instanceof PsiNewExpression) {
                return;
            }
            if (ExpressionUtils.isDeclaredConstant(expression2)) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/memory/ZeroLengthArrayInitializationInspectionBase$ZeroLengthArrayInitializationVisitor", "visitNewExpression"));
        }
    }
}

