/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringBufferReplaceableByStringBuilderInspection
extends BaseInspection {
    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String getID() {
        if ("StringBufferMayBeStringBuilder" == null) {
            StringBufferReplaceableByStringBuilderInspection.$$$reportNull$$$0(0);
        }
        return "StringBufferMayBeStringBuilder";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.buffer.replaceable.by.string.builder.display.name", new Object[0]);
        if (string == null) {
            StringBufferReplaceableByStringBuilderInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("string.buffer.replaceable.by.string.builder.problem.descriptor", new Object[0]);
        if (string == null) {
            StringBufferReplaceableByStringBuilderInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos2) {
        return new StringBufferMayBeStringBuilderFix();
    }

    @Nullable
    private static PsiNewExpression getNewStringBuffer(PsiExpression expression2) {
        if (expression2 == null) {
            return null;
        }
        if (expression2 instanceof PsiNewExpression) {
            return (PsiNewExpression)expression2;
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"append".equals(methodName)) {
                return null;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            return StringBufferReplaceableByStringBuilderInspection.getNewStringBuffer(qualifier);
        }
        return null;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringBufferReplaceableByStringBuilderVisitor();
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel5OrHigher(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/migration/StringBufferReplaceableByStringBuilderInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class StringBufferReplaceableByStringBuilderVisitor
    extends BaseInspectionVisitor {
        private static final Set<String> excludes = ContainerUtil.newHashSet("java.lang.StringBuilder", "java.lang.StringBuffer");

        private StringBufferReplaceableByStringBuilderVisitor() {
        }

        @Override
        public void visitDeclarationStatement(PsiDeclarationStatement statement2) {
            super.visitDeclarationStatement(statement2);
            PsiElement[] declaredElements = statement2.getDeclaredElements();
            if (declaredElements.length == 0) {
                return;
            }
            for (PsiElement declaredElement : declaredElements) {
                if (!(declaredElement instanceof PsiLocalVariable)) {
                    return;
                }
                PsiLocalVariable variable2 = (PsiLocalVariable)declaredElement;
                PsiCodeBlock context = PsiTreeUtil.getParentOfType((PsiElement)variable2, PsiCodeBlock.class, true, PsiClass.class);
                if (StringBufferReplaceableByStringBuilderVisitor.isReplaceableStringBuffer(variable2, context)) continue;
                return;
            }
            PsiLocalVariable firstVariable = (PsiLocalVariable)declaredElements[0];
            this.registerVariableError(firstVariable, new Object[0]);
        }

        private static boolean isReplaceableStringBuffer(PsiVariable variable2, PsiElement context) {
            if (context == null) {
                return false;
            }
            PsiType type2 = variable2.getType();
            if (!TypeUtils.typeEquals("java.lang.StringBuffer", type2)) {
                return false;
            }
            PsiExpression initializer2 = variable2.getInitializer();
            if (initializer2 == null) {
                return false;
            }
            if (StringBufferReplaceableByStringBuilderInspection.getNewStringBuffer(initializer2) == null) {
                return false;
            }
            if (VariableAccessUtils.variableIsAssigned(variable2, context)) {
                return false;
            }
            if (VariableAccessUtils.variableIsAssignedFrom(variable2, context)) {
                return false;
            }
            if (VariableAccessUtils.variableIsReturned(variable2, context, true)) {
                return false;
            }
            if (VariableAccessUtils.variableIsUsedInInnerClass(variable2, context)) {
                return false;
            }
            return !VariableAccessUtils.variableIsPassedAsMethodArgument(variable2, context, true, call2 -> {
                PsiMethod method = call2.resolveMethod();
                if (method == null) {
                    return false;
                }
                PsiClass aClass2 = method.getContainingClass();
                return aClass2 != null && excludes.contains(aClass2.getQualifiedName());
            });
        }
    }

    private static class StringBufferMayBeStringBuilderFix
    extends InspectionGadgetsFix {
        private StringBufferMayBeStringBuilderFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("string.buffer.replaceable.by.string.builder.replace.quickfix", new Object[0]);
            if (string == null) {
                StringBufferMayBeStringBuilderFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement[] declaredElements;
            PsiElement element = descriptor2.getPsiElement();
            PsiElement parent2 = element.getParent();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
            PsiClass stringBuilderClass = psiFacade.findClass("java.lang.StringBuilder", element.getResolveScope());
            if (stringBuilderClass == null) {
                return;
            }
            PsiElementFactory factory2 = psiFacade.getElementFactory();
            PsiJavaCodeReferenceElement stringBuilderClassReference = factory2.createClassReferenceElement(stringBuilderClass);
            PsiClassType stringBuilderType = factory2.createType(stringBuilderClass);
            PsiTypeElement stringBuilderTypeElement = factory2.createTypeElement(stringBuilderType);
            PsiElement grandParent = parent2.getParent();
            if (!(grandParent instanceof PsiDeclarationStatement)) {
                return;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)grandParent;
            for (PsiElement declaredElement : declaredElements = declarationStatement.getDeclaredElements()) {
                if (!(declaredElement instanceof PsiVariable)) continue;
                StringBufferMayBeStringBuilderFix.replaceWithStringBuilder(stringBuilderClassReference, stringBuilderTypeElement, (PsiVariable)declaredElement);
            }
        }

        private static void replaceWithStringBuilder(PsiJavaCodeReferenceElement newClassReference, PsiTypeElement newTypeElement, PsiVariable variable2) {
            PsiNewExpression initializer2 = StringBufferReplaceableByStringBuilderInspection.getNewStringBuffer(variable2.getInitializer());
            if (initializer2 == null) {
                return;
            }
            PsiNewExpression newExpression = initializer2;
            PsiJavaCodeReferenceElement classReference = newExpression.getClassReference();
            if (classReference == null) {
                return;
            }
            PsiTypeElement typeElement = variable2.getTypeElement();
            if (typeElement != null && typeElement.getParent() == variable2) {
                typeElement.replace(newTypeElement);
            }
            classReference.replace(newClassReference);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/StringBufferReplaceableByStringBuilderInspection$StringBufferMayBeStringBuilderFix", "getFamilyName"));
        }
    }
}

