/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.IntArrayList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class LambdaUnfriendlyMethodOverloadInspectionBase
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("lambda.unfriendly.method.overload.display.name", new Object[0]);
        if (string == null) {
            LambdaUnfriendlyMethodOverloadInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        PsiMethod method = (PsiMethod)infos2[0];
        String string = InspectionGadgetsBundle.message(method.isConstructor() ? "lambda.unfriendly.constructor.overload.problem.descriptor" : "lambda.unfriendly.method.overload.problem.descriptor", new Object[0]);
        if (string == null) {
            LambdaUnfriendlyMethodOverloadInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LambdaUnfriendlyMethodOverloadVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/naming/LambdaUnfriendlyMethodOverloadInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class LambdaUnfriendlyMethodOverloadVisitor
    extends BaseInspectionVisitor {
        private LambdaUnfriendlyMethodOverloadVisitor() {
        }

        @Override
        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            PsiParameterList parameterList = method.getParameterList();
            int parametersCount = parameterList.getParametersCount();
            if (parametersCount == 0) {
                return;
            }
            PsiParameter[] parameters2 = parameterList.getParameters();
            IntArrayList functionalIndices = new IntArrayList(2);
            for (int i2 = 0; i2 < parameters2.length; ++i2) {
                PsiParameter parameter = parameters2[i2];
                if (!LambdaUtil.isFunctionalType(parameter.getType())) continue;
                functionalIndices.add(i2);
            }
            if (functionalIndices.isEmpty()) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (MethodUtils.hasSuper(method)) {
                return;
            }
            String name = method.getName();
            block1: for (PsiMethod sameNameMethod : containingClass.findMethodsByName(name, true)) {
                PsiParameter[] otherParameters;
                PsiParameterList otherParameterList;
                if (method.equals(sameNameMethod) || PsiSuperMethodUtil.isSuperMethod(method, sameNameMethod) || parametersCount != (otherParameterList = sameNameMethod.getParameterList()).getParametersCount() || !LambdaUnfriendlyMethodOverloadVisitor.areOtherParameterTypesConvertible(parameters2, otherParameters = otherParameterList.getParameters(), functionalIndices)) continue;
                int max = functionalIndices.size();
                boolean equalTypes = true;
                for (int i3 = 0; i3 < max; ++i3) {
                    PsiType functionalType;
                    int index2 = functionalIndices.get(i3);
                    PsiType otherFunctionalType = otherParameters[index2].getType();
                    if (!LambdaUtil.isFunctionalType(otherFunctionalType) || !LambdaUnfriendlyMethodOverloadVisitor.areSameShapeFunctionalTypes(functionalType = parameters2[index2].getType(), otherFunctionalType)) continue block1;
                    equalTypes &= Objects.equals(TypeConversionUtil.erasure(functionalType), TypeConversionUtil.erasure(otherFunctionalType));
                }
                if (equalTypes) continue;
                this.registerMethodError(method, method);
                return;
            }
        }

        private static boolean areSameShapeFunctionalTypes(PsiType one, PsiType two) {
            PsiMethod method1 = LambdaUtil.getFunctionalInterfaceMethod(one);
            PsiMethod method2 = LambdaUtil.getFunctionalInterfaceMethod(two);
            if (method1 == null || method2 == null) {
                return false;
            }
            PsiType returnType1 = method1.getReturnType();
            PsiType returnType2 = method2.getReturnType();
            if (PsiType.VOID.equals(returnType1) ^ PsiType.VOID.equals(returnType2)) {
                return false;
            }
            return method1.getParameterList().getParametersCount() == method2.getParameterList().getParametersCount();
        }

        private static boolean areOtherParameterTypesConvertible(PsiParameter[] parameters2, PsiParameter[] otherParameters, IntArrayList ignores) {
            for (int i2 = 0; i2 < parameters2.length; ++i2) {
                PsiType otherType;
                PsiType type2;
                if (ignores.contains(i2) || (type2 = TypeConversionUtil.erasure(parameters2[i2].getType())).isAssignableFrom(otherType = TypeConversionUtil.erasure(otherParameters[i2].getType())) || otherType.isAssignableFrom(type2)) continue;
                return false;
            }
            return true;
        }
    }
}

