/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DoubleLiteralMayBeFloatLiteralInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("double.literal.may.be.float.literal.display.name", new Object[0]);
        if (string == null) {
            DoubleLiteralMayBeFloatLiteralInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)infos2[0];
        StringBuilder replacementText = DoubleLiteralMayBeFloatLiteralInspection.buildReplacementText(typeCastExpression, new StringBuilder());
        String string = InspectionGadgetsBundle.message("double.literal.may.be.float.literal.problem.descriptor", replacementText);
        if (string == null) {
            DoubleLiteralMayBeFloatLiteralInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)infos2[0];
        StringBuilder replacementText = DoubleLiteralMayBeFloatLiteralInspection.buildReplacementText(typeCastExpression, new StringBuilder());
        return new DoubleLiteralMayBeFloatLiteralFix(replacementText.toString());
    }

    private static StringBuilder buildReplacementText(PsiExpression expression2, StringBuilder out) {
        if (expression2 instanceof PsiLiteralExpression) {
            out.append(expression2.getText());
            out.append('f');
        } else {
            if (expression2 instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression2;
                PsiJavaToken sign = prefixExpression.getOperationSign();
                out.append(sign.getText());
                return DoubleLiteralMayBeFloatLiteralInspection.buildReplacementText(prefixExpression.getOperand(), out);
            }
            if (expression2 instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
                out.append('(');
                DoubleLiteralMayBeFloatLiteralInspection.buildReplacementText(parenthesizedExpression.getExpression(), out);
                out.append(')');
            } else if (expression2 instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression2;
                PsiExpression operand = typeCastExpression.getOperand();
                DoubleLiteralMayBeFloatLiteralInspection.buildReplacementText(operand, out);
            } else assert (false);
        }
        return out;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DoubleLiteralMayBeFloatLiteralVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/numeric/DoubleLiteralMayBeFloatLiteralInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class DoubleLiteralMayBeFloatLiteralVisitor
    extends BaseInspectionVisitor {
        private DoubleLiteralMayBeFloatLiteralVisitor() {
        }

        @Override
        public void visitLiteralExpression(PsiLiteralExpression expression2) {
            super.visitLiteralExpression(expression2);
            PsiType type2 = expression2.getType();
            if (!PsiType.DOUBLE.equals(type2)) {
                return;
            }
            PsiElement parent2 = expression2.getParent();
            while (parent2 instanceof PsiPrefixExpression || parent2 instanceof PsiParenthesizedExpression) {
                parent2 = parent2.getParent();
            }
            if (!(parent2 instanceof PsiTypeCastExpression)) {
                return;
            }
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)parent2;
            PsiType castType = typeCastExpression.getType();
            if (!PsiType.FLOAT.equals(castType)) {
                return;
            }
            this.registerError((PsiElement)typeCastExpression, typeCastExpression);
        }
    }

    private static class DoubleLiteralMayBeFloatLiteralFix
    extends InspectionGadgetsFix {
        private final String replacementString;

        public DoubleLiteralMayBeFloatLiteralFix(String replacementString) {
            this.replacementString = replacementString;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("double.literal.may.be.float.literal.quickfix", this.replacementString);
            if (string == null) {
                DoubleLiteralMayBeFloatLiteralFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Replace with 'float'" == null) {
                DoubleLiteralMayBeFloatLiteralFix.$$$reportNull$$$0(1);
            }
            return "Replace with 'float'";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement element = descriptor2.getPsiElement();
            if (!(element instanceof PsiTypeCastExpression)) {
                return;
            }
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)element;
            PsiReplacementUtil.replaceExpression(typeCastExpression, this.replacementString);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/numeric/DoubleLiteralMayBeFloatLiteralInspection$DoubleLiteralMayBeFloatLiteralFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

