/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplicitNumericConversionInspection
extends BaseInspection {
    public boolean ignoreWideningConversions = false;
    public boolean ignoreCharConversions = false;
    public boolean ignoreConstantConversions = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("implicit.numeric.conversion.display.name", new Object[0]);
        if (string == null) {
            ImplicitNumericConversionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("implicit.numeric.conversion.ignore.widening.conversion.option", new Object[0]), "ignoreWideningConversions");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("implicit.numeric.conversion.ignore.char.conversion.option", new Object[0]), "ignoreCharConversions");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("implicit.numeric.conversion.ignore.constant.conversion.option", new Object[0]), "ignoreConstantConversions");
        return optionsPanel;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        PsiType type2 = (PsiType)infos2[1];
        PsiType expectedType2 = (PsiType)infos2[2];
        String string = InspectionGadgetsBundle.message("implicit.numeric.conversion.problem.descriptor", type2.getPresentableText(), expectedType2.getPresentableText());
        if (string == null) {
            ImplicitNumericConversionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ImplicitNumericConversionVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos2) {
        return new ImplicitNumericConversionFix((PsiExpression)infos2[0], (PsiType)infos2[2]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/numeric/ImplicitNumericConversionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ImplicitNumericConversionVisitor
    extends BaseInspectionVisitor {
        private ImplicitNumericConversionVisitor() {
        }

        @Override
        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            super.visitPolyadicExpression(expression2);
            this.checkExpression(expression2);
        }

        @Override
        public void visitConditionalExpression(PsiConditionalExpression expression2) {
            super.visitConditionalExpression(expression2);
            this.checkExpression(expression2);
        }

        @Override
        public void visitLiteralExpression(PsiLiteralExpression expression2) {
            super.visitLiteralExpression(expression2);
            this.checkExpression(expression2);
        }

        @Override
        public void visitUnaryExpression(PsiUnaryExpression expression2) {
            super.visitUnaryExpression(expression2);
            this.checkExpression(expression2);
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            super.visitReferenceExpression(expression2);
            this.checkExpression(expression2);
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            this.checkExpression(expression2);
        }

        @Override
        public void visitTypeCastExpression(PsiTypeCastExpression expression2) {
            super.visitTypeCastExpression(expression2);
            this.checkExpression(expression2);
        }

        @Override
        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            super.visitAssignmentExpression(expression2);
            this.checkExpression(expression2);
        }

        @Override
        public void visitParenthesizedExpression(PsiParenthesizedExpression expression2) {
            super.visitParenthesizedExpression(expression2);
            this.checkExpression(expression2);
        }

        private void checkExpression(PsiExpression expression2) {
            PsiType expressionType;
            PsiElement parent2 = expression2.getParent();
            if (parent2 instanceof PsiParenthesizedExpression) {
                return;
            }
            if (ImplicitNumericConversionInspection.this.ignoreConstantConversions) {
                PsiExpression rootExpression = expression2;
                while (rootExpression instanceof PsiParenthesizedExpression) {
                    PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)rootExpression;
                    rootExpression = parenthesizedExpression.getExpression();
                }
                if (rootExpression instanceof PsiLiteralExpression || PsiUtil.isConstantExpression(rootExpression)) {
                    return;
                }
            }
            if ((expressionType = expression2.getType()) == null || !ClassUtils.isPrimitiveNumericType(expressionType)) {
                return;
            }
            if (PsiType.CHAR.equals(expressionType) && (ImplicitNumericConversionInspection.this.ignoreCharConversions || this.isArgumentOfStringIndexOf(parent2))) {
                return;
            }
            PsiType expectedType2 = ExpectedTypeUtils.findExpectedType(expression2, true);
            if (!ClassUtils.isPrimitiveNumericType(expectedType2)) {
                return;
            }
            if (expressionType.equals(expectedType2)) {
                return;
            }
            if (ImplicitNumericConversionInspection.this.ignoreWideningConversions && !TypeUtils.isNarrowingConversion(expressionType, expectedType2)) {
                return;
            }
            if (ImplicitNumericConversionInspection.this.ignoreCharConversions && PsiType.CHAR.equals(expectedType2)) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2, expressionType, expectedType2);
        }

        private boolean isArgumentOfStringIndexOf(PsiElement parent2) {
            if (!(parent2 instanceof PsiExpressionList)) {
                return false;
            }
            PsiElement grandParent = parent2.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"indexOf".equals(methodName) && !"lastIndexOf".equals(methodName)) {
                return false;
            }
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass2 = method.getContainingClass();
            if (aClass2 == null) {
                return false;
            }
            String className2 = aClass2.getQualifiedName();
            return "java.lang.String".equals(className2);
        }
    }

    private static class ImplicitNumericConversionFix
    extends InspectionGadgetsFix {
        private final String m_name;

        ImplicitNumericConversionFix(PsiExpression expression2, PsiType expectedType2) {
            String convertedExpression = ImplicitNumericConversionFix.convertExpression(expression2, expectedType2);
            this.m_name = convertedExpression != null ? InspectionGadgetsBundle.message("implicit.numeric.conversion.convert.quickfix", convertedExpression) : InspectionGadgetsBundle.message("implicit.numeric.conversion.make.explicit.quickfix", new Object[0]);
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("implicit.numeric.conversion.make.explicit.quickfix", new Object[0]);
            if (string == null) {
                ImplicitNumericConversionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.m_name;
            if (string == null) {
                ImplicitNumericConversionFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiExpression expression2 = (PsiExpression)descriptor2.getPsiElement();
            PsiType expectedType2 = ExpectedTypeUtils.findExpectedType(expression2, true);
            if (expectedType2 == null) {
                return;
            }
            String convertedExpression = ImplicitNumericConversionFix.convertExpression(expression2, expectedType2);
            if (convertedExpression != null) {
                PsiReplacementUtil.replaceExpression(expression2, convertedExpression);
            } else {
                PsiAssignmentExpression assignmentExpression;
                PsiJavaToken sign;
                PsiElement parent2 = expression2.getParent();
                if (parent2 instanceof PsiAssignmentExpression && !JavaTokenType.EQ.equals((sign = (assignmentExpression = (PsiAssignmentExpression)parent2).getOperationSign()).getTokenType())) {
                    String lhsText = assignmentExpression.getLExpression().getText();
                    String newExpressionText = lhsText + "=(" + expectedType2.getCanonicalText() + ")(" + lhsText + sign.getText().charAt(0) + expression2.getText() + ')';
                    PsiReplacementUtil.replaceExpression(assignmentExpression, newExpressionText);
                    return;
                }
                String castExpression = ParenthesesUtils.getPrecedence(expression2) <= 4 ? '(' + expectedType2.getCanonicalText() + ')' + expression2.getText() : '(' + expectedType2.getCanonicalText() + ")(" + expression2.getText() + ')';
                PsiReplacementUtil.replaceExpression(expression2, castExpression);
            }
        }

        @Nullable
        @NonNls
        private static String convertExpression(PsiExpression expression2, PsiType expectedType2) {
            if (!(expression2 instanceof PsiLiteralExpression) && !ImplicitNumericConversionFix.isNegatedLiteral(expression2)) {
                return null;
            }
            PsiType expressionType = expression2.getType();
            if (expressionType == null) {
                return null;
            }
            String text2 = expression2.getText();
            if (expressionType.equals(PsiType.INT) && expectedType2.equals(PsiType.LONG)) {
                return text2 + 'L';
            }
            if (expressionType.equals(PsiType.INT) && expectedType2.equals(PsiType.FLOAT)) {
                if (!ImplicitNumericConversionFix.isDecimalLiteral(text2)) {
                    return null;
                }
                return text2 + ".0F";
            }
            if (expressionType.equals(PsiType.INT) && expectedType2.equals(PsiType.DOUBLE)) {
                if (!ImplicitNumericConversionFix.isDecimalLiteral(text2)) {
                    return null;
                }
                return text2 + ".0";
            }
            if (expressionType.equals(PsiType.LONG) && expectedType2.equals(PsiType.FLOAT)) {
                if (!ImplicitNumericConversionFix.isDecimalLiteral(text2)) {
                    return null;
                }
                return text2.substring(0, text2.length() - 1) + ".0F";
            }
            if (expressionType.equals(PsiType.LONG) && expectedType2.equals(PsiType.DOUBLE)) {
                if (!ImplicitNumericConversionFix.isDecimalLiteral(text2)) {
                    return null;
                }
                return text2.substring(0, text2.length() - 1) + ".0";
            }
            if (expressionType.equals(PsiType.DOUBLE) && expectedType2.equals(PsiType.FLOAT)) {
                int length = text2.length();
                if (text2.charAt(length - 1) == 'd' || text2.charAt(length - 1) == 'D') {
                    return text2.substring(0, length - 1) + 'F';
                }
                return text2 + 'F';
            }
            if (expressionType.equals(PsiType.FLOAT) && expectedType2.equals(PsiType.DOUBLE)) {
                int length = text2.length();
                return text2.substring(0, length - 1);
            }
            return null;
        }

        private static boolean isDecimalLiteral(String text2) {
            return text2.length() > 0 && text2.charAt(0) != '0';
        }

        private static boolean isNegatedLiteral(PsiExpression expression2) {
            if (!(expression2 instanceof PsiPrefixExpression)) {
                return false;
            }
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression2;
            IElementType tokenType = prefixExpression.getOperationTokenType();
            if (!JavaTokenType.MINUS.equals(tokenType)) {
                return false;
            }
            PsiExpression operand = prefixExpression.getOperand();
            return operand instanceof PsiLiteralExpression;
        }

        private static boolean isIntegral(@Nullable PsiType expressionType) {
            return PsiType.INT.equals(expressionType) || PsiType.LONG.equals(expressionType);
        }

        private static boolean isFloatingPoint(@Nullable PsiType expressionType) {
            return PsiType.FLOAT.equals(expressionType) || PsiType.DOUBLE.equals(expressionType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/numeric/ImplicitNumericConversionInspection$ImplicitNumericConversionFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

