/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnpredictableBigDecimalConstructorCallInspection
extends BaseInspection {
    public boolean ignoreReferences = true;
    public boolean ignoreComplexLiterals = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unpredictable.big.decimal.constructor.call.display.name", new Object[0]);
        if (string == null) {
            UnpredictableBigDecimalConstructorCallInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("unpredictable.big.decimal.constructor.call.problem.descriptor", new Object[0]);
        if (string == null) {
            UnpredictableBigDecimalConstructorCallInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("unpredictable.big.decimal.constructor.call.ignore.references.option", new Object[0]), "ignoreReferences");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("unpredictable.big.decimal.constructor.call.ignore.complex.literals.option", new Object[0]), "ignoreComplexLiterals");
        return optionsPanel;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        String text2;
        char c;
        PsiNewExpression newExpression = (PsiNewExpression)infos2[0];
        PsiExpressionList argumentList2 = newExpression.getArgumentList();
        if (argumentList2 == null) {
            return null;
        }
        PsiExpression[] arguments2 = argumentList2.getExpressions();
        if (arguments2.length == 0) {
            return null;
        }
        PsiExpression firstArgument = arguments2[0];
        if (firstArgument instanceof PsiLiteralExpression && (c = (text2 = firstArgument.getText()).charAt(text2.length() - 1)) != 'd' && c != 'D' && c != 'f' && c != 'F') {
            return new ReplaceDoubleArgumentWithStringFix("new BigDecimal(\"" + firstArgument.getText() + "\")");
        }
        if (arguments2.length == 1) {
            return new ReplaceDoubleArgumentWithStringFix("BigDecimal.valueOf(" + firstArgument.getText() + ')');
        }
        return null;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnpredictableBigDecimalConstructorCallVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/numeric/UnpredictableBigDecimalConstructorCallInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class UnpredictableBigDecimalConstructorCallVisitor
    extends BaseInspectionVisitor {
        private UnpredictableBigDecimalConstructorCallVisitor() {
        }

        @Override
        public void visitNewExpression(PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            PsiJavaCodeReferenceElement classReference = expression2.getClassReference();
            if (classReference == null) {
                return;
            }
            String name = classReference.getReferenceName();
            if (!"BigDecimal".equals(name)) {
                return;
            }
            PsiMethod constructor = expression2.resolveConstructor();
            if (constructor == null) {
                return;
            }
            PsiClass containingClass = constructor.getContainingClass();
            if (containingClass == null || !"java.math.BigDecimal".equals(containingClass.getQualifiedName())) {
                return;
            }
            PsiParameterList parameterList = constructor.getParameterList();
            int length = parameterList.getParametersCount();
            if (length != 1 && length != 2) {
                return;
            }
            PsiParameter[] parameters2 = parameterList.getParameters();
            PsiParameter firstParameter = parameters2[0];
            PsiType type2 = firstParameter.getType();
            if (!PsiType.DOUBLE.equals(type2)) {
                return;
            }
            PsiExpressionList argumentList2 = expression2.getArgumentList();
            if (argumentList2 == null) {
                return;
            }
            PsiExpression[] arguments2 = argumentList2.getExpressions();
            if (arguments2.length == 0) {
                return;
            }
            PsiExpression firstArgument = arguments2[0];
            if (!this.checkExpression(firstArgument)) {
                return;
            }
            this.registerNewExpressionError(expression2, expression2);
        }

        private boolean checkExpression(@Nullable PsiExpression expression2) {
            if (expression2 == null) {
                return false;
            }
            if (expression2 instanceof PsiReferenceExpression) {
                if (UnpredictableBigDecimalConstructorCallInspection.this.ignoreReferences) {
                    return false;
                }
            } else if (expression2 instanceof PsiPolyadicExpression) {
                if (UnpredictableBigDecimalConstructorCallInspection.this.ignoreComplexLiterals) {
                    return false;
                }
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
                for (PsiExpression operand : polyadicExpression.getOperands()) {
                    if (this.checkExpression(operand)) continue;
                    return false;
                }
            }
            return true;
        }
    }

    private static class ReplaceDoubleArgumentWithStringFix
    extends InspectionGadgetsFix {
        private final String argumentText;

        public ReplaceDoubleArgumentWithStringFix(String argumentText) {
            this.argumentText = argumentText;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unpredictable.big.decimal.constructor.call.quickfix", this.argumentText);
            if (string == null) {
                ReplaceDoubleArgumentWithStringFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Replace with 'BigDecimal.valueOf()'" == null) {
                ReplaceDoubleArgumentWithStringFix.$$$reportNull$$$0(1);
            }
            return "Replace with 'BigDecimal.valueOf()'";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            String text2;
            char c;
            PsiElement element = descriptor2.getPsiElement();
            PsiNewExpression newExpression = (PsiNewExpression)element.getParent();
            PsiExpressionList argumentList2 = newExpression.getArgumentList();
            if (argumentList2 == null) {
                return;
            }
            PsiExpression[] arguments2 = argumentList2.getExpressions();
            PsiExpression firstArgument = arguments2[0];
            if (firstArgument instanceof PsiLiteralExpression && (c = (text2 = firstArgument.getText()).charAt(text2.length() - 1)) != 'd' && c != 'D' && c != 'f' && c != 'F') {
                PsiReplacementUtil.replaceExpression(firstArgument, '\"' + firstArgument.getText() + '\"');
                return;
            }
            if (arguments2.length == 1) {
                PsiReplacementUtil.replaceExpression(newExpression, "java.math.BigDecimal.valueOf(" + firstArgument.getText() + ')');
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/numeric/UnpredictableBigDecimalConstructorCallInspection$ReplaceDoubleArgumentWithStringFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

