/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.ChangeModifierFix;
import com.siyeh.ig.performance.MethodReferenceVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ClassInitializerMayBeStaticInspection
extends BaseInspection {
    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("class.initializer.may.be.static.problem.descriptor", new Object[0]);
        if (string == null) {
            ClassInitializerMayBeStaticInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        return new ChangeModifierFix("static");
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.initializer.may.be.static.display.name", new Object[0]);
        if (string == null) {
            ClassInitializerMayBeStaticInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassInitializerCanBeStaticVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/performance/ClassInitializerMayBeStaticInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ClassInitializerCanBeStaticVisitor
    extends BaseInspectionVisitor {
        private ClassInitializerCanBeStaticVisitor() {
        }

        @Override
        public void visitClassInitializer(PsiClassInitializer initializer2) {
            Condition<PsiElement>[] addins;
            if (initializer2.hasModifierProperty("static")) {
                return;
            }
            PsiClass containingClass = ClassUtils.getContainingClass(initializer2);
            if (containingClass == null) {
                return;
            }
            for (Condition<PsiElement> addin : addins = InspectionManager.CANT_BE_STATIC_EXTENSION.getExtensions()) {
                if (!addin.value(initializer2)) continue;
                return;
            }
            PsiElement scope = containingClass.getScope();
            if (!(scope instanceof PsiJavaFile) && !containingClass.hasModifierProperty("static")) {
                return;
            }
            MethodReferenceVisitor visitor2 = new MethodReferenceVisitor(initializer2);
            initializer2.accept(visitor2);
            if (!visitor2.areReferencesStaticallyAccessible()) {
                return;
            }
            this.registerClassInitializerError(initializer2, new Object[0]);
        }
    }
}

