/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.ChangeToAppendUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.BlockUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringConcatenationInLoopsInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.concatenation.in.loops.display.name", new Object[0]);
        if (string == null) {
            StringConcatenationInLoopsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @org.intellij.lang.annotations.Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("StringConcatenationInLoop" == null) {
            StringConcatenationInLoopsInspection.$$$reportNull$$$0(1);
        }
        return "StringConcatenationInLoop";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("string.concatenation.in.loops.problem.descriptor", new Object[0]);
        if (string == null) {
            StringConcatenationInLoopsInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringConcatenationInLoopsVisitor();
    }

    static PsiLoopStatement getOutermostCommonLoop(PsiExpression expression2, PsiVariable variable2) {
        PsiElement stopAt = null;
        PsiCodeBlock block = StringConcatenationInLoopsVisitor.getSurroundingBlock(expression2);
        if (block != null) {
            PsiElement ref;
            if (expression2 instanceof PsiAssignmentExpression) {
                ref = expression2;
            } else {
                PsiReference reference = ReferencesSearch.search(variable2, new LocalSearchScope(expression2)).findFirst();
                PsiElement psiElement = ref = reference != null ? reference.getElement() : null;
            }
            if (ref != null) {
                PsiElement[] elements = (PsiElement[])StreamEx.of((Object[])DefUseUtil.getDefs(block, variable2, expression2)).prepend(expression2).toArray(PsiElement[]::new);
                stopAt = PsiTreeUtil.findCommonParent(elements);
            }
        }
        PsiLoopStatement commonLoop = null;
        for (PsiElement parent2 = expression2.getParent(); !(parent2 == null || parent2 == stopAt || parent2 instanceof PsiMethod || parent2 instanceof PsiClass || parent2 instanceof PsiLambdaExpression); parent2 = parent2.getParent()) {
            if (!(parent2 instanceof PsiLoopStatement)) continue;
            commonLoop = (PsiLoopStatement)parent2;
        }
        return commonLoop;
    }

    @Contract(value="null -> null")
    @Nullable
    private static PsiVariable getAppendedVariable(PsiExpression expression2) {
        PsiElement parent2 = expression2;
        while (parent2 instanceof PsiParenthesizedExpression || parent2 instanceof PsiPolyadicExpression) {
            parent2 = parent2.getParent();
        }
        if (!(parent2 instanceof PsiAssignmentExpression)) {
            return null;
        }
        PsiExpression lhs = PsiUtil.skipParenthesizedExprDown(((PsiAssignmentExpression)parent2).getLExpression());
        if (!(lhs instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement element = ((PsiReferenceExpression)lhs).resolve();
        return element instanceof PsiVariable ? (PsiVariable)element : null;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos2) {
        PsiExpression expression2 = ObjectUtils.tryCast(ArrayUtil.getFirstElement(infos2), PsiExpression.class);
        PsiVariable var = StringConcatenationInLoopsInspection.getAppendedVariable(expression2);
        if (var == null) {
            if (InspectionGadgetsFix.EMPTY_ARRAY == null) {
                StringConcatenationInLoopsInspection.$$$reportNull$$$0(3);
            }
            return InspectionGadgetsFix.EMPTY_ARRAY;
        }
        ArrayList<AbstractStringBuilderFix> fixes = new ArrayList<AbstractStringBuilderFix>();
        if (var instanceof PsiLocalVariable) {
            fixes.add(new ReplaceWithStringBuilderFix(var));
            PsiLoopStatement loop = StringConcatenationInLoopsInspection.getOutermostCommonLoop(expression2, var);
            if (ReferencesSearch.search(var).findAll().stream().map(PsiReference::getElement).filter(e -> !PsiTreeUtil.isAncestor(loop, e, true)).limit(2L).count() > 1L) {
                fixes.add(new IntroduceStringBuilderFix(var));
            }
        } else if (var instanceof PsiParameter) {
            fixes.add(new IntroduceStringBuilderFix(var));
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = fixes.toArray(InspectionGadgetsFix.EMPTY_ARRAY);
        if (inspectionGadgetsFixArray == null) {
            StringConcatenationInLoopsInspection.$$$reportNull$$$0(4);
        }
        return inspectionGadgetsFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/performance/StringConcatenationInLoopsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    static class ReplaceWithStringBuilderFix
    extends AbstractStringBuilderFix {
        public ReplaceWithStringBuilderFix(PsiVariable variable2) {
            super(variable2);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiStatement commentPlace;
            PsiExpression expression2 = PsiTreeUtil.getParentOfType(descriptor2.getStartElement(), PsiExpression.class);
            if (expression2 == null) {
                return;
            }
            PsiVariable variable2 = StringConcatenationInLoopsInspection.getAppendedVariable(expression2);
            if (!(variable2 instanceof PsiLocalVariable)) {
                return;
            }
            variable2.normalizeDeclaration();
            PsiTypeElement typeElement = variable2.getTypeElement();
            if (typeElement == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            this.replaceAll(variable2, variable2, null, ct);
            ct.replace((PsiElement)typeElement, this.myTargetType);
            PsiExpression initializer2 = variable2.getInitializer();
            if (initializer2 != null) {
                ct.replace((PsiElement)initializer2, this.generateNewStringBuilder(initializer2, ct));
            }
            ct.insertCommentsBefore((commentPlace = PsiTreeUtil.getParentOfType((PsiElement)variable2, PsiStatement.class)) == null ? variable2 : commentPlace);
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("string.concatenation.replace.fix.name", this.myName, StringUtil.getShortName(this.myTargetType));
            if (string == null) {
                ReplaceWithStringBuilderFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("string.concatenation.replace.fix", new Object[0]);
            if (string == null) {
                ReplaceWithStringBuilderFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/performance/StringConcatenationInLoopsInspection$ReplaceWithStringBuilderFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    static class IntroduceStringBuilderFix
    extends AbstractStringBuilderFix {
        public IntroduceStringBuilderFix(PsiVariable variable2) {
            super(variable2);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiExpression expression2 = PsiTreeUtil.getParentOfType(descriptor2.getStartElement(), PsiExpression.class);
            if (expression2 == null) {
                return;
            }
            PsiVariable variable2 = StringConcatenationInLoopsInspection.getAppendedVariable(expression2);
            if (variable2 == null) {
                return;
            }
            PsiLoopStatement loop = StringConcatenationInLoopsInspection.getOutermostCommonLoop(expression2, variable2);
            if (loop == null) {
                return;
            }
            ControlFlowUtils.InitializerUsageStatus status2 = ControlFlowUtils.getInitializerUsageStatus(variable2, loop);
            String newName2 = JavaCodeStyleManager.getInstance(project).suggestUniqueVariableName(variable2.getName() + "Builder", (PsiElement)loop, true);
            String newStringBuilder = this.myTargetType + " " + newName2 + "=new " + this.myTargetType + "(" + variable2.getName() + ");";
            PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(project);
            Object marker = new Object();
            PsiTreeUtil.mark(loop, marker);
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)BlockUtils.addBefore(loop, factory2.createStatementFromText(newStringBuilder, loop));
            if (!loop.isValid() && (loop = (PsiLoopStatement)PsiTreeUtil.releaseMark(declaration.getParent(), marker)) == null) {
                return;
            }
            PsiVariable builderVariable = (PsiVariable)declaration.getDeclaredElements()[0];
            PsiExpression builderInitializer = Objects.requireNonNull(builderVariable.getInitializer());
            CommentTracker ct = new CommentTracker();
            this.replaceAll(variable2, builderVariable, loop, ct);
            String toString2 = variable2.getName() + " = " + newName2 + ".toString();";
            PsiExpression initializer2 = variable2.getInitializer();
            switch (status2) {
                case DECLARED_JUST_BEFORE: {
                    PsiTypeElement typeElement = variable2.getTypeElement();
                    if (typeElement == null || initializer2 == null) break;
                    ct.replace((PsiElement)builderInitializer, this.generateNewStringBuilder(initializer2, ct));
                    ct.replace((PsiElement)initializer2, newName2 + ".toString()");
                    toString2 = variable2.getText();
                    ct.delete((PsiElement)variable2);
                    break;
                }
                case AT_WANTED_PLACE_ONLY: {
                    if (initializer2 == null) break;
                    ct.replace((PsiElement)builderInitializer, this.generateNewStringBuilder(initializer2, ct));
                    initializer2.delete();
                    break;
                }
                case AT_WANTED_PLACE: {
                    if (!ExpressionUtils.isSimpleExpression(initializer2)) break;
                    ct.replace((PsiElement)builderInitializer, this.generateNewStringBuilder(initializer2, ct));
                    break;
                }
                case UNKNOWN: {
                    PsiElement prevStatement = PsiTreeUtil.skipWhitespacesAndCommentsBackward(declaration);
                    PsiExpression prevAssignment = ExpressionUtils.getAssignmentTo(prevStatement, variable2);
                    if (prevAssignment == null) break;
                    ct.replace((PsiElement)builderInitializer, this.generateNewStringBuilder(prevAssignment, ct));
                    ct.delete(prevStatement);
                }
            }
            BlockUtils.addAfter(loop, factory2.createStatementFromText(toString2, loop));
            ct.insertCommentsBefore(loop);
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("string.concatenation.introduce.fix.name", this.myName, StringUtil.getShortName(this.myTargetType));
            if (string == null) {
                IntroduceStringBuilderFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("string.concatenation.introduce.fix", new Object[0]);
            if (string == null) {
                IntroduceStringBuilderFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/performance/StringConcatenationInLoopsInspection$IntroduceStringBuilderFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    static abstract class AbstractStringBuilderFix
    extends InspectionGadgetsFix {
        static final Pattern PRINT_OR_PRINTLN = Pattern.compile("print|println");
        String myName;
        String myTargetType;

        public AbstractStringBuilderFix(PsiVariable variable2) {
            this.myName = variable2.getName();
            this.myTargetType = PsiUtil.isLanguageLevel5OrHigher(variable2) ? "java.lang.StringBuilder" : "java.lang.StringBuffer";
        }

        @NotNull
        String generateNewStringBuilder(PsiExpression initializer2, CommentTracker ct) {
            if (ExpressionUtils.isNullLiteral(initializer2)) {
                String string = ct.text(initializer2);
                if (string == null) {
                    AbstractStringBuilderFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            String text2 = initializer2 == null || ExpressionUtils.isLiteral(initializer2, "") ? "" : ct.text(initializer2);
            String string = "new " + this.myTargetType + "(" + text2 + ")";
            if (string == null) {
                AbstractStringBuilderFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        void replaceAll(PsiVariable variable2, PsiVariable builderVariable, PsiElement scope, CommentTracker ct) {
            this.replaceAll(variable2, builderVariable, scope, ct, ref -> false);
        }

        void replaceAll(PsiVariable variable2, PsiVariable builderVariable, PsiElement scope, CommentTracker ct, Predicate<PsiReferenceExpression> skip2) {
            Query<PsiReference> query = scope == null ? ReferencesSearch.search(variable2) : ReferencesSearch.search(variable2, new LocalSearchScope(scope));
            Collection<PsiReference> refs = query.findAll();
            for (PsiReference ref : refs) {
                PsiElement target = ref.getElement();
                if (!(target instanceof PsiReferenceExpression) || !target.isValid() || skip2.test((PsiReferenceExpression)target)) continue;
                this.replace(variable2, builderVariable, (PsiReferenceExpression)target, ct);
            }
        }

        private void replace(PsiVariable variable2, PsiVariable builderVariable, PsiReferenceExpression ref, CommentTracker ct) {
            PsiBinaryExpression binOp;
            PsiMethodCallExpression call2;
            PsiExpression[] expressions;
            PsiMethodCallExpression methodCallExpression;
            PsiElement parent2 = PsiUtil.skipParenthesizedExprUp(ref.getParent());
            if (parent2 instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent2;
                if (PsiUtil.skipParenthesizedExprDown(assignment.getLExpression()) == ref) {
                    this.replaceInAssignment(variable2, builderVariable, assignment, ct);
                    return;
                }
                if (assignment.getOperationTokenType().equals(JavaTokenType.PLUSEQ)) {
                    return;
                }
            }
            if (variable2 != builderVariable) {
                ExpressionUtils.bindReferenceTo(ref, Objects.requireNonNull(builderVariable.getName()));
            }
            if ((methodCallExpression = ExpressionUtils.getCallForQualifier(ref)) != null) {
                AbstractStringBuilderFix.replaceInCallQualifier(builderVariable, methodCallExpression, ct);
                return;
            }
            if (parent2 instanceof PsiExpressionList && parent2.getParent() instanceof PsiMethodCallExpression && (expressions = ((PsiExpressionList)parent2).getExpressions()).length == 1 && expressions[0] == ref && AbstractStringBuilderFix.canAcceptBuilderInsteadOfString(call2 = (PsiMethodCallExpression)parent2.getParent())) {
                return;
            }
            if (parent2 instanceof PsiBinaryExpression && ExpressionUtils.getValueComparedWithNull(binOp = (PsiBinaryExpression)parent2) != null) {
                return;
            }
            if (parent2 instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parent2).getOperationTokenType().equals(JavaTokenType.PLUS)) {
                PsiExpression[] operands;
                for (PsiExpression operand : operands = ((PsiPolyadicExpression)parent2).getOperands()) {
                    if (operand == ref) break;
                    if (!TypeUtils.isJavaLangString(operand.getType())) continue;
                    return;
                }
                if (operands.length > 1 && operands[0] == ref && TypeUtils.isJavaLangString(operands[1].getType())) {
                    return;
                }
            }
            ct.replace((PsiElement)ref, builderVariable.getName() + ".toString()");
        }

        private static boolean canAcceptBuilderInsteadOfString(PsiMethodCallExpression call2) {
            return MethodCallUtils.isCallToMethod(call2, "java.lang.StringBuilder", null, "append", (PsiType[])null) || MethodCallUtils.isCallToMethod(call2, "java.lang.StringBuffer", null, "append", (PsiType[])null) || MethodCallUtils.isCallToMethod(call2, "java.io.PrintStream", null, PRINT_OR_PRINTLN, (PsiType[])null) || MethodCallUtils.isCallToMethod(call2, "java.io.PrintWriter", null, PRINT_OR_PRINTLN, (PsiType[])null);
        }

        private static void replaceInCallQualifier(PsiVariable variable2, PsiMethodCallExpression call2, CommentTracker ct) {
            PsiMethod method = call2.resolveMethod();
            if (method != null) {
                String name;
                PsiExpression[] args = call2.getArgumentList().getExpressions();
                switch (name = method.getName()) {
                    case "length": 
                    case "chars": 
                    case "codePoints": 
                    case "charAt": 
                    case "codePointAt": 
                    case "codePointBefore": 
                    case "codePointAfter": 
                    case "codePointCount": 
                    case "offsetByCodePoints": 
                    case "substring": 
                    case "subSequence": {
                        return;
                    }
                    case "getChars": {
                        if (args.length != 4) break;
                        return;
                    }
                    case "indexOf": 
                    case "lastIndexOf": {
                        if (args.length < 1 || args.length > 2 || !TypeUtils.isJavaLangString(args[0].getType())) break;
                        return;
                    }
                    case "isEmpty": {
                        String sign = "==";
                        PsiExpression negation = BoolUtils.findNegation(call2);
                        PsiExpression toReplace = call2;
                        if (negation != null) {
                            sign = ">";
                            toReplace = negation;
                        }
                        PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(variable2.getProject());
                        PsiExpression emptyCheck = factory2.createExpressionFromText(variable2.getName() + ".length()" + sign + "0", call2);
                        PsiElement callParent = toReplace.getParent();
                        if (callParent instanceof PsiExpression && ParenthesesUtils.areParenthesesNeeded(emptyCheck, (PsiExpression)callParent, true)) {
                            emptyCheck = factory2.createExpressionFromText("(" + emptyCheck.getText() + ")", call2);
                        }
                        ct.replace((PsiElement)toReplace, emptyCheck);
                        return;
                    }
                }
            }
            PsiExpression qualifier = Objects.requireNonNull(call2.getMethodExpression().getQualifierExpression());
            ct.replace((PsiElement)qualifier, variable2.getName() + ".toString()");
        }

        private void replaceInAssignment(PsiVariable variable2, PsiVariable builderVariable, PsiAssignmentExpression assignment, CommentTracker ct) {
            PsiPolyadicExpression concat2;
            PsiExpression[] operands;
            PsiExpression rValue = PsiUtil.skipParenthesizedExprDown(assignment.getRExpression());
            String builderName = Objects.requireNonNull(builderVariable.getName());
            if (assignment.getOperationTokenType().equals(JavaTokenType.EQ) && rValue instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)rValue).getOperationTokenType().equals(JavaTokenType.PLUS) && (operands = (concat2 = (PsiPolyadicExpression)rValue).getOperands()).length > 1) {
                if (ExpressionUtils.isReferenceTo(operands[0], variable2)) {
                    StreamEx.iterate((Object)operands[1], Objects::nonNull, PsiElement::getNextSibling).forEach(ct::markUnchanged);
                    this.replaceAll(variable2, builderVariable, rValue, ct, operands[0]::equals);
                    StringBuilder replacement = ChangeToAppendUtil.buildAppendExpression(rValue, false, new StringBuilder(builderName));
                    if (replacement != null) {
                        PsiMethodCallExpression qualifierCall;
                        PsiMethodCallExpression append2 = (PsiMethodCallExpression)ct.replace((PsiElement)assignment, replacement.toString());
                        while ((qualifierCall = MethodCallUtils.getQualifierMethodCall(append2)) != null) {
                            append2 = qualifierCall;
                        }
                        PsiExpression qualifier = append2.getMethodExpression().getQualifierExpression();
                        if (qualifier != null) {
                            append2.replace(qualifier);
                        }
                    }
                    return;
                }
                PsiExpression lastOp = operands[operands.length - 1];
                if (ExpressionUtils.isReferenceTo(lastOp, variable2)) {
                    ct.delete(concat2.getTokenBeforeOperand(lastOp), lastOp);
                    this.replaceAll(variable2, builderVariable, rValue, ct);
                    ct.replace((PsiElement)assignment, builderName + ".insert(0," + ct.text(rValue) + ")");
                    return;
                }
            }
            if (rValue != null) {
                this.replaceAll(variable2, builderVariable, rValue, ct);
                rValue = assignment.getRExpression();
            }
            if (assignment.getOperationTokenType().equals(JavaTokenType.PLUSEQ)) {
                StringBuilder sb;
                String replacement = "";
                if (rValue != null && (sb = ChangeToAppendUtil.buildAppendExpression(ct.markUnchanged(rValue), false, new StringBuilder(builderName))) != null) {
                    replacement = sb.toString();
                }
                ct.replace((PsiElement)assignment, replacement);
            } else if (assignment.getOperationTokenType().equals(JavaTokenType.EQ)) {
                ct.replace((PsiElement)assignment, builderName + "=" + this.generateNewStringBuilder(rValue, ct));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConcatenationInLoopsInspection$AbstractStringBuilderFix", "generateNewStringBuilder"));
        }
    }

    private static class StringConcatenationInLoopsVisitor
    extends BaseInspectionVisitor {
        private StringConcatenationInLoopsVisitor() {
        }

        @Override
        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            super.visitPolyadicExpression(expression2);
            PsiExpression[] operands = expression2.getOperands();
            if (operands.length <= 1) {
                return;
            }
            IElementType tokenType = expression2.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.PLUS)) {
                return;
            }
            if (!StringConcatenationInLoopsVisitor.checkExpression(expression2)) {
                return;
            }
            if (ExpressionUtils.isEvaluatedAtCompileTime(expression2)) {
                return;
            }
            if (!StringConcatenationInLoopsVisitor.isAppendedRepeatedly(expression2)) {
                return;
            }
            PsiJavaToken sign = expression2.getTokenBeforeOperand(operands[1]);
            assert (sign != null);
            this.registerError((PsiElement)sign, expression2);
        }

        @Override
        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression2) {
            if (expression2 == null) {
                StringConcatenationInLoopsVisitor.$$$reportNull$$$0(0);
            }
            super.visitAssignmentExpression(expression2);
            if (expression2.getRExpression() == null) {
                return;
            }
            PsiJavaToken sign = expression2.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSEQ)) {
                return;
            }
            if (!StringConcatenationInLoopsVisitor.checkExpression(expression2)) {
                return;
            }
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown(expression2.getLExpression());
            if (!(lhs instanceof PsiReferenceExpression)) {
                return;
            }
            this.registerError((PsiElement)sign, expression2);
        }

        private static boolean checkExpression(PsiExpression expression2) {
            PsiVariable variable2;
            if (!TypeUtils.isJavaLangString(expression2.getType()) || ControlFlowUtils.isInExitStatement(expression2) || !ControlFlowUtils.isInLoop(expression2)) {
                return false;
            }
            PsiElement parent2 = expression2;
            while (parent2 instanceof PsiParenthesizedExpression || parent2 instanceof PsiPolyadicExpression) {
                parent2 = parent2.getParent();
            }
            if (parent2 != expression2 && parent2 instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)parent2).getOperationTokenType().equals(JavaTokenType.PLUSEQ)) {
                return false;
            }
            if (parent2 instanceof PsiAssignmentExpression && (variable2 = StringConcatenationInLoopsInspection.getAppendedVariable(expression2 = parent2)) != null) {
                PsiLoopStatement commonLoop = StringConcatenationInLoopsInspection.getOutermostCommonLoop(expression2, variable2);
                return commonLoop != null && !ControlFlowUtils.isExecutedOnceInLoop(PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiStatement.class), commonLoop) && !StringConcatenationInLoopsVisitor.isUsedCompletely(variable2, commonLoop);
            }
            return false;
        }

        private static boolean isUsedCompletely(PsiVariable variable2, PsiLoopStatement loop) {
            boolean notUsedCompletely = ReferencesSearch.search(variable2, new LocalSearchScope(loop)).forEach(ref -> {
                PsiExpression expression2 = ObjectUtils.tryCast(ref.getElement(), PsiExpression.class);
                if (expression2 == null) {
                    return true;
                }
                PsiElement parent2 = PsiUtil.skipParenthesizedExprUp(expression2.getParent());
                while (parent2 instanceof PsiTypeCastExpression || parent2 instanceof PsiConditionalExpression) {
                    parent2 = PsiUtil.skipParenthesizedExprUp(parent2.getParent());
                }
                if (parent2 instanceof PsiExpressionList || parent2 instanceof PsiAssignmentExpression && PsiTreeUtil.isAncestor(((PsiAssignmentExpression)parent2).getRExpression(), expression2, false)) {
                    PsiStatement statement2 = PsiTreeUtil.getParentOfType(parent2, PsiStatement.class);
                    return ControlFlowUtils.isExecutedOnceInLoop(statement2, loop) || ControlFlowUtils.isVariableReassigned(statement2, variable2);
                }
                return true;
            });
            return !notUsedCompletely;
        }

        @Nullable
        private static PsiCodeBlock getSurroundingBlock(PsiElement expression2) {
            PsiElement body2;
            Object parent2 = PsiTreeUtil.getParentOfType(expression2, PsiMethod.class, PsiClassInitializer.class, PsiLambdaExpression.class);
            if (parent2 instanceof PsiMethod) {
                return ((PsiMethod)parent2).getBody();
            }
            if (parent2 instanceof PsiClassInitializer) {
                return ((PsiClassInitializer)parent2).getBody();
            }
            if (parent2 instanceof PsiLambdaExpression && (body2 = ((PsiLambdaExpression)parent2).getBody()) instanceof PsiCodeBlock) {
                return (PsiCodeBlock)body2;
            }
            return null;
        }

        private static boolean isAppendedRepeatedly(PsiExpression expression2) {
            PsiElement parent2 = expression2.getParent();
            while (parent2 instanceof PsiParenthesizedExpression || parent2 instanceof PsiPolyadicExpression) {
                parent2 = parent2.getParent();
            }
            if (!(parent2 instanceof PsiAssignmentExpression)) {
                return false;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent2;
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown(assignmentExpression.getLExpression());
            if (!(lhs instanceof PsiReferenceExpression)) {
                return false;
            }
            if (assignmentExpression.getOperationTokenType() == JavaTokenType.PLUSEQ) {
                return true;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement element = referenceExpression.resolve();
            if (!(element instanceof PsiVariable)) {
                return false;
            }
            PsiExpression rhs = assignmentExpression.getRExpression();
            return StringConcatenationInLoopsVisitor.isAppended(referenceExpression, rhs);
        }

        private static boolean isAppended(PsiReferenceExpression otherRef, PsiExpression expression2) {
            PsiPolyadicExpression polyadicExpression;
            if ((expression2 = PsiUtil.skipParenthesizedExprDown(expression2)) instanceof PsiPolyadicExpression && (polyadicExpression = (PsiPolyadicExpression)expression2).getOperationTokenType().equals(JavaTokenType.PLUS)) {
                for (PsiExpression operand : polyadicExpression.getOperands()) {
                    if (!StringConcatenationInLoopsVisitor.isSameReference(operand, otherRef) && !StringConcatenationInLoopsVisitor.isAppended(otherRef, operand)) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean isSameReference(PsiExpression operand, PsiReferenceExpression ref) {
            PsiReferenceExpression other = ObjectUtils.tryCast(PsiUtil.skipParenthesizedExprDown(operand), PsiReferenceExpression.class);
            if (other == null) {
                return false;
            }
            String name = other.getReferenceName();
            if (name == null || !name.equals(ref.getReferenceName())) {
                return false;
            }
            PsiExpression qualifier = ref.getQualifierExpression();
            PsiExpression otherQualifier = other.getQualifierExpression();
            if (qualifier == null && otherQualifier == null) {
                return true;
            }
            if (qualifier == null && ref.resolve() instanceof PsiField) {
                qualifier = ExpressionUtils.getQualifierOrThis(ref);
            }
            if (otherQualifier == null && other.resolve() instanceof PsiField) {
                otherQualifier = ExpressionUtils.getQualifierOrThis(other);
            }
            if (qualifier == null || otherQualifier == null) {
                return false;
            }
            if (qualifier instanceof PsiReferenceExpression) {
                return StringConcatenationInLoopsVisitor.isSameReference(otherQualifier, (PsiReferenceExpression)qualifier);
            }
            return PsiEquivalenceUtil.areElementsEquivalent(qualifier, otherQualifier);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/StringConcatenationInLoopsInspection$StringConcatenationInLoopsVisitor", "visitAssignmentExpression"));
        }
    }
}

