/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockUtils {
    public static PsiStatement addBefore(PsiStatement anchor2, PsiStatement ... newStatements) {
        if (newStatements.length == 0) {
            throw new IllegalArgumentException();
        }
        PsiStatement oldStatement = anchor2;
        PsiElement parent2 = oldStatement.getParent();
        while (parent2 instanceof PsiLabeledStatement) {
            oldStatement = (PsiStatement)parent2;
            parent2 = oldStatement.getParent();
        }
        if (newStatements.length == 1 && oldStatement instanceof PsiEmptyStatement) {
            return (PsiStatement)oldStatement.replace(newStatements[0]);
        }
        if (!(parent2 instanceof PsiCodeBlock)) {
            PsiBlockStatement block = BlockUtils.expandSingleStatementToBlockStatement(oldStatement);
            PsiCodeBlock codeBlock = (PsiCodeBlock)block.getFirstChild();
            parent2 = codeBlock;
            oldStatement = codeBlock.getStatements()[0];
        }
        PsiElement result2 = null;
        for (PsiStatement statement2 : newStatements) {
            result2 = parent2.addBefore(statement2, oldStatement);
        }
        return (PsiStatement)result2;
    }

    public static PsiStatement addAfter(PsiStatement anchor2, PsiStatement newStatement) {
        PsiStatement oldStatement = anchor2;
        PsiElement parent2 = oldStatement.getParent();
        while (parent2 instanceof PsiLabeledStatement) {
            oldStatement = (PsiStatement)parent2;
            parent2 = oldStatement.getParent();
        }
        if (!(parent2 instanceof PsiCodeBlock)) {
            PsiBlockStatement block = BlockUtils.expandSingleStatementToBlockStatement(oldStatement);
            PsiCodeBlock codeBlock = (PsiCodeBlock)block.getFirstChild();
            parent2 = codeBlock;
            oldStatement = codeBlock.getStatements()[0];
        }
        return (PsiStatement)parent2.addAfter(newStatement, oldStatement);
    }

    public static PsiBlockStatement expandSingleStatementToBlockStatement(@NotNull PsiStatement body2) {
        PsiBlockStatement result2;
        PsiElement sibling;
        if (body2 == null) {
            BlockUtils.$$$reportNull$$$0(0);
        }
        if (body2 instanceof PsiBlockStatement) {
            return (PsiBlockStatement)body2;
        }
        PsiBlockStatement blockStatement = (PsiBlockStatement)JavaPsiFacade.getElementFactory(body2.getProject()).createStatementFromText("{}", body2);
        if (!(body2 instanceof PsiEmptyStatement)) {
            blockStatement.getFirstChild().add(body2);
        }
        if ((sibling = (result2 = (PsiBlockStatement)body2.replace(blockStatement)).getNextSibling()) instanceof PsiWhiteSpace && PsiUtil.isJavaToken(sibling.getNextSibling(), JavaTokenType.ELSE_KEYWORD)) {
            sibling.delete();
        }
        return result2;
    }

    @Nullable
    public static PsiElement getBody(PsiElement element) {
        if (element instanceof PsiLoopStatement) {
            PsiStatement loopBody = ((PsiLoopStatement)element).getBody();
            return loopBody instanceof PsiBlockStatement ? ((PsiBlockStatement)loopBody).getCodeBlock() : loopBody;
        }
        if (element instanceof PsiParameterListOwner) {
            return ((PsiParameterListOwner)element).getBody();
        }
        if (element instanceof PsiSynchronizedStatement) {
            return ((PsiSynchronizedStatement)element).getBody();
        }
        if (element instanceof PsiSwitchStatement) {
            return ((PsiSwitchStatement)element).getBody();
        }
        if (element instanceof PsiClassInitializer) {
            return ((PsiClassInitializer)element).getBody();
        }
        if (element instanceof PsiCatchSection) {
            return ((PsiCatchSection)element).getCatchBlock();
        }
        throw new AssertionError((Object)("can't get body from " + element));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/siyeh/ig/psiutils/BlockUtils", "expandSingleStatementToBlockStatement"));
    }
}

