/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class CommentTracker {
    private Set<PsiElement> ignoredParents = new HashSet<PsiElement>();
    private List<PsiComment> comments = new ArrayList<PsiComment>();

    @NotNull
    public String text(@NotNull PsiElement element) {
        if (element == null) {
            CommentTracker.$$$reportNull$$$0(0);
        }
        this.checkState();
        this.addIgnored(element);
        String string = element.getText();
        if (string == null) {
            CommentTracker.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public <T extends PsiElement> T markUnchanged(@NotNull T element) {
        if (element == null) {
            CommentTracker.$$$reportNull$$$0(2);
        }
        this.checkState();
        this.addIgnored(element);
        T t = element;
        if (t == null) {
            CommentTracker.$$$reportNull$$$0(3);
        }
        return t;
    }

    public void delete(@NotNull PsiElement element) {
        if (element == null) {
            CommentTracker.$$$reportNull$$$0(4);
        }
        this.grabComments(element);
        element.delete();
    }

    public void delete(PsiElement ... elements) {
        if (elements == null) {
            CommentTracker.$$$reportNull$$$0(5);
        }
        for (PsiElement element : elements) {
            this.delete(element);
        }
    }

    public void deleteAndRestoreComments(@NotNull PsiElement element) {
        if (element == null) {
            CommentTracker.$$$reportNull$$$0(6);
        }
        this.grabComments(element);
        this.insertCommentsBefore(element instanceof PsiVariable ? element.getParent() : element);
        element.delete();
    }

    @NotNull
    public PsiElement replace(@NotNull PsiElement element, @NotNull PsiElement replacement) {
        if (element == null) {
            CommentTracker.$$$reportNull$$$0(7);
        }
        if (replacement == null) {
            CommentTracker.$$$reportNull$$$0(8);
        }
        this.grabComments(element);
        PsiElement psiElement = element.replace(replacement);
        if (psiElement == null) {
            CommentTracker.$$$reportNull$$$0(9);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement replace(@NotNull PsiElement element, @NotNull String text2) {
        if (element == null) {
            CommentTracker.$$$reportNull$$$0(10);
        }
        if (text2 == null) {
            CommentTracker.$$$reportNull$$$0(11);
        }
        PsiElement replacement = CommentTracker.createElement(element, text2);
        PsiElement psiElement = this.replace(element, replacement);
        if (psiElement == null) {
            CommentTracker.$$$reportNull$$$0(12);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement replaceAndRestoreComments(@NotNull PsiElement element, @NotNull PsiElement replacement) {
        PsiElement result2;
        Object anchor2;
        if (element == null) {
            CommentTracker.$$$reportNull$$$0(13);
        }
        if (replacement == null) {
            CommentTracker.$$$reportNull$$$0(14);
        }
        if ((anchor2 = PsiTreeUtil.getNonStrictParentOfType(result2 = this.replace(element, replacement), PsiStatement.class, PsiLambdaExpression.class, PsiVariable.class)) instanceof PsiLambdaExpression && anchor2 != result2) {
            anchor2 = ((PsiLambdaExpression)anchor2).getBody();
        }
        if (anchor2 instanceof PsiVariable && anchor2.getParent() instanceof PsiDeclarationStatement) {
            anchor2 = anchor2.getParent();
        }
        if (anchor2 == null) {
            anchor2 = result2;
        }
        this.insertCommentsBefore((PsiElement)anchor2);
        PsiElement psiElement = result2;
        if (psiElement == null) {
            CommentTracker.$$$reportNull$$$0(15);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement replaceAndRestoreComments(@NotNull PsiElement element, @NotNull String text2) {
        if (element == null) {
            CommentTracker.$$$reportNull$$$0(16);
        }
        if (text2 == null) {
            CommentTracker.$$$reportNull$$$0(17);
        }
        PsiElement replacement = CommentTracker.createElement(element, text2);
        PsiElement psiElement = this.replaceAndRestoreComments(element, replacement);
        if (psiElement == null) {
            CommentTracker.$$$reportNull$$$0(18);
        }
        return psiElement;
    }

    @NotNull
    private static PsiElement createElement(@NotNull PsiElement element, @NotNull String text2) {
        PsiElement replacement;
        if (element == null) {
            CommentTracker.$$$reportNull$$$0(19);
        }
        if (text2 == null) {
            CommentTracker.$$$reportNull$$$0(20);
        }
        PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(element.getProject());
        if (element instanceof PsiExpression) {
            replacement = factory2.createExpressionFromText(text2, element);
        } else if (element instanceof PsiStatement) {
            replacement = factory2.createStatementFromText(text2, element);
        } else if (element instanceof PsiTypeElement) {
            replacement = factory2.createTypeElementFromText(text2, element);
        } else if (element instanceof PsiIdentifier) {
            replacement = factory2.createIdentifier(text2);
        } else if (element instanceof PsiComment) {
            replacement = factory2.createCommentFromText(text2, element);
        } else {
            throw new IllegalArgumentException("Unsupported element type: " + element);
        }
        PsiExpression psiExpression = replacement;
        if (psiExpression == null) {
            CommentTracker.$$$reportNull$$$0(21);
        }
        return psiExpression;
    }

    public void insertCommentsBefore(@NotNull PsiElement anchor2) {
        if (anchor2 == null) {
            CommentTracker.$$$reportNull$$$0(22);
        }
        this.checkState();
        if (!this.comments.isEmpty()) {
            PsiElement parent2 = anchor2.getParent();
            PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(anchor2.getProject());
            for (PsiComment comment : this.comments) {
                PsiElement added;
                PsiElement prevSibling;
                if (this.shouldIgnore(comment) || !((prevSibling = (added = parent2.addBefore(factory2.createCommentFromText(comment.getText(), anchor2), anchor2)).getPrevSibling()) instanceof PsiWhiteSpace)) continue;
                ASTNode whiteSpaceBefore = CommentTracker.normalizeWhiteSpace((PsiWhiteSpace)prevSibling);
                PsiElement prev = anchor2.getPrevSibling();
                parent2.getNode().addChild(whiteSpaceBefore, anchor2.getNode());
                if (!(prev instanceof PsiWhiteSpace)) continue;
                prev.delete();
            }
        }
        this.comments = null;
    }

    @NotNull
    private static ASTNode normalizeWhiteSpace(PsiWhiteSpace whiteSpace) {
        int endLPos;
        String text2 = whiteSpace.getText();
        if (text2.lastIndexOf(10, (endLPos = text2.lastIndexOf(10)) - 1) >= 0) {
            LeafElement leafElement = ASTFactory.whitespace(text2.substring(endLPos));
            if (leafElement == null) {
                CommentTracker.$$$reportNull$$$0(23);
            }
            return leafElement;
        }
        LeafElement leafElement = ASTFactory.whitespace(text2);
        if (leafElement == null) {
            CommentTracker.$$$reportNull$$$0(24);
        }
        return leafElement;
    }

    private boolean shouldIgnore(PsiComment comment) {
        return this.ignoredParents.stream().anyMatch(p2 -> PsiTreeUtil.isAncestor(p2, comment, false));
    }

    private void grabComments(PsiElement element) {
        this.checkState();
        for (PsiComment comment : PsiTreeUtil.collectElementsOfType(element, PsiComment.class)) {
            if (this.shouldIgnore(comment)) continue;
            this.comments.add(comment);
        }
    }

    private void checkState() {
        if (this.comments == null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " has been already used");
        }
    }

    private void addIgnored(PsiElement element) {
        if (element instanceof LeafPsiElement && !(element instanceof PsiComment)) {
            return;
        }
        this.ignoredParents.add(element);
    }

    public static String textWithSurroundingComments(PsiElement element) {
        Predicate<PsiElement> commentOrWhiteSpace = e -> e instanceof PsiComment || e instanceof PsiWhiteSpace;
        List prev = StreamEx.iterate((Object)element.getPrevSibling(), commentOrWhiteSpace, PsiElement::getPrevSibling).toList();
        List next = StreamEx.iterate((Object)element.getNextSibling(), commentOrWhiteSpace, PsiElement::getNextSibling).toList();
        if (StreamEx.of((Object[])new List[]{prev, next}).flatCollection(Function.identity()).anyMatch(PsiComment.class::isInstance)) {
            return StreamEx.ofReversed(prev).append(element).append(next).map(PsiElement::getText).joining();
        }
        return element.getText();
    }

    @NotNull
    public static String commentsBetween(@NotNull PsiElement start, @NotNull PsiElement end) {
        PsiElement parent2;
        if (start == null) {
            CommentTracker.$$$reportNull$$$0(25);
        }
        if (end == null) {
            CommentTracker.$$$reportNull$$$0(26);
        }
        if ((parent2 = PsiTreeUtil.findCommonParent(start, end)) == null) {
            throw new IllegalStateException("Common parent is not found: [" + start + ".." + end + "]");
        }
        PsiElement cur = CommentTracker.next(start, parent2);
        ArrayList<PsiComment> comments = new ArrayList<PsiComment>();
        while (cur != null && !PsiTreeUtil.isAncestor(cur, end, false)) {
            comments.addAll(PsiTreeUtil.findChildrenOfType(cur, PsiComment.class));
            if (cur instanceof PsiComment) {
                comments.add((PsiComment)cur);
            }
            cur = CommentTracker.next(cur, parent2);
        }
        if (cur == null) {
            throw new IllegalStateException("End is not reached: [" + start + ".." + end + "]");
        }
        PsiElement tail = CommentTracker.prev(end, cur);
        ArrayDeque tailComments = new ArrayDeque();
        while (tail != null) {
            PsiTreeUtil.findChildrenOfType(tail, PsiComment.class).forEach(tailComments::addFirst);
            if (cur instanceof PsiComment) {
                comments.add((PsiComment)cur);
            }
            tail = CommentTracker.prev(tail, cur);
        }
        comments.addAll(tailComments);
        StringBuilder sb = new StringBuilder();
        for (PsiComment comment : comments) {
            PsiElement prev = CommentTracker.prev(comment, parent2);
            if (prev instanceof PsiWhiteSpace) {
                sb.append(prev.getText());
            }
            sb.append(comment.getText());
            PsiElement next = CommentTracker.next(comment, parent2);
            if (next instanceof PsiWhiteSpace) {
                sb.append(next.getText());
            }
            comment.delete();
        }
        String string = sb.toString();
        if (string == null) {
            CommentTracker.$$$reportNull$$$0(27);
        }
        return string;
    }

    private static PsiElement next(PsiElement cur, PsiElement stopAtParent) {
        if (cur == stopAtParent) {
            return null;
        }
        PsiElement next = cur.getNextSibling();
        if (next != null) {
            return next;
        }
        PsiElement parent2 = cur.getParent();
        if (parent2 == stopAtParent) {
            return null;
        }
        return CommentTracker.next(parent2, stopAtParent);
    }

    private static PsiElement prev(PsiElement cur, PsiElement stopAtParent) {
        if (cur == stopAtParent) {
            return null;
        }
        PsiElement prev = cur.getPrevSibling();
        if (prev != null) {
            return prev;
        }
        PsiElement parent2 = cur.getParent();
        if (parent2 == stopAtParent || parent2 == null) {
            return null;
        }
        return CommentTracker.prev(parent2, stopAtParent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/CommentTracker";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 11: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/CommentTracker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "text";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "markUnchanged";
                break;
            }
            case 9: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "replace";
                break;
            }
            case 15: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceAndRestoreComments";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeWhiteSpace";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "commentsBetween";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "text";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 27: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "markUnchanged";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deleteAndRestoreComments";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "replaceAndRestoreComments";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createElement";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "insertCommentsBefore";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "commentsBetween";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

