/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class DefiniteAssignment {
    @NotNull
    private final PsiVariable variable;
    private final Map<PsiElement, Boolean> definitelyAssignedBeforeBreak;
    private final Map<PsiElement, Boolean> definitelyUnassignedBeforeBreak;
    private final Map<PsiElement, Boolean> definitelyAssignedBeforeContinue;
    private final Map<PsiElement, Boolean> definitelyUnassignedBeforeContinue;
    private final Map<PsiElement, Boolean> definitelyAssignedBeforeReturn;
    private final Map<PsiElement, Boolean> definitelyUnassignedBeforeReturn;
    private boolean definitelyAssigned;
    private boolean definitelyUnassigned;

    public DefiniteAssignment(@NotNull PsiVariable variable2) {
        if (variable2 == null) {
            DefiniteAssignment.$$$reportNull$$$0(0);
        }
        this.definitelyAssignedBeforeBreak = new HashMap<PsiElement, Boolean>();
        this.definitelyUnassignedBeforeBreak = new HashMap<PsiElement, Boolean>();
        this.definitelyAssignedBeforeContinue = new HashMap<PsiElement, Boolean>();
        this.definitelyUnassignedBeforeContinue = new HashMap<PsiElement, Boolean>();
        this.definitelyAssignedBeforeReturn = new HashMap<PsiElement, Boolean>();
        this.definitelyUnassignedBeforeReturn = new HashMap<PsiElement, Boolean>();
        this.definitelyAssigned = false;
        this.definitelyUnassigned = true;
        this.variable = variable2;
    }

    public void and(boolean definitelyAssigned, boolean definitelyUnassigned) {
        this.definitelyAssigned &= definitelyAssigned;
        this.definitelyUnassigned &= definitelyUnassigned;
    }

    public void assign(@NotNull PsiReferenceExpression expression2, boolean definiteAssignment) {
        if (expression2 == null) {
            DefiniteAssignment.$$$reportNull$$$0(1);
        }
        if (definiteAssignment) {
            this.definitelyAssigned = true;
        } else {
            this.valueAccess(expression2);
        }
        this.definitelyUnassigned = false;
    }

    public void andDefiniteAssignmentBeforeBreak(PsiStatement statement2) {
        this.definitelyAssigned &= DefiniteAssignment.removeValue(statement2, this.definitelyAssignedBeforeBreak);
        this.definitelyUnassigned &= DefiniteAssignment.removeValue(statement2, this.definitelyUnassignedBeforeBreak);
    }

    public void andDefiniteAssignmentBeforeContinue(PsiStatement statement2) {
        this.definitelyAssigned &= DefiniteAssignment.removeValue(statement2, this.definitelyAssignedBeforeContinue);
        this.definitelyUnassigned &= DefiniteAssignment.removeValue(statement2, this.definitelyUnassignedBeforeContinue);
    }

    public void andDefiniteAssignmentBeforeReturn(PsiMethod method) {
        this.definitelyAssigned &= DefiniteAssignment.removeValue(method, this.definitelyAssignedBeforeReturn);
        this.definitelyUnassigned &= DefiniteAssignment.removeValue(method, this.definitelyUnassignedBeforeReturn);
    }

    private static boolean removeValue(PsiElement statement2, Map<PsiElement, Boolean> map2) {
        Boolean aBoolean = map2.remove(statement2);
        return aBoolean == null || aBoolean != false;
    }

    @NotNull
    public final PsiVariable getVariable() {
        PsiVariable psiVariable = this.variable;
        if (psiVariable == null) {
            DefiniteAssignment.$$$reportNull$$$0(2);
        }
        return psiVariable;
    }

    public boolean isDefinitelyAssigned() {
        return this.definitelyAssigned;
    }

    public boolean isDefinitelyUnassigned() {
        return this.definitelyUnassigned;
    }

    public void set(boolean definitelyAssigned, boolean definitelyUnassigned) {
        this.definitelyAssigned = definitelyAssigned;
        this.definitelyUnassigned = definitelyUnassigned;
    }

    public boolean stop() {
        return false;
    }

    public void storeBeforeBreakStatement(PsiBreakStatement breakStatement) {
        PsiStatement statement2 = breakStatement.findExitedStatement();
        if (statement2 == null) {
            return;
        }
        this.storeFor(statement2, this.definitelyAssignedBeforeBreak, this.definitelyUnassignedBeforeBreak);
    }

    public void storeBeforeContinueStatement(PsiContinueStatement continueStatement) {
        PsiStatement statement2 = continueStatement.findContinuedStatement();
        if (statement2 == null) {
            return;
        }
        this.storeFor(statement2, this.definitelyAssignedBeforeContinue, this.definitelyUnassignedBeforeContinue);
    }

    public void storeBeforeReturn(PsiReturnStatement returnStatement) {
        PsiMethod method = PsiTreeUtil.getParentOfType((PsiElement)returnStatement, PsiMethod.class, true, PsiClass.class, PsiLambdaExpression.class);
        if (method == null || !method.isConstructor()) {
            return;
        }
        this.storeFor(method, this.definitelyAssignedBeforeReturn, this.definitelyUnassignedBeforeReturn);
    }

    private void storeFor(PsiElement element, Map<PsiElement, Boolean> definitelyAssignedMap, Map<PsiElement, Boolean> definitelyUnassignedMap) {
        Boolean existingDa = definitelyAssignedMap.get(element);
        Boolean existingDu = definitelyUnassignedMap.get(element);
        definitelyAssignedMap.put(element, this.definitelyAssigned && (existingDa == null || existingDa != false));
        definitelyUnassignedMap.put(element, this.definitelyUnassigned && (existingDu == null || existingDu != false));
    }

    @NonNls
    public String toString() {
        return "DefiniteAssignment{ variable=" + this.variable + ", definitelyAssigned=" + this.definitelyAssigned + ", definitelyUnassigned=" + this.definitelyUnassigned + '}';
    }

    public void valueAccess(PsiReferenceExpression expression2) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/DefiniteAssignment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/DefiniteAssignment";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "assign";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

