/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ImportUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressionUtils {
    @NonNls
    static final Set<String> convertableBoxedClassNames = new HashSet<String>(3);

    private ExpressionUtils() {
    }

    @Nullable
    public static Object computeConstantExpression(@Nullable PsiExpression expression2) {
        return ExpressionUtils.computeConstantExpression(expression2, false);
    }

    @Nullable
    public static Object computeConstantExpression(@Nullable PsiExpression expression2, boolean throwConstantEvaluationOverflowException) {
        if (expression2 == null) {
            return null;
        }
        Project project = expression2.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
        PsiConstantEvaluationHelper constantEvaluationHelper = psiFacade.getConstantEvaluationHelper();
        return constantEvaluationHelper.computeConstantExpression(expression2, throwConstantEvaluationOverflowException);
    }

    public static boolean isConstant(PsiField field) {
        if (!field.hasModifierProperty("final")) {
            return false;
        }
        if (CollectionUtils.isEmptyArray(field)) {
            return true;
        }
        PsiType type2 = field.getType();
        return ClassUtils.isImmutable(type2);
    }

    public static boolean hasExpressionCount(@Nullable PsiExpressionList expressionList, int count2) {
        return ControlFlowUtils.hasChildrenOfTypeCount(expressionList, count2, PsiExpression.class);
    }

    @Nullable
    public static PsiExpression getFirstExpressionInList(@Nullable PsiExpressionList expressionList) {
        return PsiTreeUtil.getChildOfType(expressionList, PsiExpression.class);
    }

    @Nullable
    public static PsiExpression getOnlyExpressionInList(@Nullable PsiExpressionList expressionList) {
        return ControlFlowUtils.getOnlyChildOfType(expressionList, PsiExpression.class);
    }

    public static boolean isDeclaredConstant(PsiExpression expression2) {
        PsiField field = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiField.class);
        if (field == null) {
            PsiAssignmentExpression assignmentExpression = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiAssignmentExpression.class);
            if (assignmentExpression == null) {
                return false;
            }
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiField)) {
                return false;
            }
            field = (PsiField)target;
        }
        return field.hasModifierProperty("static") && field.hasModifierProperty("final");
    }

    @Contract(value="null -> false")
    public static boolean isEvaluatedAtCompileTime(@Nullable PsiExpression expression2) {
        if (expression2 instanceof PsiLiteralExpression) {
            return true;
        }
        if (expression2 instanceof PsiPolyadicExpression) {
            PsiExpression[] operands;
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
            for (PsiExpression operand : operands = polyadicExpression.getOperands()) {
                if (ExpressionUtils.isEvaluatedAtCompileTime(operand)) continue;
                return false;
            }
            return true;
        }
        if (expression2 instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression2;
            PsiExpression operand = prefixExpression.getOperand();
            return ExpressionUtils.isEvaluatedAtCompileTime(operand);
        }
        if (expression2 instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            PsiElement qualifier = referenceExpression.getQualifier();
            if (qualifier instanceof PsiThisExpression) {
                return false;
            }
            PsiElement element = referenceExpression.resolve();
            if (element instanceof PsiField) {
                PsiField field = (PsiField)element;
                PsiExpression initializer2 = field.getInitializer();
                return field.hasModifierProperty("final") && ExpressionUtils.isEvaluatedAtCompileTime(initializer2);
            }
            if (element instanceof PsiVariable) {
                PsiVariable variable2 = (PsiVariable)element;
                if (PsiTreeUtil.isAncestor(variable2, expression2, true)) {
                    return false;
                }
                PsiExpression initializer3 = variable2.getInitializer();
                return variable2.hasModifierProperty("final") && ExpressionUtils.isEvaluatedAtCompileTime(initializer3);
            }
        }
        if (expression2 instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
            PsiExpression deparenthesizedExpression = parenthesizedExpression.getExpression();
            return ExpressionUtils.isEvaluatedAtCompileTime(deparenthesizedExpression);
        }
        if (expression2 instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression2;
            PsiExpression condition = conditionalExpression.getCondition();
            PsiExpression thenExpression = conditionalExpression.getThenExpression();
            PsiExpression elseExpression = conditionalExpression.getElseExpression();
            return ExpressionUtils.isEvaluatedAtCompileTime(condition) && ExpressionUtils.isEvaluatedAtCompileTime(thenExpression) && ExpressionUtils.isEvaluatedAtCompileTime(elseExpression);
        }
        if (expression2 instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression2;
            PsiTypeElement castType = typeCastExpression.getCastType();
            if (castType == null) {
                return false;
            }
            PsiType type2 = castType.getType();
            return TypeUtils.typeEquals("java.lang.String", type2);
        }
        return false;
    }

    @Nullable
    public static String getLiteralString(@Nullable PsiExpression expression2) {
        PsiLiteralExpression literal = ExpressionUtils.getLiteral(expression2);
        if (literal == null) {
            return null;
        }
        Object value = literal.getValue();
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Nullable
    public static PsiLiteralExpression getLiteral(@Nullable PsiExpression expression2) {
        if ((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiLiteralExpression) {
            return (PsiLiteralExpression)expression2;
        }
        if (!(expression2 instanceof PsiTypeCastExpression)) {
            return null;
        }
        PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression2;
        PsiExpression operand = ParenthesesUtils.stripParentheses(typeCastExpression.getOperand());
        if (!(operand instanceof PsiLiteralExpression)) {
            return null;
        }
        return (PsiLiteralExpression)operand;
    }

    public static boolean isLiteral(@Nullable PsiExpression expression2) {
        return ExpressionUtils.getLiteral(expression2) != null;
    }

    public static boolean isEmptyStringLiteral(@Nullable PsiExpression expression2) {
        if (!((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiLiteralExpression)) {
            return false;
        }
        String text2 = expression2.getText();
        return "\"\"".equals(text2);
    }

    @Contract(value="null -> false")
    public static boolean isNullLiteral(@Nullable PsiExpression expression2) {
        return (expression2 = PsiUtil.deparenthesizeExpression(expression2)) != null && PsiType.NULL.equals(expression2.getType());
    }

    public static Stream<PsiExpression> nonStructuralChildren(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            ExpressionUtils.$$$reportNull$$$0(0);
        }
        return ((StreamEx)StreamEx.ofTree((Object)expression2, e -> {
            if (e instanceof PsiConditionalExpression) {
                PsiConditionalExpression ternary = (PsiConditionalExpression)e;
                return StreamEx.of((Object[])new PsiExpression[]{ternary.getThenExpression(), ternary.getElseExpression()}).nonNull();
            }
            if (e instanceof PsiParenthesizedExpression) {
                return StreamEx.ofNullable((Object)((PsiParenthesizedExpression)e).getExpression());
            }
            return null;
        }).remove(e -> e instanceof PsiConditionalExpression || e instanceof PsiParenthesizedExpression)).map(e -> {
            PsiExpression operand;
            if (e instanceof PsiTypeCastExpression && (operand = ((PsiTypeCastExpression)e).getOperand()) != null && !(e.getType() instanceof PsiPrimitiveType) && (!(operand.getType() instanceof PsiPrimitiveType) || PsiType.NULL.equals(operand.getType()))) {
                return PsiUtil.skipParenthesizedExprDown(operand);
            }
            return e;
        });
    }

    public static boolean isZero(@Nullable PsiExpression expression2) {
        if (expression2 == null) {
            return false;
        }
        PsiType expressionType = expression2.getType();
        Object value = ConstantExpressionUtil.computeCastTo(expression2, expressionType);
        if (value == null) {
            return false;
        }
        if (value instanceof Double && (Double)value == 0.0) {
            return true;
        }
        if (value instanceof Float && ((Float)value).floatValue() == 0.0f) {
            return true;
        }
        if (value instanceof Integer && (Integer)value == 0) {
            return true;
        }
        if (value instanceof Long && (Long)value == 0L) {
            return true;
        }
        if (value instanceof Short && (Short)value == 0) {
            return true;
        }
        if (value instanceof Character && ((Character)value).charValue() == '\u0000') {
            return true;
        }
        return value instanceof Byte && (Byte)value == 0;
    }

    public static boolean isOne(@Nullable PsiExpression expression2) {
        if (expression2 == null) {
            return false;
        }
        Object value = ExpressionUtils.computeConstantExpression(expression2);
        if (value == null) {
            return false;
        }
        if (value instanceof Double && (Double)value == 1.0) {
            return true;
        }
        if (value instanceof Float && ((Float)value).floatValue() == 1.0f) {
            return true;
        }
        if (value instanceof Integer && (Integer)value == 1) {
            return true;
        }
        if (value instanceof Long && (Long)value == 1L) {
            return true;
        }
        if (value instanceof Short && (Short)value == 1) {
            return true;
        }
        if (value instanceof Character && ((Character)value).charValue() == '\u0001') {
            return true;
        }
        return value instanceof Byte && (Byte)value == 1;
    }

    public static boolean isNegation(@Nullable PsiExpression condition, boolean ignoreNegatedNullComparison, boolean ignoreNegatedZeroComparison) {
        if ((condition = ParenthesesUtils.stripParentheses(condition)) instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)condition;
            IElementType tokenType = prefixExpression.getOperationTokenType();
            return tokenType.equals(JavaTokenType.EXCL);
        }
        if (condition instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
            PsiExpression lhs = ParenthesesUtils.stripParentheses(binaryExpression.getLOperand());
            PsiExpression rhs = ParenthesesUtils.stripParentheses(binaryExpression.getROperand());
            if (lhs == null || rhs == null) {
                return false;
            }
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (tokenType.equals(JavaTokenType.NE)) {
                if (ignoreNegatedNullComparison) {
                    String lhsText = lhs.getText();
                    String rhsText = rhs.getText();
                    if ("null".equals(lhsText) || "null".equals(rhsText)) {
                        return false;
                    }
                }
                return !ignoreNegatedZeroComparison || !ExpressionUtils.isZeroLiteral(lhs) && !ExpressionUtils.isZeroLiteral(rhs);
            }
        }
        return false;
    }

    private static boolean isZeroLiteral(PsiExpression expression2) {
        if (!(expression2 instanceof PsiLiteralExpression)) {
            return false;
        }
        PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression2;
        Object value = literalExpression.getValue();
        return value instanceof Integer ? (Integer)value == 0 : value instanceof Long && (Long)value == 0L;
    }

    public static boolean isOffsetArrayAccess(@Nullable PsiExpression expression2, @NotNull PsiVariable variable2) {
        PsiExpression strippedExpression;
        if (variable2 == null) {
            ExpressionUtils.$$$reportNull$$$0(1);
        }
        if (!((strippedExpression = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiArrayAccessExpression)) {
            return false;
        }
        PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)strippedExpression;
        PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
        if (VariableAccessUtils.variableIsUsed(variable2, arrayExpression)) {
            return false;
        }
        PsiExpression index2 = arrayAccessExpression.getIndexExpression();
        if (index2 == null) {
            return false;
        }
        return ExpressionUtils.expressionIsOffsetVariableLookup(index2, variable2);
    }

    private static boolean expressionIsOffsetVariableLookup(@Nullable PsiExpression expression2, @NotNull PsiVariable variable2) {
        if (variable2 == null) {
            ExpressionUtils.$$$reportNull$$$0(2);
        }
        if (VariableAccessUtils.evaluatesToVariable(expression2, variable2)) {
            return true;
        }
        PsiExpression strippedExpression = ParenthesesUtils.stripParentheses(expression2);
        if (!(strippedExpression instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)strippedExpression;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        if (!JavaTokenType.PLUS.equals(tokenType) && !JavaTokenType.MINUS.equals(tokenType)) {
            return false;
        }
        PsiExpression lhs = binaryExpression.getLOperand();
        if (ExpressionUtils.expressionIsOffsetVariableLookup(lhs, variable2)) {
            return true;
        }
        PsiExpression rhs = binaryExpression.getROperand();
        return ExpressionUtils.expressionIsOffsetVariableLookup(rhs, variable2) && !JavaTokenType.MINUS.equals(tokenType);
    }

    public static boolean isVariableLessThanComparison(@Nullable PsiExpression expression2, @NotNull PsiVariable variable2) {
        if (variable2 == null) {
            ExpressionUtils.$$$reportNull$$$0(3);
        }
        if (!((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        if (tokenType.equals(JavaTokenType.LT) || tokenType.equals(JavaTokenType.LE)) {
            PsiExpression lhs = binaryExpression.getLOperand();
            return VariableAccessUtils.evaluatesToVariable(lhs, variable2);
        }
        if (tokenType.equals(JavaTokenType.GT) || tokenType.equals(JavaTokenType.GE)) {
            PsiExpression rhs = binaryExpression.getROperand();
            return VariableAccessUtils.evaluatesToVariable(rhs, variable2);
        }
        return false;
    }

    public static boolean isVariableGreaterThanComparison(@Nullable PsiExpression expression2, @NotNull PsiVariable variable2) {
        if (variable2 == null) {
            ExpressionUtils.$$$reportNull$$$0(4);
        }
        if (!((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        if (tokenType.equals(JavaTokenType.GT) || tokenType.equals(JavaTokenType.GE)) {
            PsiExpression lhs = binaryExpression.getLOperand();
            return VariableAccessUtils.evaluatesToVariable(lhs, variable2);
        }
        if (tokenType.equals(JavaTokenType.LT) || tokenType.equals(JavaTokenType.LE)) {
            PsiExpression rhs = binaryExpression.getROperand();
            return VariableAccessUtils.evaluatesToVariable(rhs, variable2);
        }
        return false;
    }

    public static boolean isStringConcatenationOperand(PsiExpression expression2) {
        PsiElement parent2 = expression2.getParent();
        if (!(parent2 instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent2;
        if (!JavaTokenType.PLUS.equals(polyadicExpression.getOperationTokenType())) {
            return false;
        }
        Object[] operands = polyadicExpression.getOperands();
        if (operands.length < 2) {
            return false;
        }
        int index2 = ArrayUtil.indexOf(operands, expression2);
        for (int i2 = 0; i2 < index2; ++i2) {
            PsiType type2 = operands[i2].getType();
            if (!TypeUtils.isJavaLangString(type2)) continue;
            return true;
        }
        if (index2 == 0) {
            PsiType type3 = operands[index2 + 1].getType();
            return TypeUtils.isJavaLangString(type3);
        }
        return false;
    }

    public static boolean isConstructorInvocation(PsiElement element) {
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String callName = methodExpression.getReferenceName();
        return "this".equals(callName) || "super".equals(callName);
    }

    public static boolean hasType(@Nullable PsiExpression expression2, @NonNls @NotNull String typeName) {
        if (typeName == null) {
            ExpressionUtils.$$$reportNull$$$0(5);
        }
        if (expression2 == null) {
            return false;
        }
        PsiType type2 = expression2.getType();
        return TypeUtils.typeEquals(typeName, type2);
    }

    public static boolean hasStringType(@Nullable PsiExpression expression2) {
        return ExpressionUtils.hasType(expression2, "java.lang.String");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isConversionToStringNecessary(PsiExpression expression2, boolean throwable) {
        PsiElement parent2 = ParenthesesUtils.getParentSkipParentheses(expression2);
        if (parent2 instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent2;
            PsiType type2 = polyadicExpression.getType();
            if (!TypeUtils.typeEquals("java.lang.String", type2)) {
                return true;
            }
            PsiExpression[] operands = polyadicExpression.getOperands();
            boolean expressionSeen = false;
            int length = operands.length;
            for (int i2 = 0; i2 < length; ++i2) {
                PsiExpression operand = operands[i2];
                if (PsiTreeUtil.isAncestor(operand, expression2, false)) {
                    if (i2 > 0) {
                        return true;
                    }
                    expressionSeen = true;
                    continue;
                }
                if (expressionSeen && i2 != 1 || !TypeUtils.isJavaLangString(operand.getType())) continue;
                return false;
            }
            return true;
        }
        if (!(parent2 instanceof PsiExpressionList)) return true;
        PsiExpressionList expressionList = (PsiExpressionList)parent2;
        PsiElement grandParent = expressionList.getParent();
        if (!(grandParent instanceof PsiMethodCallExpression)) {
            return true;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
        PsiReferenceExpression methodExpression1 = methodCallExpression.getMethodExpression();
        String name = methodExpression1.getReferenceName();
        PsiExpression[] expressions = expressionList.getExpressions();
        if ("insert".equals(name)) {
            if (expressions.length < 2 || !expression2.equals(ParenthesesUtils.stripParentheses(expressions[1]))) {
                return true;
            }
            if (ExpressionUtils.isCallToMethodIn(methodCallExpression, "java.lang.StringBuilder", "java.lang.StringBuffer")) return false;
            return true;
        }
        if ("append".equals(name)) {
            if (expressions.length < 1 || !expression2.equals(ParenthesesUtils.stripParentheses(expressions[0]))) {
                return true;
            }
            if (ExpressionUtils.isCallToMethodIn(methodCallExpression, "java.lang.StringBuilder", "java.lang.StringBuffer")) return false;
            return true;
        }
        if ("print".equals(name) || "println".equals(name)) {
            if (ExpressionUtils.isCallToMethodIn(methodCallExpression, "java.io.PrintStream", "java.io.PrintWriter")) return false;
            return true;
        }
        if (!"trace".equals(name) && !"debug".equals(name) && !"info".equals(name) && !"warn".equals(name) && !"error".equals(name)) return true;
        if (!ExpressionUtils.isCallToMethodIn(methodCallExpression, "org.slf4j.Logger")) {
            return true;
        }
        int l = 1;
        for (int i3 = 0; i3 < expressions.length; ++i3) {
            PsiExpression expression1 = expressions[i3];
            if (i3 == 0 && TypeUtils.expressionHasTypeOrSubtype(expression1, "org.slf4j.Marker")) {
                l = 2;
            }
            if (expression1 != expression2 || i3 >= l && (!throwable || i3 != expressions.length - 1)) continue;
            return true;
        }
        return false;
    }

    private static boolean isCallToMethodIn(PsiMethodCallExpression methodCallExpression, String ... classNames2) {
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        String qualifiedName2 = containingClass.getQualifiedName();
        for (String className2 : classNames2) {
            if (!className2.equals(qualifiedName2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNegative(@NotNull PsiExpression expression2) {
        PsiElement parent2;
        if (expression2 == null) {
            ExpressionUtils.$$$reportNull$$$0(6);
        }
        if (!((parent2 = expression2.getParent()) instanceof PsiPrefixExpression)) {
            return false;
        }
        PsiPrefixExpression prefixExpression = (PsiPrefixExpression)parent2;
        IElementType tokenType = prefixExpression.getOperationTokenType();
        return JavaTokenType.MINUS.equals(tokenType);
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static PsiVariable getVariableFromNullComparison(PsiExpression expression2, boolean equals) {
        PsiReferenceExpression referenceExpression = ExpressionUtils.getReferenceExpressionFromNullComparison(expression2, equals);
        PsiElement target = referenceExpression != null ? referenceExpression.resolve() : null;
        return target instanceof PsiVariable ? (PsiVariable)target : null;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static PsiReferenceExpression getReferenceExpressionFromNullComparison(PsiExpression expression2, boolean equals) {
        if (!((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiPolyadicExpression)) {
            return null;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
        IElementType tokenType = polyadicExpression.getOperationTokenType();
        if (equals ? !JavaTokenType.EQEQ.equals(tokenType) : !JavaTokenType.NE.equals(tokenType)) {
            return null;
        }
        PsiExpression[] operands = polyadicExpression.getOperands();
        if (operands.length != 2) {
            return null;
        }
        PsiExpression comparedToNull = null;
        if (PsiType.NULL.equals(operands[0].getType())) {
            comparedToNull = operands[1];
        } else if (PsiType.NULL.equals(operands[1].getType())) {
            comparedToNull = operands[0];
        }
        comparedToNull = ParenthesesUtils.stripParentheses(comparedToNull);
        return comparedToNull instanceof PsiReferenceExpression ? (PsiReferenceExpression)comparedToNull : null;
    }

    @Nullable
    public static PsiExpression getValueComparedWithNull(@NotNull PsiBinaryExpression binOp) {
        IElementType tokenType;
        if (binOp == null) {
            ExpressionUtils.$$$reportNull$$$0(7);
        }
        if (!(tokenType = binOp.getOperationTokenType()).equals(JavaTokenType.EQEQ) && !tokenType.equals(JavaTokenType.NE)) {
            return null;
        }
        PsiExpression left = binOp.getLOperand();
        PsiExpression right = binOp.getROperand();
        if (ExpressionUtils.isNullLiteral(right)) {
            return left;
        }
        if (ExpressionUtils.isNullLiteral(left)) {
            return right;
        }
        return null;
    }

    @Nullable
    public static PsiExpression getValueComparedWithZero(@NotNull PsiBinaryExpression binOp) {
        if (binOp == null) {
            ExpressionUtils.$$$reportNull$$$0(8);
        }
        return ExpressionUtils.getValueComparedWithZero(binOp, JavaTokenType.EQEQ);
    }

    @Nullable
    public static PsiExpression getValueComparedWithZero(@NotNull PsiBinaryExpression binOp, IElementType opType) {
        if (binOp == null) {
            ExpressionUtils.$$$reportNull$$$0(9);
        }
        if (!binOp.getOperationTokenType().equals(opType)) {
            return null;
        }
        PsiExpression rOperand = binOp.getROperand();
        if (rOperand == null) {
            return null;
        }
        PsiExpression lOperand = binOp.getLOperand();
        if (ExpressionUtils.isZero(lOperand)) {
            return rOperand;
        }
        if (ExpressionUtils.isZero(rOperand)) {
            return lOperand;
        }
        return null;
    }

    public static boolean isConcatenation(PsiElement element) {
        if (!(element instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression expression2 = (PsiPolyadicExpression)element;
        PsiType type2 = expression2.getType();
        return type2 != null && type2.equalsToText("java.lang.String");
    }

    public static boolean isAnnotatedNotNull(PsiExpression expression2) {
        return ExpressionUtils.isAnnotated(expression2, false);
    }

    public static boolean isAnnotatedNullable(PsiExpression expression2) {
        return ExpressionUtils.isAnnotated(expression2, true);
    }

    private static boolean isAnnotated(PsiExpression expression2, boolean nullable) {
        if (!((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
        PsiElement target = referenceExpression.resolve();
        if (!(target instanceof PsiModifierListOwner)) {
            return false;
        }
        PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)target;
        return nullable ? NullableNotNullManager.isNullable(modifierListOwner) : NullableNotNullManager.isNotNull(modifierListOwner);
    }

    @Contract(value="null -> false")
    public static boolean isSimpleExpression(@Nullable PsiExpression expression2) {
        if ((expression2 = PsiUtil.skipParenthesizedExprDown(expression2)) instanceof PsiLiteralExpression || expression2 instanceof PsiThisExpression || expression2 instanceof PsiClassObjectAccessExpression || ExpressionUtils.isEvaluatedAtCompileTime(expression2)) {
            return true;
        }
        if (expression2 instanceof PsiReferenceExpression) {
            PsiElement resolvedQualifier;
            PsiExpression qualifier = ((PsiReferenceExpression)expression2).getQualifierExpression();
            if (qualifier == null || qualifier instanceof PsiThisExpression) {
                return true;
            }
            if (qualifier instanceof PsiReferenceExpression && (resolvedQualifier = ((PsiReferenceExpression)qualifier).resolve()) instanceof PsiClass) {
                return true;
            }
        }
        return false;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiAssignmentExpression getAssignment(PsiElement element) {
        PsiAssignmentExpression assignment;
        if (element instanceof PsiExpressionStatement) {
            element = ((PsiExpressionStatement)element).getExpression();
        }
        if (element instanceof PsiExpression && (element = PsiUtil.skipParenthesizedExprDown((PsiExpression)element)) instanceof PsiAssignmentExpression && (assignment = (PsiAssignmentExpression)element).getOperationTokenType().equals(JavaTokenType.EQ)) {
            return assignment;
        }
        return null;
    }

    @Contract(value="null, _ -> null; _, null -> null")
    public static PsiExpression getAssignmentTo(PsiElement element, PsiVariable target) {
        PsiAssignmentExpression assignment = ExpressionUtils.getAssignment(element);
        if (assignment != null && ExpressionUtils.isReferenceTo(assignment.getLExpression(), target)) {
            return assignment.getRExpression();
        }
        return null;
    }

    @Contract(value="null, _ -> false")
    public static boolean isLiteral(PsiElement element, Object value) {
        return element instanceof PsiLiteralExpression && value.equals(((PsiLiteralExpression)element).getValue());
    }

    public static boolean isAutoBoxed(@NotNull PsiExpression expression2) {
        PsiMethodCallExpression methodCallExpression;
        PsiMethod method;
        PsiElement grandParent;
        PsiElement parent2;
        if (expression2 == null) {
            ExpressionUtils.$$$reportNull$$$0(10);
        }
        if ((parent2 = expression2.getParent()) instanceof PsiParenthesizedExpression) {
            return false;
        }
        if (parent2 instanceof PsiExpressionList && (grandParent = parent2.getParent()) instanceof PsiMethodCallExpression && (method = (methodCallExpression = (PsiMethodCallExpression)grandParent).resolveMethod()) != null && AnnotationUtil.isAnnotated(method, Collections.singletonList("java.lang.invoke.MethodHandle.PolymorphicSignature"))) {
            return false;
        }
        PsiType expressionType = expression2.getType();
        if (PsiPrimitiveType.getUnboxedType(expressionType) != null && parent2 instanceof PsiUnaryExpression) {
            IElementType sign = ((PsiUnaryExpression)parent2).getOperationTokenType();
            return sign == JavaTokenType.PLUSPLUS || sign == JavaTokenType.MINUSMINUS;
        }
        if (expressionType == null || expressionType.equals(PsiType.VOID) || !TypeConversionUtil.isPrimitiveAndNotNull(expressionType)) {
            return false;
        }
        PsiPrimitiveType primitiveType = (PsiPrimitiveType)expressionType;
        PsiClassType boxedType = primitiveType.getBoxedType(expression2);
        if (boxedType == null) {
            return false;
        }
        PsiType expectedType2 = ExpectedTypeUtils.findExpectedType(expression2, false, true);
        if (expectedType2 == null || ClassUtils.isPrimitive(expectedType2)) {
            return false;
        }
        if (!expectedType2.isAssignableFrom(boxedType)) {
            if (!(expectedType2 instanceof PsiClassType) || !PsiUtil.isConstantExpression(expression2)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)expectedType2;
            String className2 = classType.getCanonicalText();
            if (!convertableBoxedClassNames.contains(className2)) {
                return false;
            }
            if (!(PsiType.BYTE.equals(expressionType) || PsiType.CHAR.equals(expressionType) || PsiType.SHORT.equals(expressionType) || PsiType.INT.equals(expressionType))) {
                return false;
            }
        }
        return true;
    }

    @Contract(value="null, _ -> null; !null, null -> null")
    public static PsiExpression getOtherOperand(@Nullable PsiBinaryExpression binOp, @Nullable PsiVariable variable2) {
        if (binOp == null || variable2 == null) {
            return null;
        }
        if (ExpressionUtils.isReferenceTo(binOp.getLOperand(), variable2)) {
            return binOp.getROperand();
        }
        if (ExpressionUtils.isReferenceTo(binOp.getROperand(), variable2)) {
            return binOp.getLOperand();
        }
        return null;
    }

    @Contract(value="null, _ -> false; _, null -> false")
    public static boolean isReferenceTo(PsiExpression expression2, PsiVariable variable2) {
        if (variable2 == null) {
            return false;
        }
        return (expression2 = PsiUtil.skipParenthesizedExprDown(expression2)) instanceof PsiReferenceExpression && ((PsiReferenceExpression)expression2).isReferenceTo(variable2);
    }

    @Contract(value="null -> null", pure=true)
    public static PsiMethodCallExpression getCallForQualifier(PsiExpression qualifier) {
        PsiElement gParent;
        PsiReferenceExpression methodExpression;
        if (qualifier == null) {
            return null;
        }
        PsiElement parent2 = PsiUtil.skipParenthesizedExprUp(qualifier.getParent());
        if (parent2 instanceof PsiReferenceExpression && PsiTreeUtil.isAncestor((methodExpression = (PsiReferenceExpression)parent2).getQualifierExpression(), qualifier, false) && (gParent = methodExpression.getParent()) instanceof PsiMethodCallExpression) {
            return (PsiMethodCallExpression)gParent;
        }
        return null;
    }

    @Nullable
    public static PsiExpression getArrayFromLengthExpression(PsiExpression expression2) {
        if (!((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression reference = (PsiReferenceExpression)expression2;
        String referenceName = reference.getReferenceName();
        if (!"length".equals(referenceName)) {
            return null;
        }
        PsiExpression qualifier = reference.getQualifierExpression();
        if (qualifier == null) {
            return null;
        }
        PsiType type2 = qualifier.getType();
        if (type2 == null || type2.getArrayDimensions() <= 0) {
            return null;
        }
        return qualifier;
    }

    @NotNull
    public static PsiExpression getQualifierOrThis(@NotNull PsiReferenceExpression ref) {
        PsiClass memberClass;
        PsiExpression qualifier;
        if (ref == null) {
            ExpressionUtils.$$$reportNull$$$0(11);
        }
        if ((qualifier = ref.getQualifierExpression()) != null) {
            PsiExpression psiExpression = qualifier;
            if (psiExpression == null) {
                ExpressionUtils.$$$reportNull$$$0(12);
            }
            return psiExpression;
        }
        PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(ref.getProject());
        PsiMember member = ObjectUtils.tryCast(ref.resolve(), PsiMember.class);
        if (member != null && (memberClass = member.getContainingClass()) != null) {
            PsiClass containingClass = ClassUtils.getContainingClass(ref);
            if (containingClass == null) {
                containingClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)ref, PsiClass.class);
            }
            if (!InheritanceUtil.isInheritorOrSelf(containingClass, memberClass, true)) {
                containingClass = ClassUtils.getContainingClass(containingClass);
                while (containingClass != null && !InheritanceUtil.isInheritorOrSelf(containingClass, memberClass, true)) {
                    containingClass = ClassUtils.getContainingClass(containingClass);
                }
                if (containingClass != null) {
                    PsiExpression psiExpression = factory2.createExpressionFromText(containingClass.getQualifiedName() + "." + "this", ref);
                    if (psiExpression == null) {
                        ExpressionUtils.$$$reportNull$$$0(13);
                    }
                    return psiExpression;
                }
            }
        }
        PsiExpression psiExpression = factory2.createExpressionFromText("this", ref);
        if (psiExpression == null) {
            ExpressionUtils.$$$reportNull$$$0(14);
        }
        return psiExpression;
    }

    public static void bindReferenceTo(@NotNull PsiReferenceExpression ref, @NotNull String newName2) {
        PsiMember member;
        PsiMember member2;
        PsiElement nameElement;
        if (ref == null) {
            ExpressionUtils.$$$reportNull$$$0(15);
        }
        if (newName2 == null) {
            ExpressionUtils.$$$reportNull$$$0(16);
        }
        if ((nameElement = ref.getReferenceNameElement()) == null) {
            throw new IllegalStateException("Name element is null: " + ref);
        }
        if (newName2.equals(nameElement.getText())) {
            return;
        }
        PsiClass aClass2 = null;
        if (ref.getQualifierExpression() == null && (member2 = ObjectUtils.tryCast(ref.resolve(), PsiMember.class)) != null && ImportUtils.isStaticallyImported(member2, ref)) {
            aClass2 = member2.getContainingClass();
        }
        PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(ref.getProject());
        PsiIdentifier identifier = factory2.createIdentifier(newName2);
        nameElement.replace(identifier);
        if (aClass2 != null && ((member = ObjectUtils.tryCast(ref.resolve(), PsiMember.class)) == null || member.getContainingClass() != aClass2)) {
            ref.setQualifierExpression(factory2.createReferenceExpression(aClass2));
        }
    }

    public static void bindCallTo(@NotNull PsiMethodCallExpression call2, @NotNull String newName2) {
        if (call2 == null) {
            ExpressionUtils.$$$reportNull$$$0(17);
        }
        if (newName2 == null) {
            ExpressionUtils.$$$reportNull$$$0(18);
        }
        ExpressionUtils.bindReferenceTo(call2.getMethodExpression(), newName2);
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiExpression resolveExpression(@Nullable PsiExpression expression2) {
        PsiExpression initializer2;
        PsiReferenceExpression reference;
        PsiLocalVariable variable2;
        if ((expression2 = PsiUtil.skipParenthesizedExprDown(expression2)) instanceof PsiReferenceExpression && (variable2 = ObjectUtils.tryCast((reference = (PsiReferenceExpression)expression2).resolve(), PsiLocalVariable.class)) != null && (initializer2 = variable2.getInitializer()) != null && ReferencesSearch.search(variable2).forEach(ref -> ref == reference)) {
            return initializer2;
        }
        return expression2;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiLocalVariable resolveLocalVariable(@Nullable PsiExpression expression2) {
        PsiReferenceExpression referenceExpression = ObjectUtils.tryCast(expression2, PsiReferenceExpression.class);
        if (referenceExpression == null) {
            return null;
        }
        return ObjectUtils.tryCast(referenceExpression.resolve(), PsiLocalVariable.class);
    }

    public static boolean isOctalLiteral(PsiLiteralExpression literal) {
        PsiType type2 = literal.getType();
        if (!PsiType.INT.equals(type2) && !PsiType.LONG.equals(type2)) {
            return false;
        }
        if (literal.getValue() == null) {
            return false;
        }
        String text2 = literal.getText();
        if (text2.charAt(0) != '0' || text2.length() < 2) {
            return false;
        }
        char c1 = text2.charAt(1);
        return c1 == '_' || c1 >= '0' && c1 <= '7';
    }

    @Contract(value="null, _ -> false")
    public static boolean isMatchingChildAlwaysExecuted(@Nullable PsiExpression root2, final @NotNull Predicate<PsiExpression> matcher) {
        if (matcher == null) {
            ExpressionUtils.$$$reportNull$$$0(19);
        }
        if (root2 == null) {
            return false;
        }
        final AtomicBoolean result2 = new AtomicBoolean(false);
        root2.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitExpression(PsiExpression expression2) {
                super.visitExpression(expression2);
                if (matcher.test(expression2)) {
                    result2.set(true);
                    this.stopWalking();
                }
            }

            @Override
            public void visitConditionalExpression(PsiConditionalExpression expression2) {
                if (ExpressionUtils.isMatchingChildAlwaysExecuted(expression2.getCondition(), matcher) || ExpressionUtils.isMatchingChildAlwaysExecuted(expression2.getThenExpression(), matcher) && ExpressionUtils.isMatchingChildAlwaysExecuted(expression2.getElseExpression(), matcher)) {
                    result2.set(true);
                    this.stopWalking();
                }
            }

            @Override
            public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
                IElementType type2 = expression2.getOperationTokenType();
                if (type2.equals(JavaTokenType.OROR) || type2.equals(JavaTokenType.ANDAND)) {
                    PsiExpression firstOperand = ArrayUtil.getFirstElement(expression2.getOperands());
                    if (ExpressionUtils.isMatchingChildAlwaysExecuted(firstOperand, matcher)) {
                        result2.set(true);
                        this.stopWalking();
                    }
                } else {
                    super.visitPolyadicExpression(expression2);
                }
            }

            @Override
            public void visitClass(PsiClass aClass2) {
            }

            @Override
            public void visitLambdaExpression(PsiLambdaExpression expression2) {
            }
        });
        return result2.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Contract(value="null -> false")
    public static boolean isNewObject(@Nullable PsiExpression expression2) {
        if (expression2 == null) return false;
        if (!ExpressionUtils.nonStructuralChildren(expression2).allMatch(PsiNewExpression.class::isInstance)) return false;
        return true;
    }

    static {
        convertableBoxedClassNames.add("java.lang.Byte");
        convertableBoxedClassNames.add("java.lang.Character");
        convertableBoxedClassNames.add("java.lang.Short");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binOp";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/ExpressionUtils";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/ExpressionUtils";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierOrThis";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "nonStructuralChildren";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isOffsetArrayAccess";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "expressionIsOffsetVariableLookup";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isVariableLessThanComparison";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isVariableGreaterThanComparison";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isNegative";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getValueComparedWithNull";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getValueComparedWithZero";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAutoBoxed";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierOrThis";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "bindReferenceTo";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "bindCallTo";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isMatchingChildAlwaysExecuted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

