/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.DefiniteAssignment;
import com.siyeh.ig.psiutils.DefiniteAssignmentUtil;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.psiutils.VariableAssignedVisitor;
import org.jetbrains.annotations.NotNull;

public class FinalUtils {
    private FinalUtils() {
    }

    public static boolean canBeFinal(@NotNull PsiVariable variable2) {
        if (variable2 == null) {
            FinalUtils.$$$reportNull$$$0(0);
        }
        if (variable2.getInitializer() != null || variable2 instanceof PsiParameter) {
            return !VariableAccessUtils.variableIsAssigned(variable2);
        }
        FinalDefiniteAssignment definiteAssignment = new FinalDefiniteAssignment(variable2);
        DefiniteAssignmentUtil.checkVariable(variable2, definiteAssignment);
        return definiteAssignment.isDefinitelyAssigned() && !definiteAssignment.isDefinitelyUnassigned() && definiteAssignment.canBeFinal() && !FinalUtils.isWrittenToOutsideOfConstruction(variable2);
    }

    private static boolean isWrittenToOutsideOfConstruction(PsiVariable variable2) {
        if (!(variable2 instanceof PsiField)) {
            return false;
        }
        PsiField field = (PsiField)variable2;
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        PsiClass topLevelClass = PsiUtil.getTopLevelClass(variable2);
        VariableAssignedVisitor visitor2 = new VariableAssignedVisitor(field);
        if (topLevelClass != null && !containingClass.equals(topLevelClass)) {
            visitor2.setExcludedElement(containingClass);
            topLevelClass.accept(visitor2);
            if (visitor2.isAssigned()) {
                return true;
            }
        }
        if (field.hasModifierProperty("static")) {
            for (PsiElement child : containingClass.getChildren()) {
                if (child instanceof PsiClassInitializer) {
                    PsiClassInitializer classInitializer = (PsiClassInitializer)child;
                    if (classInitializer.hasModifierProperty("static")) continue;
                    classInitializer.accept(visitor2);
                } else if (child instanceof PsiField) {
                    PsiField otherField = (PsiField)child;
                    if (otherField.hasModifierProperty("static")) continue;
                    otherField.accept(visitor2);
                } else if (child instanceof PsiMethod || child instanceof PsiClass) {
                    child.accept(visitor2);
                }
                if (!visitor2.isAssigned()) continue;
                return true;
            }
        } else {
            for (PsiElement child : containingClass.getChildren()) {
                if (child instanceof PsiField) {
                    PsiField otherField = (PsiField)child;
                    if (!otherField.hasModifierProperty("static")) continue;
                    otherField.accept(visitor2);
                } else if (child instanceof PsiClassInitializer) {
                    PsiClassInitializer classInitializer = (PsiClassInitializer)child;
                    if (!classInitializer.hasModifierProperty("static")) continue;
                    classInitializer.accept(visitor2);
                } else if (child instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)child;
                    if (method.isConstructor()) continue;
                    method.accept(visitor2);
                } else if (child instanceof PsiClass) {
                    child.accept(visitor2);
                }
                if (!visitor2.isAssigned()) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/FinalUtils", "canBeFinal"));
    }

    private static class FinalDefiniteAssignment
    extends DefiniteAssignment {
        private boolean canBeFinal = true;

        public FinalDefiniteAssignment(PsiVariable variable2) {
            super(variable2);
        }

        @Override
        public void assign(@NotNull PsiReferenceExpression expression2, boolean definiteAssignment) {
            if (expression2 == null) {
                FinalDefiniteAssignment.$$$reportNull$$$0(0);
            }
            if (!this.isDefinitelyUnassigned()) {
                this.canBeFinal = false;
            }
            super.assign(expression2, definiteAssignment);
        }

        @Override
        public void valueAccess(PsiReferenceExpression expression2) {
            if (!this.isDefinitelyAssigned()) {
                this.canBeFinal = false;
            }
            super.valueAccess(expression2);
        }

        @Override
        public boolean stop() {
            return !this.canBeFinal;
        }

        public boolean canBeFinal() {
            return this.canBeFinal;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/FinalUtils$FinalDefiniteAssignment", "assign"));
        }
    }
}

