/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class StatementExtractor {
    private static final Node EMPTY = new Node(null){

        @Override
        public Node prepend(Node node) {
            return node;
        }

        @Override
        public String toString() {
            return "";
        }
    };

    @NotNull
    public static PsiStatement[] generateStatements(List<PsiExpression> expressionsToKeep, PsiExpression root2) {
        String statementsCode = StatementExtractor.generateStatementsText(expressionsToKeep, root2);
        if (statementsCode.isEmpty()) {
            if (PsiStatement.EMPTY_ARRAY == null) {
                StatementExtractor.$$$reportNull$$$0(0);
            }
            return PsiStatement.EMPTY_ARRAY;
        }
        PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(root2.getProject());
        PsiCodeBlock codeBlock = factory2.createCodeBlockFromText("{" + statementsCode + "}", root2);
        PsiStatement[] psiStatementArray = codeBlock.getStatements();
        if (psiStatementArray == null) {
            StatementExtractor.$$$reportNull$$$0(1);
        }
        return psiStatementArray;
    }

    public static String generateStatementsText(List<PsiExpression> expressionsToKeep, PsiExpression root2) {
        Node result2 = (Node)StreamEx.ofReversed(expressionsToKeep).map(expression2 -> StatementExtractor.createNode(expression2, root2)).foldLeft(EMPTY, Node::prepend);
        return result2.toString();
    }

    @NotNull
    private static Node createNode(@NotNull PsiExpression expression2, @NotNull PsiExpression root2) {
        if (expression2 == null) {
            StatementExtractor.$$$reportNull$$$0(2);
        }
        if (root2 == null) {
            StatementExtractor.$$$reportNull$$$0(3);
        }
        Node result2 = new Expr(expression2);
        while (expression2 != root2) {
            PsiExpression parent2;
            PsiElement parentElement = expression2.getParent();
            if (parentElement instanceof PsiExpressionList) {
                parentElement = parentElement.getParent();
            }
            if ((parent2 = ObjectUtils.tryCast(parentElement, PsiExpression.class)) == null) {
                String message = PsiTreeUtil.isAncestor(root2, expression2, false) ? "Expected to have expression parent" : "Supplied root is not the expression ancestor";
                throw new RuntimeExceptionWithAttachments(message, new Attachment("expression.txt", expression2.getText()), new Attachment("root.txt", root2.getText()));
            }
            result2 = StatementExtractor.foldNode(result2, expression2, parent2);
            expression2 = parent2;
        }
        Expr expr = result2;
        if (expr == null) {
            StatementExtractor.$$$reportNull$$$0(4);
        }
        return expr;
    }

    @NotNull
    private static Node foldNode(@NotNull Node node, @NotNull PsiExpression expression2, @NotNull PsiExpression parent2) {
        if (node == null) {
            StatementExtractor.$$$reportNull$$$0(5);
        }
        if (expression2 == null) {
            StatementExtractor.$$$reportNull$$$0(6);
        }
        if (parent2 == null) {
            StatementExtractor.$$$reportNull$$$0(7);
        }
        if (parent2 instanceof PsiPolyadicExpression) {
            boolean and;
            PsiPolyadicExpression polyadic = (PsiPolyadicExpression)parent2;
            IElementType type2 = polyadic.getOperationTokenType();
            if (type2 == JavaTokenType.ANDAND) {
                and = true;
            } else if (type2 == JavaTokenType.OROR) {
                and = false;
            } else {
                Node node2 = node;
                if (node2 == null) {
                    StatementExtractor.$$$reportNull$$$0(8);
                }
                return node2;
            }
            Object[] operands = polyadic.getOperands();
            int index2 = ArrayUtil.indexOf(operands, expression2);
            if (index2 == 0) {
                Node node3 = node;
                if (node3 == null) {
                    StatementExtractor.$$$reportNull$$$0(9);
                }
                return node3;
            }
            Cond cond = new Cond(parent2, parent2, index2, and ? node : EMPTY, and ? EMPTY : node);
            if (cond == null) {
                StatementExtractor.$$$reportNull$$$0(10);
            }
            return cond;
        }
        if (parent2 instanceof PsiConditionalExpression) {
            PsiConditionalExpression ternary = (PsiConditionalExpression)parent2;
            if (expression2 == ternary.getThenExpression()) {
                Cond cond = new Cond(ternary, ternary.getCondition(), -1, node, EMPTY);
                if (cond == null) {
                    StatementExtractor.$$$reportNull$$$0(11);
                }
                return cond;
            }
            if (expression2 == ternary.getElseExpression()) {
                Cond cond = new Cond(ternary, ternary.getCondition(), -1, EMPTY, node);
                if (cond == null) {
                    StatementExtractor.$$$reportNull$$$0(12);
                }
                return cond;
            }
        }
        Node node4 = node;
        if (node4 == null) {
            StatementExtractor.$$$reportNull$$$0(13);
        }
        return node4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/StatementExtractor";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "generateStatements";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/StatementExtractor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createNode";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "foldNode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNode";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "foldNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Cons
    extends Node {
        @NotNull
        private final Node myHead;
        @NotNull
        private final Node myTail;

        private Cons(@NotNull Node head2, @NotNull Node tail) {
            if (head2 == null) {
                Cons.$$$reportNull$$$0(0);
            }
            if (tail == null) {
                Cons.$$$reportNull$$$0(1);
            }
            super(head2.myAnchor);
            assert (!(head2 instanceof Cons));
            this.myHead = head2;
            this.myTail = tail;
        }

        @Override
        public Node prepend(Node node) {
            if (node.myAnchor == null) {
                return this;
            }
            if (PsiTreeUtil.isAncestor(this.myHead.myAnchor, node.myAnchor, false)) {
                Node newHead = this.myHead.prepend(node);
                return new Cons(newHead, this.myTail);
            }
            return new Cons(node, this);
        }

        @Override
        public String toString() {
            return this.myHead.toString() + this.myTail;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "head";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tail";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ig/psiutils/StatementExtractor$Cons";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Expr
    extends Node {
        private Expr(@NotNull PsiExpression expression2) {
            if (expression2 == null) {
                Expr.$$$reportNull$$$0(0);
            }
            super(expression2);
        }

        @Override
        public Node prepend(Node node) {
            return node.myAnchor == null ? this : new Cons(node, this);
        }

        @Override
        public String toString() {
            return this.myAnchor.getText() + ";";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/StatementExtractor$Expr", "<init>"));
        }
    }

    private static class Cond
    extends Node {
        @NotNull
        private final PsiExpression myCondition;
        @NotNull
        private final Node myThenBranch;
        @NotNull
        private final Node myElseBranch;
        private final int myLimit;

        private Cond(@NotNull PsiExpression anchor2, @NotNull PsiExpression condition, int limit, @NotNull Node thenBranch, @NotNull Node elseBranch) {
            if (anchor2 == null) {
                Cond.$$$reportNull$$$0(0);
            }
            if (condition == null) {
                Cond.$$$reportNull$$$0(1);
            }
            if (thenBranch == null) {
                Cond.$$$reportNull$$$0(2);
            }
            if (elseBranch == null) {
                Cond.$$$reportNull$$$0(3);
            }
            super(anchor2);
            this.myCondition = condition;
            this.myLimit = limit;
            assert (limit < 0 || condition instanceof PsiPolyadicExpression);
            this.myThenBranch = thenBranch;
            this.myElseBranch = elseBranch;
        }

        private String getCondition(boolean invert) {
            if (this.myLimit < 0) {
                return invert ? BoolUtils.getNegatedExpressionText(this.myCondition) : this.myCondition.getText();
            }
            PsiPolyadicExpression condition = (PsiPolyadicExpression)this.myCondition;
            Object[] operands = condition.getOperands();
            String joiner = condition.getOperationTokenType() == JavaTokenType.ANDAND != invert ? "&&" : "||";
            return StreamEx.of((Object[])operands, (int)0, (int)this.myLimit).map(invert ? BoolUtils::getNegatedExpressionText : PsiElement::getText).joining(joiner);
        }

        @Override
        public String toString() {
            if (this.myThenBranch == EMPTY) {
                return "if(" + this.getCondition(true) + ") {" + this.myElseBranch + "}";
            }
            return "if(" + this.getCondition(false) + ") {" + this.myThenBranch + "}" + (this.myElseBranch == EMPTY ? "" : "else {" + this.myElseBranch + "}");
        }

        @Override
        public Node prepend(Node node) {
            PsiExpression thatAnchor = node.myAnchor;
            if (thatAnchor == null) {
                return this;
            }
            if (thatAnchor == this.myAnchor) {
                assert (node instanceof Cond);
                Cond cond = (Cond)node;
                assert (this.myCondition == cond.myCondition);
                if (this.myLimit == cond.myLimit) {
                    return new Cond(this.myAnchor, this.myCondition, this.myLimit, this.myThenBranch.prepend(cond.myThenBranch), this.myElseBranch.prepend(cond.myElseBranch));
                }
                assert (this.myLimit > cond.myLimit);
                return this;
            }
            if (PsiTreeUtil.isAncestor(this.myCondition, thatAnchor, false)) {
                return this;
            }
            return new Cons(node, this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anchor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "condition";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "thenBranch";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "elseBranch";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ig/psiutils/StatementExtractor$Cond";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class Node {
        final PsiExpression myAnchor;

        protected Node(PsiExpression anchor2) {
            this.myAnchor = anchor2;
        }

        public abstract Node prepend(Node var1);

        public abstract String toString();
    }
}

