/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.Contract;

public class StreamApiUtil {
    @Contract(value="null -> null")
    public static PsiType getStreamElementType(PsiType type2) {
        return StreamApiUtil.getStreamElementType(type2, true);
    }

    @Contract(value="null, _ -> null")
    public static PsiType getStreamElementType(PsiType type2, boolean variableType) {
        if (!(type2 instanceof PsiClassType)) {
            return null;
        }
        PsiClass aClass2 = ((PsiClassType)type2).resolve();
        if (InheritanceUtil.isInheritor(aClass2, false, "java.util.stream.IntStream")) {
            return PsiType.INT;
        }
        if (InheritanceUtil.isInheritor(aClass2, false, "java.util.stream.LongStream")) {
            return PsiType.LONG;
        }
        if (InheritanceUtil.isInheritor(aClass2, false, "java.util.stream.DoubleStream")) {
            return PsiType.DOUBLE;
        }
        if (!InheritanceUtil.isInheritor(aClass2, false, "java.util.stream.Stream")) {
            return null;
        }
        PsiType streamType = PsiUtil.substituteTypeParameter(type2, "java.util.stream.Stream", 0, false);
        if (variableType) {
            if (streamType instanceof PsiIntersectionType) {
                return null;
            }
            streamType = GenericsUtil.getVariableTypeByExpressionType(streamType);
        }
        return streamType;
    }

    public static boolean isNullOrEmptyStream(PsiExpression expression2) {
        if (ExpressionUtils.isNullLiteral(expression2)) {
            return true;
        }
        if (!(expression2 instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call2 = (PsiMethodCallExpression)expression2;
        String name = call2.getMethodExpression().getReferenceName();
        if (!"empty".equals(name) && !"of".equals(name) || call2.getArgumentList().getExpressions().length != 0) {
            return false;
        }
        PsiMethod method = call2.resolveMethod();
        if (method == null || !method.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass2 = method.getContainingClass();
        if (aClass2 == null) {
            return false;
        }
        String qualifiedName2 = aClass2.getQualifiedName();
        return qualifiedName2 != null && qualifiedName2.startsWith("java.util.stream.");
    }

    @Contract(value="null -> false")
    public static boolean isSupportedStreamElement(PsiType type2) {
        if (type2 == null) {
            return false;
        }
        if (type2 instanceof PsiPrimitiveType) {
            return type2.equals(PsiType.INT) || type2.equals(PsiType.LONG) || type2.equals(PsiType.DOUBLE);
        }
        return true;
    }
}

