/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeUtils {
    private static final Map<PsiType, Integer> typePrecisions = new HashMap<PsiType, Integer>(7);

    private TypeUtils() {
    }

    @Contract(value="_, null -> false")
    public static boolean typeEquals(@NonNls @NotNull String typeName, @Nullable PsiType targetType) {
        if (typeName == null) {
            TypeUtils.$$$reportNull$$$0(0);
        }
        return targetType != null && targetType.equalsToText(typeName);
    }

    public static PsiClassType getType(@NotNull String fqName2, @NotNull PsiElement context) {
        if (fqName2 == null) {
            TypeUtils.$$$reportNull$$$0(1);
        }
        if (context == null) {
            TypeUtils.$$$reportNull$$$0(2);
        }
        Project project = context.getProject();
        PsiElementFactory factory2 = JavaPsiFacade.getInstance(project).getElementFactory();
        GlobalSearchScope scope = context.getResolveScope();
        return factory2.createTypeByFQClassName(fqName2, scope);
    }

    public static PsiClassType getType(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            TypeUtils.$$$reportNull$$$0(3);
        }
        return JavaPsiFacade.getElementFactory(aClass2.getProject()).createType(aClass2);
    }

    public static PsiClassType getObjectType(@NotNull PsiElement context) {
        if (context == null) {
            TypeUtils.$$$reportNull$$$0(4);
        }
        return TypeUtils.getType("java.lang.Object", context);
    }

    public static PsiClassType getStringType(@NotNull PsiElement context) {
        if (context == null) {
            TypeUtils.$$$reportNull$$$0(5);
        }
        return TypeUtils.getType("java.lang.String", context);
    }

    public static boolean isNarrowingConversion(@Nullable PsiType sourceType, @Nullable PsiType targetType) {
        Integer sourcePrecision = typePrecisions.get(sourceType);
        Integer targetPrecision = typePrecisions.get(targetType);
        return sourcePrecision != null && targetPrecision != null && targetPrecision < sourcePrecision;
    }

    @Contract(value="null -> false")
    public static boolean isJavaLangObject(@Nullable PsiType targetType) {
        return TypeUtils.typeEquals("java.lang.Object", targetType);
    }

    @Contract(value="null -> false")
    public static boolean isJavaLangString(@Nullable PsiType targetType) {
        return TypeUtils.typeEquals("java.lang.String", targetType);
    }

    public static boolean isOptional(@Nullable PsiType type2) {
        return TypeUtils.isOptional(PsiUtil.resolveClassInClassTypeOnly(type2));
    }

    @Contract(value="null -> false")
    public static boolean isOptional(PsiClass aClass2) {
        if (aClass2 == null) {
            return false;
        }
        String qualifiedName2 = aClass2.getQualifiedName();
        return "java.util.Optional".equals(qualifiedName2) || "java.util.OptionalDouble".equals(qualifiedName2) || "java.util.OptionalInt".equals(qualifiedName2) || "java.util.OptionalLong".equals(qualifiedName2) || "com.google.common.base.Optional".equals(qualifiedName2);
    }

    public static boolean isExpressionTypeAssignableWith(@NotNull PsiExpression expression2, @NotNull Iterable<String> rhsTypeTexts) {
        PsiType type2;
        if (expression2 == null) {
            TypeUtils.$$$reportNull$$$0(6);
        }
        if (rhsTypeTexts == null) {
            TypeUtils.$$$reportNull$$$0(7);
        }
        if ((type2 = expression2.getType()) == null) {
            return false;
        }
        PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(expression2.getProject());
        for (String rhsTypeText : rhsTypeTexts) {
            PsiClassType rhsType = factory2.createTypeByFQClassName(rhsTypeText, expression2.getResolveScope());
            if (!type2.isAssignableFrom(rhsType)) continue;
            return true;
        }
        return false;
    }

    @Contract(value="null, _ -> false")
    public static boolean expressionHasTypeOrSubtype(@Nullable PsiExpression expression2, @NonNls @NotNull String typeName) {
        if (typeName == null) {
            TypeUtils.$$$reportNull$$$0(8);
        }
        return TypeUtils.expressionHasTypeOrSubtype(expression2, new String[]{typeName}) != null;
    }

    public static String expressionHasTypeOrSubtype(@Nullable PsiExpression expression2, String ... typeNames) {
        PsiType type2;
        if (typeNames == null) {
            TypeUtils.$$$reportNull$$$0(9);
        }
        if (expression2 == null) {
            return null;
        }
        PsiType psiType = type2 = expression2 instanceof PsiFunctionalExpression ? ((PsiFunctionalExpression)expression2).getFunctionalInterfaceType() : expression2.getType();
        if (type2 == null) {
            return null;
        }
        PsiClass aClass2 = PsiUtil.resolveClassInClassTypeOnly(type2);
        if (aClass2 == null) {
            return null;
        }
        for (String typeName : typeNames) {
            if (!InheritanceUtil.isInheritor(aClass2, typeName)) continue;
            return typeName;
        }
        return null;
    }

    public static boolean expressionHasTypeOrSubtype(@Nullable PsiExpression expression2, @NonNls @NotNull Iterable<String> typeNames) {
        if (typeNames == null) {
            TypeUtils.$$$reportNull$$$0(10);
        }
        if (expression2 == null) {
            return false;
        }
        PsiClass aClass2 = PsiUtil.resolveClassInClassTypeOnly(expression2.getType());
        if (aClass2 == null) {
            return false;
        }
        for (String typeName : typeNames) {
            if (!InheritanceUtil.isInheritor(aClass2, typeName)) continue;
            return true;
        }
        return false;
    }

    public static boolean variableHasTypeOrSubtype(@Nullable PsiVariable variable2, String ... typeNames) {
        if (typeNames == null) {
            TypeUtils.$$$reportNull$$$0(11);
        }
        if (variable2 == null) {
            return false;
        }
        PsiClass aClass2 = PsiUtil.resolveClassInClassTypeOnly(variable2.getType());
        if (aClass2 == null) {
            return false;
        }
        for (String typeName : typeNames) {
            if (!InheritanceUtil.isInheritor(aClass2, typeName)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasFloatingPointType(@Nullable PsiExpression expression2) {
        if (expression2 == null) {
            return false;
        }
        PsiType type2 = expression2.getType();
        return type2 != null && (PsiType.FLOAT.equals(type2) || PsiType.DOUBLE.equals(type2));
    }

    public static boolean areConvertible(PsiType type1, PsiType type2) {
        if (TypeConversionUtil.areTypesConvertible(type1, type2)) {
            return true;
        }
        PsiType comparedTypeErasure = TypeConversionUtil.erasure(type1);
        PsiType comparisonTypeErasure = TypeConversionUtil.erasure(type2);
        if (comparedTypeErasure == null || comparisonTypeErasure == null || TypeConversionUtil.areTypesConvertible(comparedTypeErasure, comparisonTypeErasure)) {
            if (type1 instanceof PsiClassType && type2 instanceof PsiClassType) {
                PsiType[] parameters2;
                PsiClassType classType1 = (PsiClassType)type1;
                PsiClassType classType2 = (PsiClassType)type2;
                PsiType[] parameters1 = classType1.getParameters();
                if (parameters1.length != (parameters2 = classType2.getParameters()).length) {
                    return ((PsiClassType)type1).isRaw() || ((PsiClassType)type2).isRaw();
                }
                for (int i2 = 0; i2 < parameters1.length; ++i2) {
                    if (TypeUtils.areConvertible(parameters1[i2], parameters2[i2])) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean isTypeParameter(PsiType type2) {
        PsiClass aClass2 = PsiUtil.resolveClassInClassTypeOnly(type2);
        return aClass2 instanceof PsiTypeParameter;
    }

    public static PsiType unaryNumericPromotion(PsiType type2) {
        if (type2 == null) {
            return null;
        }
        if (type2.equalsToText("java.lang.Byte") || type2.equalsToText("java.lang.Short") || type2.equalsToText("java.lang.Character") || type2.equalsToText("java.lang.Integer") || type2.equals(PsiType.BYTE) || type2.equals(PsiType.SHORT) || type2.equals(PsiType.CHAR)) {
            return PsiType.INT;
        }
        if (type2.equalsToText("java.lang.Long")) {
            return PsiType.LONG;
        }
        if (type2.equalsToText("java.lang.Float")) {
            return PsiType.FLOAT;
        }
        if (type2.equalsToText("java.lang.Double")) {
            return PsiType.DOUBLE;
        }
        return type2;
    }

    @Contract(value="null -> null")
    public static String resolvedClassName(PsiType type2) {
        PsiClass aClass2 = PsiUtil.resolveClassInClassTypeOnly(type2);
        return aClass2 == null ? null : aClass2.getQualifiedName();
    }

    static {
        typePrecisions.put(PsiType.BYTE, 1);
        typePrecisions.put(PsiType.CHAR, 2);
        typePrecisions.put(PsiType.SHORT, 2);
        typePrecisions.put(PsiType.INT, 3);
        typePrecisions.put(PsiType.LONG, 4);
        typePrecisions.put(PsiType.FLOAT, 5);
        typePrecisions.put(PsiType.DOUBLE, 6);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rhsTypeTexts";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeNames";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/TypeUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "typeEquals";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getObjectType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getStringType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isExpressionTypeAssignableWith";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "expressionHasTypeOrSubtype";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "variableHasTypeOrSubtype";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

