/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class UtilityClassUtil {
    private UtilityClassUtil() {
    }

    public static boolean hasPrivateEmptyOrNoConstructor(@NotNull PsiClass aClass2) {
        PsiMethod[] constructors2;
        if (aClass2 == null) {
            UtilityClassUtil.$$$reportNull$$$0(0);
        }
        if ((constructors2 = aClass2.getConstructors()).length == 0) {
            return true;
        }
        if (constructors2.length != 1) {
            return false;
        }
        PsiMethod constructor = constructors2[0];
        return constructor.hasModifierProperty("private") && ControlFlowUtils.isEmptyCodeBlock(constructor.getBody());
    }

    public static boolean isUtilityClass(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            UtilityClassUtil.$$$reportNull$$$0(1);
        }
        return UtilityClassUtil.isUtilityClass(aClass2, true);
    }

    public static boolean isUtilityClass(@NotNull PsiClass aClass2, boolean fullCheck) {
        if (aClass2 == null) {
            UtilityClassUtil.$$$reportNull$$$0(2);
        }
        if (aClass2.isInterface() || aClass2.isEnum() || aClass2.isAnnotationType()) {
            return false;
        }
        if (aClass2 instanceof PsiTypeParameter || aClass2 instanceof PsiAnonymousClass) {
            return false;
        }
        PsiReferenceList extendsList = aClass2.getExtendsList();
        if (fullCheck && extendsList != null && extendsList.getReferenceElements().length > 0) {
            return false;
        }
        PsiReferenceList implementsList = aClass2.getImplementsList();
        if (implementsList != null && implementsList.getReferenceElements().length > 0) {
            return false;
        }
        PsiMethod[] methods2 = aClass2.getMethods();
        int staticMethodCount = UtilityClassUtil.countStaticMethods(methods2);
        if (staticMethodCount < 0) {
            return false;
        }
        PsiField[] fields2 = aClass2.getFields();
        if (!UtilityClassUtil.allFieldsStatic(fields2)) {
            return false;
        }
        return !fullCheck || staticMethodCount != 0 || fields2.length != 0;
    }

    private static boolean allFieldsStatic(PsiField[] fields2) {
        for (PsiField field : fields2) {
            if (field.hasModifierProperty("static")) continue;
            return false;
        }
        return true;
    }

    private static int countStaticMethods(PsiMethod[] methods2) {
        int staticCount = 0;
        for (PsiMethod method : methods2) {
            if (method.isConstructor()) continue;
            if (!method.hasModifierProperty("static")) {
                return -1;
            }
            if (method.hasModifierProperty("private")) continue;
            ++staticCount;
        }
        return staticCount;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "aClass";
        objectArray2[1] = "com/siyeh/ig/psiutils/UtilityClassUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hasPrivateEmptyOrNoConstructor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isUtilityClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

