/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.siyeh.ig.psiutils.ArrayContentsAssignedVisitor;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAssignedFromVisitor;
import com.siyeh.ig.psiutils.VariableAssignedVisitor;
import com.siyeh.ig.psiutils.VariablePassedAsArgumentExcludedVisitor;
import com.siyeh.ig.psiutils.VariablePassedAsArgumentVisitor;
import com.siyeh.ig.psiutils.VariableReturnedVisitor;
import com.siyeh.ig.psiutils.VariableUsedInArrayInitializerVisitor;
import com.siyeh.ig.psiutils.VariableUsedInInnerClassVisitor;
import com.siyeh.ig.psiutils.VariableUsedVisitor;
import com.siyeh.ig.psiutils.VariableValueUsedVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableAccessUtils {
    private VariableAccessUtils() {
    }

    public static boolean variableIsAssignedFrom(@NotNull PsiVariable variable2, @Nullable PsiElement context) {
        if (variable2 == null) {
            VariableAccessUtils.$$$reportNull$$$0(0);
        }
        if (context == null) {
            return false;
        }
        VariableAssignedFromVisitor visitor2 = new VariableAssignedFromVisitor(variable2);
        context.accept(visitor2);
        return visitor2.isAssignedFrom();
    }

    public static boolean variableIsPassedAsMethodArgument(@NotNull PsiVariable variable2, @Nullable PsiElement context) {
        if (variable2 == null) {
            VariableAccessUtils.$$$reportNull$$$0(1);
        }
        if (context == null) {
            return false;
        }
        VariablePassedAsArgumentVisitor visitor2 = new VariablePassedAsArgumentVisitor(variable2);
        context.accept(visitor2);
        return visitor2.isPassed();
    }

    public static boolean variableIsPassedAsMethodArgument(@NotNull PsiVariable variable2, @Nullable PsiElement context, Processor<PsiCall> callProcessor) {
        if (variable2 == null) {
            VariableAccessUtils.$$$reportNull$$$0(2);
        }
        return VariableAccessUtils.variableIsPassedAsMethodArgument(variable2, context, false, callProcessor);
    }

    public static boolean variableIsPassedAsMethodArgument(@NotNull PsiVariable variable2, @Nullable PsiElement context, boolean builderPattern, Processor<PsiCall> callProcessor) {
        if (variable2 == null) {
            VariableAccessUtils.$$$reportNull$$$0(3);
        }
        if (context == null) {
            return false;
        }
        VariablePassedAsArgumentExcludedVisitor visitor2 = new VariablePassedAsArgumentExcludedVisitor(variable2, builderPattern, callProcessor);
        context.accept(visitor2);
        return visitor2.isPassed();
    }

    public static boolean variableIsUsedInArrayInitializer(@NotNull PsiVariable variable2, @Nullable PsiElement context) {
        if (variable2 == null) {
            VariableAccessUtils.$$$reportNull$$$0(4);
        }
        if (context == null) {
            return false;
        }
        VariableUsedInArrayInitializerVisitor visitor2 = new VariableUsedInArrayInitializerVisitor(variable2);
        context.accept(visitor2);
        return visitor2.isPassed();
    }

    public static boolean variableIsAssigned(@NotNull PsiVariable variable2) {
        if (variable2 == null) {
            VariableAccessUtils.$$$reportNull$$$0(5);
        }
        if (variable2 instanceof PsiField) {
            if (variable2.hasModifierProperty("private")) {
                PsiClass aClass2 = PsiUtil.getTopLevelClass(variable2);
                return VariableAccessUtils.variableIsAssigned(variable2, aClass2);
            }
            return DeclarationSearchUtils.isTooExpensiveToSearch(variable2, false) || !ReferencesSearch.search(variable2).forEach(reference -> {
                PsiElement element = reference.getElement();
                if (!(element instanceof PsiExpression)) {
                    return true;
                }
                PsiExpression expression2 = (PsiExpression)element;
                return !PsiUtil.isAccessedForWriting(expression2);
            });
        }
        Object context = PsiTreeUtil.getParentOfType((PsiElement)variable2, PsiCodeBlock.class, PsiMethod.class, PsiLambdaExpression.class, PsiCatchSection.class, PsiForStatement.class, PsiForeachStatement.class);
        return VariableAccessUtils.variableIsAssigned(variable2, context);
    }

    public static boolean variableIsAssigned(@NotNull PsiVariable variable2, @Nullable PsiElement context) {
        if (variable2 == null) {
            VariableAccessUtils.$$$reportNull$$$0(6);
        }
        if (context == null) {
            return false;
        }
        VariableAssignedVisitor visitor2 = new VariableAssignedVisitor(variable2, true);
        context.accept(visitor2);
        return visitor2.isAssigned();
    }

    public static boolean variableIsAssigned(@NotNull PsiVariable variable2, @Nullable PsiElement context, boolean recurseIntoClasses) {
        if (variable2 == null) {
            VariableAccessUtils.$$$reportNull$$$0(7);
        }
        if (context == null) {
            return false;
        }
        VariableAssignedVisitor visitor2 = new VariableAssignedVisitor(variable2, recurseIntoClasses);
        context.accept(visitor2);
        return visitor2.isAssigned();
    }

    public static boolean variableIsReturned(@NotNull PsiVariable variable2, @Nullable PsiElement context) {
        if (variable2 == null) {
            VariableAccessUtils.$$$reportNull$$$0(8);
        }
        return VariableAccessUtils.variableIsReturned(variable2, context, false);
    }

    public static boolean variableIsReturned(@NotNull PsiVariable variable2, @Nullable PsiElement context, boolean builderPattern) {
        if (variable2 == null) {
            VariableAccessUtils.$$$reportNull$$$0(9);
        }
        if (context == null) {
            return false;
        }
        VariableReturnedVisitor visitor2 = new VariableReturnedVisitor(variable2, builderPattern);
        context.accept(visitor2);
        return visitor2.isReturned();
    }

    public static boolean variableValueIsUsed(@NotNull PsiVariable variable2, @Nullable PsiElement context) {
        if (variable2 == null) {
            VariableAccessUtils.$$$reportNull$$$0(10);
        }
        if (context == null) {
            return false;
        }
        VariableValueUsedVisitor visitor2 = new VariableValueUsedVisitor(variable2);
        context.accept(visitor2);
        return visitor2.isVariableValueUsed();
    }

    public static boolean arrayContentsAreAssigned(@NotNull PsiVariable variable2, @Nullable PsiElement context) {
        if (variable2 == null) {
            VariableAccessUtils.$$$reportNull$$$0(11);
        }
        if (context == null) {
            return false;
        }
        ArrayContentsAssignedVisitor visitor2 = new ArrayContentsAssignedVisitor(variable2);
        context.accept(visitor2);
        return visitor2.isAssigned();
    }

    public static boolean variableIsUsedInInnerClass(@NotNull PsiVariable variable2, @Nullable PsiElement context) {
        if (variable2 == null) {
            VariableAccessUtils.$$$reportNull$$$0(12);
        }
        if (context == null) {
            return false;
        }
        VariableUsedInInnerClassVisitor visitor2 = new VariableUsedInInnerClassVisitor(variable2);
        context.accept(visitor2);
        return visitor2.isUsedInInnerClass();
    }

    public static boolean mayEvaluateToVariable(@Nullable PsiExpression expression2, @NotNull PsiVariable variable2) {
        if (variable2 == null) {
            VariableAccessUtils.$$$reportNull$$$0(13);
        }
        return VariableAccessUtils.mayEvaluateToVariable(expression2, variable2, false);
    }

    static boolean mayEvaluateToVariable(@Nullable PsiExpression expression2, @NotNull PsiVariable variable2, boolean builderPattern) {
        if (variable2 == null) {
            VariableAccessUtils.$$$reportNull$$$0(14);
        }
        if (expression2 == null) {
            return false;
        }
        if (expression2 instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
            PsiExpression containedExpression = parenthesizedExpression.getExpression();
            return VariableAccessUtils.mayEvaluateToVariable(containedExpression, variable2, builderPattern);
        }
        if (expression2 instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression2;
            PsiExpression containedExpression = typeCastExpression.getOperand();
            return VariableAccessUtils.mayEvaluateToVariable(containedExpression, variable2, builderPattern);
        }
        if (expression2 instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditional = (PsiConditionalExpression)expression2;
            PsiExpression thenExpression = conditional.getThenExpression();
            PsiExpression elseExpression = conditional.getElseExpression();
            return VariableAccessUtils.mayEvaluateToVariable(thenExpression, variable2, builderPattern) || VariableAccessUtils.mayEvaluateToVariable(elseExpression, variable2, builderPattern);
        }
        if (expression2 instanceof PsiArrayAccessExpression) {
            PsiElement parent2 = expression2.getParent();
            if (parent2 instanceof PsiArrayAccessExpression) {
                return false;
            }
            PsiType type2 = variable2.getType();
            if (!(type2 instanceof PsiArrayType)) {
                return false;
            }
            PsiArrayType arrayType = (PsiArrayType)type2;
            int dimensions = arrayType.getArrayDimensions();
            if (dimensions <= 1) {
                return false;
            }
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)expression2;
            PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            int count2 = 1;
            while (arrayExpression instanceof PsiArrayAccessExpression) {
                arrayAccessExpression = (PsiArrayAccessExpression)arrayExpression;
                arrayExpression = arrayAccessExpression.getArrayExpression();
                ++count2;
            }
            return count2 != dimensions && VariableAccessUtils.mayEvaluateToVariable(arrayExpression, variable2, builderPattern);
        }
        if (builderPattern && expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiType returnType = method.getReturnType();
            PsiType variableType = variable2.getType();
            if (!variableType.equals(returnType)) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            return VariableAccessUtils.mayEvaluateToVariable(qualifier, variable2, true);
        }
        return VariableAccessUtils.evaluatesToVariable(expression2, variable2);
    }

    public static boolean evaluatesToVariable(@Nullable PsiExpression expression2, @NotNull PsiVariable variable2) {
        if (variable2 == null) {
            VariableAccessUtils.$$$reportNull$$$0(15);
        }
        if (!((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
        PsiElement target = referenceExpression.resolve();
        return variable2.equals(target);
    }

    @Contract(value="_, null -> false")
    public static boolean variableIsUsed(@NotNull PsiVariable variable2, @Nullable PsiElement context) {
        if (variable2 == null) {
            VariableAccessUtils.$$$reportNull$$$0(16);
        }
        return context != null && VariableUsedVisitor.isVariableUsedIn(variable2, context);
    }

    public static boolean variableIsDecremented(@NotNull PsiVariable variable2, @Nullable PsiStatement statement2) {
        if (variable2 == null) {
            VariableAccessUtils.$$$reportNull$$$0(17);
        }
        return VariableAccessUtils.variableIsIncrementedOrDecremented(variable2, statement2, false);
    }

    public static boolean variableIsIncremented(@NotNull PsiVariable variable2, @Nullable PsiStatement statement2) {
        if (variable2 == null) {
            VariableAccessUtils.$$$reportNull$$$0(18);
        }
        return VariableAccessUtils.variableIsIncrementedOrDecremented(variable2, statement2, true);
    }

    private static boolean variableIsIncrementedOrDecremented(@NotNull PsiVariable variable2, @Nullable PsiStatement statement2, boolean incremented) {
        if (variable2 == null) {
            VariableAccessUtils.$$$reportNull$$$0(19);
        }
        if (!(statement2 instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement2;
        PsiExpression expression2 = expressionStatement.getExpression();
        if ((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiUnaryExpression) {
            PsiUnaryExpression unaryExpression = (PsiUnaryExpression)expression2;
            IElementType tokenType = unaryExpression.getOperationTokenType();
            if (!tokenType.equals(incremented ? JavaTokenType.PLUSPLUS : JavaTokenType.MINUSMINUS)) {
                return false;
            }
            PsiExpression operand = unaryExpression.getOperand();
            return VariableAccessUtils.evaluatesToVariable(operand, variable2);
        }
        if (expression2 instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2;
            IElementType tokenType = assignmentExpression.getOperationTokenType();
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (!VariableAccessUtils.evaluatesToVariable(lhs, variable2)) {
                return false;
            }
            PsiExpression rhs = assignmentExpression.getRExpression();
            rhs = ParenthesesUtils.stripParentheses(rhs);
            if (tokenType == JavaTokenType.EQ) {
                if (!(rhs instanceof PsiBinaryExpression)) {
                    return false;
                }
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)rhs;
                IElementType binaryTokenType = binaryExpression.getOperationTokenType();
                if (binaryTokenType != (incremented ? JavaTokenType.PLUS : JavaTokenType.MINUS)) {
                    return false;
                }
                PsiExpression lOperand = binaryExpression.getLOperand();
                PsiExpression rOperand = binaryExpression.getROperand();
                if (ExpressionUtils.isOne(lOperand) ? VariableAccessUtils.evaluatesToVariable(rOperand, variable2) : ExpressionUtils.isOne(rOperand) && VariableAccessUtils.evaluatesToVariable(lOperand, variable2)) {
                    return true;
                }
            } else if (tokenType == (incremented ? JavaTokenType.PLUSEQ : JavaTokenType.MINUSEQ) && ExpressionUtils.isOne(rhs)) {
                return true;
            }
        }
        return false;
    }

    public static boolean variableIsAssignedBeforeReference(@NotNull PsiReferenceExpression referenceExpression, @Nullable PsiElement context) {
        if (referenceExpression == null) {
            VariableAccessUtils.$$$reportNull$$$0(20);
        }
        if (context == null) {
            return false;
        }
        PsiElement target = referenceExpression.resolve();
        if (!(target instanceof PsiVariable)) {
            return false;
        }
        PsiVariable variable2 = (PsiVariable)target;
        return VariableAccessUtils.variableIsAssignedAtPoint(variable2, context, referenceExpression);
    }

    public static boolean variableIsAssignedAtPoint(@NotNull PsiVariable variable2, @Nullable PsiElement context, @NotNull PsiElement point) {
        PsiElement[] children2;
        if (variable2 == null) {
            VariableAccessUtils.$$$reportNull$$$0(21);
        }
        if (point == null) {
            VariableAccessUtils.$$$reportNull$$$0(22);
        }
        if (context == null) {
            return false;
        }
        PsiElement directChild = VariableAccessUtils.getDirectChildWhichContainsElement(context, point);
        if (directChild == null) {
            return false;
        }
        for (PsiElement child : children2 = context.getChildren()) {
            if (child == directChild) {
                return VariableAccessUtils.variableIsAssignedAtPoint(variable2, directChild, point);
            }
            if (!VariableAccessUtils.variableIsAssigned(variable2, child)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiElement getDirectChildWhichContainsElement(@NotNull PsiElement ancestor, @NotNull PsiElement descendant) {
        if (ancestor == null) {
            VariableAccessUtils.$$$reportNull$$$0(23);
        }
        if (descendant == null) {
            VariableAccessUtils.$$$reportNull$$$0(24);
        }
        if (ancestor == descendant) {
            return null;
        }
        PsiElement child = descendant;
        PsiElement parent2 = child.getParent();
        while (!parent2.equals(ancestor)) {
            child = parent2;
            if ((parent2 = child.getParent()) != null) continue;
            return null;
        }
        return child;
    }

    public static Set<PsiVariable> collectUsedVariables(PsiElement context) {
        if (context == null) {
            return Collections.emptySet();
        }
        VariableCollectingVisitor visitor2 = new VariableCollectingVisitor();
        context.accept(visitor2);
        return visitor2.getUsedVariables();
    }

    public static boolean isAnyVariableAssigned(@NotNull Collection<PsiVariable> variables, @Nullable PsiElement context) {
        if (variables == null) {
            VariableAccessUtils.$$$reportNull$$$0(25);
        }
        if (context == null) {
            return false;
        }
        VariableAssignedVisitor visitor2 = new VariableAssignedVisitor(variables, true);
        context.accept(visitor2);
        return visitor2.isAssigned();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descendant";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/VariableAccessUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "variableIsAssignedFrom";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "variableIsPassedAsMethodArgument";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "variableIsUsedInArrayInitializer";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "variableIsAssigned";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "variableIsReturned";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "variableValueIsUsed";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "arrayContentsAreAssigned";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "variableIsUsedInInnerClass";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "mayEvaluateToVariable";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluatesToVariable";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "variableIsUsed";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "variableIsDecremented";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "variableIsIncremented";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "variableIsIncrementedOrDecremented";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "variableIsAssignedBeforeReference";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "variableIsAssignedAtPoint";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "getDirectChildWhichContainsElement";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "isAnyVariableAssigned";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class VariableCollectingVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final Set<PsiVariable> usedVariables = new HashSet<PsiVariable>();

        private VariableCollectingVisitor() {
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            super.visitReferenceExpression(expression2);
            PsiElement target = expression2.resolve();
            if (!(target instanceof PsiVariable)) {
                return;
            }
            PsiVariable variable2 = (PsiVariable)target;
            this.usedVariables.add(variable2);
        }

        public Set<PsiVariable> getUsedVariables() {
            return this.usedVariables;
        }
    }
}

