/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.resources;

import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceInspection
extends BaseInspection {
    public boolean insideTryAllowed;
    public boolean anyMethodMayClose = true;

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            ResourceInspection.$$$reportNull$$$0(0);
        }
        this.defaultWriteSettings(node, "anyMethodMayClose");
        this.writeBooleanOption(node, "anyMethodMayClose", true);
    }

    @Override
    @NotNull
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel(this);
        panel.addCheckbox(InspectionGadgetsBundle.message("allow.resource.to.be.opened.inside.a.try.block", new Object[0]), "insideTryAllowed");
        panel.addCheckbox(InspectionGadgetsBundle.message("any.method.may.close.resource.argument", new Object[0]), "anyMethodMayClose");
        MultipleCheckboxOptionsPanel multipleCheckboxOptionsPanel = panel;
        if (multipleCheckboxOptionsPanel == null) {
            ResourceInspection.$$$reportNull$$$0(1);
        }
        return multipleCheckboxOptionsPanel;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        PsiExpression expression2 = (PsiExpression)infos2[0];
        PsiType type2 = expression2.getType();
        assert (type2 != null);
        String text2 = type2.getPresentableText();
        String string = InspectionGadgetsBundle.message("resource.opened.not.closed.problem.descriptor", text2);
        if (string == null) {
            ResourceInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ResourceVisitor();
    }

    protected abstract boolean isResourceCreation(PsiExpression var1);

    protected boolean isResourceFactoryClosed(PsiExpression expression2) {
        return false;
    }

    @Nullable
    public static PsiVariable getVariable(@NotNull PsiExpression expression2) {
        PsiElement parent2;
        if (expression2 == null) {
            ResourceInspection.$$$reportNull$$$0(3);
        }
        if ((parent2 = ResourceInspection.getParent(expression2)) instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent2;
            PsiExpression lhs = assignment.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement referent = referenceExpression.resolve();
            if (!(referent instanceof PsiVariable)) {
                return null;
            }
            return (PsiVariable)referent;
        }
        if (parent2 instanceof PsiVariable) {
            return (PsiVariable)parent2;
        }
        return null;
    }

    private static PsiElement getParent(PsiExpression expression2) {
        PsiElement parent2 = ParenthesesUtils.getParentSkipParentheses(expression2);
        if (parent2 == null) {
            return null;
        }
        PsiElement grandParent = parent2.getParent();
        PsiType type2 = expression2.getType();
        if (type2 == null) {
            return null;
        }
        while (parent2 instanceof PsiReferenceExpression && grandParent instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            if (!type2.equals(methodCallExpression.getType())) {
                return null;
            }
            parent2 = ParenthesesUtils.getParentSkipParentheses(grandParent);
            if (parent2 == null) {
                return null;
            }
            grandParent = parent2.getParent();
        }
        return parent2;
    }

    private boolean isSafelyClosed(@Nullable PsiVariable variable2, PsiElement context) {
        if (variable2 == null) {
            return false;
        }
        PsiStatement statement2 = PsiTreeUtil.getParentOfType(context, PsiStatement.class);
        if (statement2 == null) {
            return false;
        }
        PsiStatement nextStatement = PsiTreeUtil.getNextSiblingOfType(statement2, PsiStatement.class);
        if (this.insideTryAllowed) {
            PsiTryStatement tryStatement;
            PsiStatement parentStatement = PsiTreeUtil.getParentOfType((PsiElement)statement2, PsiStatement.class);
            while (parentStatement != null && !(parentStatement instanceof PsiTryStatement)) {
                parentStatement = PsiTreeUtil.getParentOfType((PsiElement)parentStatement, PsiStatement.class);
            }
            if (parentStatement != null && this.isResourceClosedInFinally(tryStatement = (PsiTryStatement)parentStatement, variable2)) {
                return true;
            }
        }
        while (nextStatement != null && !ResourceInspection.isSignificant(nextStatement)) {
            nextStatement = PsiTreeUtil.getNextSiblingOfType(nextStatement, PsiStatement.class);
        }
        while (nextStatement == null) {
            if ((statement2 = PsiTreeUtil.getParentOfType((PsiElement)statement2, PsiStatement.class, true)) == null) {
                return false;
            }
            PsiElement parent2 = statement2.getParent();
            if (parent2 instanceof PsiIfStatement) {
                statement2 = (PsiStatement)parent2;
            }
            nextStatement = PsiTreeUtil.getNextSiblingOfType(statement2, PsiStatement.class);
        }
        if (!(nextStatement instanceof PsiTryStatement)) {
            return this.isResourceClose(nextStatement, variable2);
        }
        PsiTryStatement tryStatement = (PsiTryStatement)nextStatement;
        if (this.isResourceClosedInFinally(tryStatement, variable2)) {
            return true;
        }
        return this.isResourceClose(nextStatement, variable2);
    }

    private static boolean isSignificant(@NotNull PsiStatement statement2) {
        if (statement2 == null) {
            ResourceInspection.$$$reportNull$$$0(4);
        }
        final Ref<Boolean> result2 = new Ref<Boolean>(Boolean.TRUE);
        statement2.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitExpression(PsiExpression expression2) {
                super.visitExpression(expression2);
                result2.set(Boolean.FALSE);
                this.stopWalking();
            }
        });
        return result2.get() == false;
    }

    boolean isResourceClosedInFinally(@NotNull PsiTryStatement tryStatement, @NotNull PsiVariable variable2) {
        PsiCodeBlock finallyBlock;
        if (tryStatement == null) {
            ResourceInspection.$$$reportNull$$$0(5);
        }
        if (variable2 == null) {
            ResourceInspection.$$$reportNull$$$0(6);
        }
        if ((finallyBlock = tryStatement.getFinallyBlock()) == null) {
            return false;
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (tryBlock == null) {
            return false;
        }
        CloseVisitor visitor2 = new CloseVisitor(variable2);
        finallyBlock.accept(visitor2);
        return visitor2.containsClose();
    }

    private boolean isResourceClose(PsiStatement statement2, PsiVariable variable2) {
        if (statement2 instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement2;
            PsiExpression expression2 = expressionStatement.getExpression();
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            return this.isResourceClose(methodCallExpression, variable2);
        }
        if (statement2 instanceof PsiTryStatement) {
            PsiTryStatement tryStatement = (PsiTryStatement)statement2;
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (this.isResourceClose(ControlFlowUtils.getFirstStatementInBlock(tryBlock), variable2)) {
                return true;
            }
        } else {
            if (statement2 instanceof PsiIfStatement) {
                PsiReferenceExpression referenceExpression;
                PsiIfStatement ifStatement = (PsiIfStatement)statement2;
                PsiExpression condition = ifStatement.getCondition();
                if (!(condition instanceof PsiBinaryExpression)) {
                    return false;
                }
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
                IElementType tokenType = binaryExpression.getOperationTokenType();
                if (JavaTokenType.NE != tokenType) {
                    return false;
                }
                PsiExpression lhs = binaryExpression.getLOperand();
                PsiExpression rhs = binaryExpression.getROperand();
                if (rhs == null) {
                    return false;
                }
                if (PsiType.NULL.equals(lhs.getType())) {
                    if (!(rhs instanceof PsiReferenceExpression)) {
                        return false;
                    }
                    referenceExpression = (PsiReferenceExpression)rhs;
                    PsiElement target = referenceExpression.resolve();
                    if (!variable2.equals(target)) {
                        return false;
                    }
                } else if (PsiType.NULL.equals(rhs.getType())) {
                    if (!(lhs instanceof PsiReferenceExpression)) {
                        return false;
                    }
                    referenceExpression = (PsiReferenceExpression)lhs;
                    PsiElement target = referenceExpression.resolve();
                    if (!variable2.equals(target)) {
                        return false;
                    }
                }
                PsiStatement thenBranch = ifStatement.getThenBranch();
                return this.isResourceClose(thenBranch, variable2);
            }
            if (statement2 instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)statement2;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                return this.isResourceClose(ControlFlowUtils.getFirstStatementInBlock(codeBlock), variable2);
            }
        }
        return false;
    }

    protected boolean isResourceClose(PsiMethodCallExpression call2, PsiVariable resource) {
        return MethodCallUtils.isMethodCallOnVariable(call2, resource, "close");
    }

    boolean isResourceEscapingFromMethod(PsiVariable boundVariable, PsiExpression resourceCreationExpression) {
        PsiClass containingClass;
        PsiField field;
        String fieldName;
        PsiReferenceExpression referenceExpression;
        PsiElement target;
        PsiMethodCallExpression methodCallExpression;
        PsiReferenceExpression methodExpression;
        PsiExpression qualifierExpression;
        if (resourceCreationExpression instanceof PsiMethodCallExpression && (qualifierExpression = (methodExpression = (methodCallExpression = (PsiMethodCallExpression)resourceCreationExpression).getMethodExpression()).getQualifierExpression()) instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)qualifierExpression).resolve()) instanceof PsiField && ("out".equals(fieldName = (field = (PsiField)target).getName()) || "err".equals(fieldName)) && (containingClass = field.getContainingClass()) != null && "java.lang.System".equals(containingClass.getQualifiedName())) {
            return true;
        }
        PsiElement parent2 = ParenthesesUtils.getParentSkipParentheses(resourceCreationExpression);
        if (parent2 instanceof PsiConditionalExpression) {
            parent2 = ParenthesesUtils.getParentSkipParentheses(parent2);
        }
        if (parent2 instanceof PsiReturnStatement) {
            return true;
        }
        if (parent2 instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent2;
            if (ParenthesesUtils.stripParentheses(assignmentExpression.getRExpression()) != resourceCreationExpression) {
                return true;
            }
            PsiExpression lhs = ParenthesesUtils.stripParentheses(assignmentExpression.getLExpression());
            if (lhs instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)lhs).resolve()) instanceof PsiField) {
                return true;
            }
        } else if (parent2 instanceof PsiExpressionList) {
            PsiElement grandParent = parent2.getParent();
            if (grandParent instanceof PsiAnonymousClass) {
                grandParent = grandParent.getParent();
            }
            if (grandParent instanceof PsiCallExpression) {
                return this.anyMethodMayClose || this.isResourceCreation((PsiExpression)grandParent);
            }
        }
        if (boundVariable == null) {
            return false;
        }
        PsiCodeBlock codeBlock = PsiTreeUtil.getParentOfType((PsiElement)resourceCreationExpression, PsiCodeBlock.class, true, PsiMember.class);
        if (codeBlock == null) {
            return false;
        }
        EscapeVisitor visitor2 = new EscapeVisitor(boundVariable);
        codeBlock.accept(visitor2);
        return visitor2.isEscaped();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/resources/ResourceInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tryStatement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/resources/ResourceInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVariable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSignificant";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isResourceClosedInFinally";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class EscapeVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiVariable boundVariable;
        private boolean escaped;

        public EscapeVisitor(PsiVariable boundVariable) {
            if (boundVariable == null) {
                EscapeVisitor.$$$reportNull$$$0(0);
            }
            this.boundVariable = boundVariable;
        }

        @Override
        public void visitAnonymousClass(PsiAnonymousClass aClass2) {
        }

        @Override
        public void visitElement(PsiElement element) {
            if (this.escaped) {
                return;
            }
            super.visitElement(element);
        }

        @Override
        public void visitReturnStatement(PsiReturnStatement statement2) {
            super.visitReturnStatement(statement2);
            PsiExpression value = PsiUtil.deparenthesizeExpression(statement2.getReturnValue());
            if (!(value instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)value;
            PsiElement target = referenceExpression.resolve();
            if (this.boundVariable.equals(target)) {
                this.escaped = true;
            }
        }

        @Override
        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            super.visitAssignmentExpression(expression2);
            PsiExpression rhs = PsiUtil.deparenthesizeExpression(expression2.getRExpression());
            if (!(rhs instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)rhs;
            PsiElement target = referenceExpression.resolve();
            if (!this.boundVariable.equals(target)) {
                return;
            }
            PsiExpression lhs = PsiUtil.deparenthesizeExpression(expression2.getLExpression());
            if (!(lhs instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression lReferenceExpression = (PsiReferenceExpression)lhs;
            PsiElement lTarget = lReferenceExpression.resolve();
            if (lTarget instanceof PsiField) {
                this.escaped = true;
            }
        }

        @Override
        public void visitCallExpression(PsiCallExpression callExpression) {
            PsiExpression[] expressions;
            if (!ResourceInspection.this.anyMethodMayClose && !ResourceInspection.this.isResourceCreation(callExpression)) {
                return;
            }
            PsiExpressionList argumentList2 = callExpression.getArgumentList();
            if (argumentList2 == null) {
                return;
            }
            for (PsiExpression expression2 : expressions = argumentList2.getExpressions()) {
                PsiReferenceExpression referenceExpression;
                PsiElement target;
                PsiExpression expression1 = PsiUtil.deparenthesizeExpression(expression2);
                if (!(expression1 instanceof PsiReferenceExpression) || !this.boundVariable.equals(target = (referenceExpression = (PsiReferenceExpression)expression1).resolve())) continue;
                this.escaped = true;
                break;
            }
        }

        public boolean isEscaped() {
            return this.escaped;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "boundVariable", "com/siyeh/ig/resources/ResourceInspection$EscapeVisitor", "<init>"));
        }
    }

    private class CloseVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean containsClose;
        private final PsiVariable resource;
        private final String resourceName;

        private CloseVisitor(PsiVariable resource) {
            this.resource = resource;
            this.resourceName = resource.getName();
        }

        @Override
        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                CloseVisitor.$$$reportNull$$$0(0);
            }
            if (!this.containsClose) {
                super.visitElement(element);
            }
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call2) {
            if (call2 == null) {
                CloseVisitor.$$$reportNull$$$0(1);
            }
            if (this.containsClose) {
                return;
            }
            super.visitMethodCallExpression(call2);
            if (!ResourceInspection.this.isResourceClose(call2, this.resource)) {
                return;
            }
            this.containsClose = true;
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression referenceExpression) {
            super.visitReferenceExpression(referenceExpression);
            if (this.containsClose) {
                return;
            }
            String text2 = referenceExpression.getText();
            if (text2 == null || !text2.equals(this.resourceName)) {
                return;
            }
            PsiElement parent2 = referenceExpression.getParent();
            if (!(parent2 instanceof PsiExpressionList)) {
                return;
            }
            PsiExpressionList argumentList2 = (PsiExpressionList)parent2;
            PsiExpression[] arguments2 = argumentList2.getExpressions();
            if (arguments2.length != 1) {
                return;
            }
            PsiElement grandParent = parent2.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (methodName == null || !methodName.contains("close")) {
                return;
            }
            PsiElement target = referenceExpression.resolve();
            if (target == null || !target.equals(this.resource)) {
                return;
            }
            this.containsClose = true;
        }

        private boolean containsClose() {
            return this.containsClose;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/resources/ResourceInspection$CloseVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ResourceVisitor
    extends BaseInspectionVisitor {
        private ResourceVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                ResourceVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            if (!this.isNotSafelyClosedResource(expression2)) {
                return;
            }
            this.registerMethodCallError(expression2, expression2);
        }

        @Override
        public void visitNewExpression(@NotNull PsiNewExpression expression2) {
            if (expression2 == null) {
                ResourceVisitor.$$$reportNull$$$0(1);
            }
            super.visitNewExpression(expression2);
            if (!this.isNotSafelyClosedResource(expression2)) {
                return;
            }
            this.registerNewExpressionError(expression2, expression2);
        }

        private boolean isNotSafelyClosedResource(PsiExpression expression2) {
            if (!ResourceInspection.this.isResourceCreation(expression2)) {
                return false;
            }
            PsiVariable boundVariable = ResourceInspection.getVariable(expression2);
            return !(boundVariable instanceof PsiResourceVariable) && !ResourceInspection.this.isSafelyClosed(boundVariable, expression2) && !ResourceInspection.this.isResourceFactoryClosed(expression2) && !ResourceInspection.this.isResourceEscapingFromMethod(boundVariable, expression2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/resources/ResourceInspection$ResourceVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNewExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

