/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.security;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import java.util.Arrays;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloneableClassInSecureContextInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("cloneable.class.in.secure.context.display.name", new Object[0]);
        if (string == null) {
            CloneableClassInSecureContextInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("cloneable.class.in.secure.context.problem.descriptor", new Object[0]);
        if (string == null) {
            CloneableClassInSecureContextInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        PsiClass aClass2 = (PsiClass)infos2[0];
        if (CloneUtils.isDirectlyCloneable(aClass2)) {
            return new RemoveCloneableFix();
        }
        boolean hasCloneMethod = Arrays.stream(aClass2.findMethodsByName("clone", false)).anyMatch(CloneUtils::isClone);
        if (hasCloneMethod) {
            return null;
        }
        return new CreateExceptionCloneMethodFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CloneableClassInSecureContextVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/security/CloneableClassInSecureContextInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class CloneableClassInSecureContextVisitor
    extends BaseInspectionVisitor {
        private CloneableClassInSecureContextVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass2) {
            PsiMethod method;
            PsiClass containingClass;
            if (aClass2 == null) {
                CloneableClassInSecureContextVisitor.$$$reportNull$$$0(0);
            }
            if (aClass2.isInterface() || aClass2.isAnnotationType() || aClass2 instanceof PsiTypeParameter) {
                return;
            }
            if (!CloneUtils.isCloneable(aClass2)) {
                return;
            }
            PsiMethod[] psiMethodArray = aClass2.findMethodsByName("clone", true);
            int n = psiMethodArray.length;
            for (int j = 0; !(j >= n || (containingClass = (method = psiMethodArray[j]).getContainingClass()) != null && "java.lang.Object".equals(containingClass.getQualifiedName())); ++j) {
                if (!CloneUtils.isClone(method) || !ControlFlowUtils.methodAlwaysThrowsException((PsiMethod)method.getNavigationElement())) continue;
                return;
            }
            this.registerClassError(aClass2, aClass2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/security/CloneableClassInSecureContextInspection$CloneableClassInSecureContextVisitor", "visitClass"));
        }
    }

    private static class CreateExceptionCloneMethodFix
    extends InspectionGadgetsFix {
        private CreateExceptionCloneMethodFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("cloneable.class.in.secure.context.quickfix", new Object[0]);
            if (string == null) {
                CreateExceptionCloneMethodFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement element = descriptor2.getPsiElement().getParent();
            if (!(element instanceof PsiClass)) {
                return;
            }
            PsiClass aClass2 = (PsiClass)element;
            String cloneMethod = "public " + aClass2.getName() + " clone() throws java.lang.CloneNotSupportedException{\nthrow new java.lang.CloneNotSupportedException();\n}";
            PsiMethod method = JavaPsiFacade.getElementFactory(project).createMethodFromText(cloneMethod, aClass2);
            aClass2.add(method);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/security/CloneableClassInSecureContextInspection$CreateExceptionCloneMethodFix", "getFamilyName"));
        }
    }

    private static class RemoveCloneableFix
    extends InspectionGadgetsFix {
        private RemoveCloneableFix() {
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("remove.cloneable.quickfix", new Object[0]);
            if (string == null) {
                RemoveCloneableFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiJavaCodeReferenceElement[] referenceElements;
            PsiElement element = descriptor2.getPsiElement().getParent();
            if (!(element instanceof PsiClass)) {
                return;
            }
            PsiClass aClass2 = (PsiClass)element;
            PsiReferenceList implementsList = aClass2.getImplementsList();
            if (implementsList == null) {
                return;
            }
            PsiClass cloneableClass = ClassUtils.findClass("java.lang.Cloneable", element);
            if (cloneableClass == null) {
                return;
            }
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements = implementsList.getReferenceElements()) {
                PsiElement target = referenceElement.resolve();
                if (!cloneableClass.equals(target)) continue;
                referenceElement.delete();
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/security/CloneableClassInSecureContextInspection$RemoveCloneableFix", "getFamilyName"));
        }
    }
}

