/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.security;

import com.intellij.codeInspection.concurrencyAnnotations.JCiPUtil;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodMatcher;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class PublicStaticCollectionFieldInspectionBase
extends BaseInspection {
    final MethodMatcher myMethodMatcher = new MethodMatcher().add("java.util.Collections", "(empty|unmodifiable).*").add("java.util.List", "of").add("java.util.Set", "of").add("java.util.Map", "of").add("com.google.common.collect.ImmutableCollection", ".*").add("com.google.common.collect.ImmutableMap", ".*").add("com.google.common.collect.ImmutableMultimap", ".*").add("com.google.common.collect.ImmutableTable", ".*").finishDefault();

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("public.static.collection.field.display.name", new Object[0]);
        if (string == null) {
            PublicStaticCollectionFieldInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("public.static.collection.field.problem.descriptor", new Object[0]);
        if (string == null) {
            PublicStaticCollectionFieldInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            PublicStaticCollectionFieldInspectionBase.$$$reportNull$$$0(2);
        }
        super.readSettings(element);
        this.myMethodMatcher.readSettings(element);
    }

    @Override
    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            PublicStaticCollectionFieldInspectionBase.$$$reportNull$$$0(3);
        }
        super.writeSettings(element);
        this.myMethodMatcher.writeSettings(element);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PublicStaticCollectionFieldVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/security/PublicStaticCollectionFieldInspectionBase";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/security/PublicStaticCollectionFieldInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PublicStaticCollectionFieldVisitor
    extends BaseInspectionVisitor {
        private PublicStaticCollectionFieldVisitor() {
        }

        @Override
        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                PublicStaticCollectionFieldVisitor.$$$reportNull$$$0(0);
            }
            super.visitField(field);
            if (!field.hasModifierProperty("public") || !field.hasModifierProperty("static")) {
                return;
            }
            PsiType type2 = field.getType();
            if (!CollectionUtils.isCollectionClassOrInterface(type2) || this.isImmutableCollection(field)) {
                return;
            }
            this.registerFieldError(field, new Object[0]);
        }

        private boolean isImmutableCollection(@NotNull PsiField field) {
            PsiClass containingClass;
            if (field == null) {
                PublicStaticCollectionFieldVisitor.$$$reportNull$$$0(1);
            }
            if (!field.hasModifierProperty("final")) {
                return false;
            }
            PsiExpression initializer2 = ParenthesesUtils.stripParentheses(field.getInitializer());
            if (ExpressionUtils.isNullLiteral(initializer2)) {
                return true;
            }
            if (!(initializer2 instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)initializer2;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null || PublicStaticCollectionFieldInspectionBase.this.myMethodMatcher.matches(method)) {
                return true;
            }
            if (ExpressionUtils.hasExpressionCount(methodCallExpression.getArgumentList(), 0) && "asList".equals(method.getName()) && (containingClass = method.getContainingClass()) != null && "java.util.Arrays".equals(containingClass.getQualifiedName())) {
                return true;
            }
            PsiClass aClass2 = PsiUtil.resolveClassInClassTypeOnly(methodCallExpression.getType());
            return aClass2 != null && JCiPUtil.isImmutable(aClass2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "field";
            objectArray2[1] = "com/siyeh/ig/security/PublicStaticCollectionFieldInspectionBase$PublicStaticCollectionFieldVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isImmutableCollection";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

