/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalizableWithoutPublicNoArgConstructorInspectionBase
extends BaseInspection {
    @Nullable
    protected static PsiMethod getNoArgConstructor(PsiClass aClass2) {
        PsiMethod[] constructors2;
        for (PsiMethod constructor : constructors2 = aClass2.getConstructors()) {
            PsiParameterList parameterList = constructor.getParameterList();
            if (parameterList.getParametersCount() != 0) continue;
            return constructor;
        }
        return null;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("externalizable.without.public.no.arg.constructor.display.name", new Object[0]);
        if (string == null) {
            ExternalizableWithoutPublicNoArgConstructorInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("externalizable.without.public.no.arg.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            ExternalizableWithoutPublicNoArgConstructorInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ExternalizableWithoutPublicNoArgConstructorVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/serialization/ExternalizableWithoutPublicNoArgConstructorInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ExternalizableWithoutPublicNoArgConstructorVisitor
    extends BaseInspectionVisitor {
        private ExternalizableWithoutPublicNoArgConstructorVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass2) {
            if (aClass2 == null) {
                ExternalizableWithoutPublicNoArgConstructorVisitor.$$$reportNull$$$0(0);
            }
            if (aClass2.isInterface() || aClass2.isEnum() || aClass2.isAnnotationType() || aClass2 instanceof PsiTypeParameter) {
                return;
            }
            if (aClass2.hasModifierProperty("abstract")) {
                return;
            }
            if (!ExternalizableWithoutPublicNoArgConstructorVisitor.isExternalizable(aClass2)) {
                return;
            }
            PsiMethod constructor = ExternalizableWithoutPublicNoArgConstructorInspectionBase.getNoArgConstructor(aClass2);
            if (constructor == null ? aClass2.hasModifierProperty("public") : constructor.hasModifierProperty("public")) {
                return;
            }
            if (SerializationUtils.hasWriteReplace(aClass2)) {
                return;
            }
            this.registerClassError(aClass2, aClass2, constructor);
        }

        private static boolean isExternalizable(PsiClass aClass2) {
            PsiClass externalizableClass = ClassUtils.findClass("java.io.Externalizable", aClass2);
            return externalizableClass != null && aClass2.isInheritor(externalizableClass, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/serialization/ExternalizableWithoutPublicNoArgConstructorInspectionBase$ExternalizableWithoutPublicNoArgConstructorVisitor", "visitClass"));
        }
    }
}

