/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.DelegatingFixFactory;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public class NonSerializableWithSerializationMethodsInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("NonSerializableClassWithSerializationMethods" == null) {
            NonSerializableWithSerializationMethodsInspection.$$$reportNull$$$0(0);
        }
        return "NonSerializableClassWithSerializationMethods";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.serializable.class.with.readwriteobject.display.name", new Object[0]);
        if (string == null) {
            NonSerializableWithSerializationMethodsInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        PsiClass aClass2 = (PsiClass)infos2[2];
        if (aClass2 instanceof PsiAnonymousClass) {
            return null;
        }
        return DelegatingFixFactory.createMakeSerializableFix(aClass2);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        boolean hasReadObject = (Boolean)infos2[0];
        boolean hasWriteObject = (Boolean)infos2[1];
        PsiClass aClass2 = (PsiClass)infos2[2];
        if (aClass2 instanceof PsiAnonymousClass) {
            if (hasReadObject && hasWriteObject) {
                String string = InspectionGadgetsBundle.message("non.serializable.anonymous.with.readwriteobject.problem.descriptor.both", new Object[0]);
                if (string == null) {
                    NonSerializableWithSerializationMethodsInspection.$$$reportNull$$$0(2);
                }
                return string;
            }
            if (hasWriteObject) {
                String string = InspectionGadgetsBundle.message("non.serializable.anonymous.with.readwriteobject.problem.descriptor.write", new Object[0]);
                if (string == null) {
                    NonSerializableWithSerializationMethodsInspection.$$$reportNull$$$0(3);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("non.serializable.anonymous.with.readwriteobject.problem.descriptor.read", new Object[0]);
            if (string == null) {
                NonSerializableWithSerializationMethodsInspection.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (hasReadObject && hasWriteObject) {
            String string = InspectionGadgetsBundle.message("non.serializable.class.with.readwriteobject.problem.descriptor.both", new Object[0]);
            if (string == null) {
                NonSerializableWithSerializationMethodsInspection.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (hasWriteObject) {
            String string = InspectionGadgetsBundle.message("non.serializable.class.with.readwriteobject.problem.descriptor.write", new Object[0]);
            if (string == null) {
                NonSerializableWithSerializationMethodsInspection.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("non.serializable.class.with.readwriteobject.problem.descriptor.read", new Object[0]);
        if (string == null) {
            NonSerializableWithSerializationMethodsInspection.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonSerializableWithSerializationMethodsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/serialization/NonSerializableWithSerializationMethodsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class NonSerializableWithSerializationMethodsVisitor
    extends BaseInspectionVisitor {
        private NonSerializableWithSerializationMethodsVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass2) {
            if (aClass2 == null) {
                NonSerializableWithSerializationMethodsVisitor.$$$reportNull$$$0(0);
            }
            if (aClass2.isInterface() || aClass2.isAnnotationType()) {
                return;
            }
            boolean hasReadObject = SerializationUtils.hasReadObject(aClass2);
            boolean hasWriteObject = SerializationUtils.hasWriteObject(aClass2);
            if (!hasWriteObject && !hasReadObject) {
                return;
            }
            if (SerializationUtils.isSerializable(aClass2)) {
                return;
            }
            this.registerClassError(aClass2, hasReadObject, hasWriteObject, aClass2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/serialization/NonSerializableWithSerializationMethodsInspection$NonSerializableWithSerializationMethodsVisitor", "visitClass"));
        }
    }
}

