/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SerializationUtils;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class SerializableWithUnconstructableAncestorInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("SerializableClassWithUnconstructableAncestor" == null) {
            SerializableWithUnconstructableAncestorInspection.$$$reportNull$$$0(0);
        }
        return "SerializableClassWithUnconstructableAncestor";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("serializable.with.unconstructable.ancestor.display.name", new Object[0]);
        if (string == null) {
            SerializableWithUnconstructableAncestorInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        PsiClass ancestor = (PsiClass)infos2[0];
        String string = InspectionGadgetsBundle.message("serializable.with.unconstructable.ancestor.problem.descriptor", ancestor.getName());
        if (string == null) {
            SerializableWithUnconstructableAncestorInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SerializableWithUnconstructableAncestorVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/serialization/SerializableWithUnconstructableAncestorInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SerializableWithUnconstructableAncestorVisitor
    extends BaseInspectionVisitor {
        private SerializableWithUnconstructableAncestorVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass2) {
            if (aClass2 == null) {
                SerializableWithUnconstructableAncestorVisitor.$$$reportNull$$$0(0);
            }
            if (aClass2.isInterface() || aClass2.isAnnotationType()) {
                return;
            }
            if (!SerializationUtils.isSerializable(aClass2) || SerializationUtils.hasWriteReplace(aClass2)) {
                return;
            }
            PsiClass ancestor = aClass2.getSuperClass();
            HashSet<PsiClass> visitedClasses = new HashSet<PsiClass>(8);
            while (ancestor != null && SerializationUtils.isSerializable(ancestor)) {
                if (SerializationUtils.hasWriteReplace(ancestor)) {
                    return;
                }
                if (visitedClasses.add(ancestor = ancestor.getSuperClass())) continue;
                return;
            }
            if (ancestor == null || SerializableWithUnconstructableAncestorVisitor.classHasNoArgConstructor(ancestor)) {
                return;
            }
            this.registerClassError(aClass2, ancestor);
        }

        private static boolean classHasNoArgConstructor(PsiClass aClass2) {
            boolean hasConstructor = false;
            boolean hasNoArgConstructor = false;
            for (PsiMethod constructor : aClass2.getConstructors()) {
                hasConstructor = true;
                PsiParameterList parameterList = constructor.getParameterList();
                if (parameterList.getParametersCount() != 0 || !constructor.hasModifierProperty("public") && !constructor.hasModifierProperty("protected")) continue;
                hasNoArgConstructor = true;
            }
            return hasNoArgConstructor || !hasConstructor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/serialization/SerializableWithUnconstructableAncestorInspection$SerializableWithUnconstructableAncestorVisitor", "visitClass"));
        }
    }
}

