/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class ConfusingOctalEscapeInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("ConfusingOctalEscapeSequence" == null) {
            ConfusingOctalEscapeInspection.$$$reportNull$$$0(0);
        }
        return "ConfusingOctalEscapeSequence";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("confusing.octal.escape.sequence.display.name", new Object[0]);
        if (string == null) {
            ConfusingOctalEscapeInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("confusing.octal.escape.sequence.problem.descriptor", new Object[0]);
        if (string == null) {
            ConfusingOctalEscapeInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConfusingOctalEscapeVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/ConfusingOctalEscapeInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ConfusingOctalEscapeVisitor
    extends BaseInspectionVisitor {
        private ConfusingOctalEscapeVisitor() {
        }

        @Override
        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression2) {
            if (expression2 == null) {
                ConfusingOctalEscapeVisitor.$$$reportNull$$$0(0);
            }
            super.visitLiteralExpression(expression2);
            if (!ExpressionUtils.hasStringType(expression2)) {
                return;
            }
            String text2 = expression2.getText();
            int escapeStart = -1;
            block0: while ((escapeStart = text2.indexOf(92, escapeStart + 1)) >= 0) {
                int nextChar;
                if (escapeStart > 0 && text2.charAt(escapeStart - 1) == '\\') continue;
                boolean isEscape = true;
                int textLength = text2.length();
                for (nextChar = escapeStart + 1; nextChar < textLength && text2.charAt(nextChar) == '\\'; ++nextChar) {
                    isEscape = !isEscape;
                }
                if (!isEscape) continue;
                escapeStart = nextChar - 1;
                int length = 1;
                boolean zeroToThree = false;
                while (true) {
                    char c;
                    if (escapeStart + length >= textLength || (c = text2.charAt(escapeStart + length)) < '0' || c > '9') continue block0;
                    if (length == 1 && (c == '0' || c == '1' || c == '2' || c == '3')) {
                        zeroToThree = true;
                    }
                    if (c == '8' || c == '9' || length > 2 && !zeroToThree || length > 3) {
                        this.registerErrorAtOffset((PsiElement)expression2, escapeStart, length, new Object[0]);
                        continue block0;
                    }
                    ++length;
                }
                break;
            }
            return;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/style/ConfusingOctalEscapeInspection$ConfusingOctalEscapeVisitor", "visitLiteralExpression"));
        }
    }
}

