/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.BlockUtils;
import com.siyeh.ig.style.ControlFlowStatementVisitorBase;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControlFlowStatementWithoutBracesInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("control.flow.statement.without.braces.display.name", new Object[0]);
        if (string == null) {
            ControlFlowStatementWithoutBracesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("control.flow.statement.without.braces.problem.descriptor", infos2);
        if (string == null) {
            ControlFlowStatementWithoutBracesInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos2) {
        if (infos2.length == 1 && infos2[0] instanceof String) {
            return new ControlFlowStatementFix((String)infos2[0]);
        }
        return null;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ControlFlowStatementVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/ControlFlowStatementWithoutBracesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ControlFlowStatementVisitor
    extends ControlFlowStatementVisitorBase {
        private ControlFlowStatementVisitor() {
        }

        @Override
        @Contract(value="null->false")
        protected boolean isApplicable(PsiStatement body2) {
            PsiIfStatement ifStatement;
            PsiElement parent2;
            if (body2 instanceof PsiIfStatement && this.isVisibleHighlight(body2) && (parent2 = body2.getParent()) instanceof PsiIfStatement && (ifStatement = (PsiIfStatement)parent2).getElseBranch() == body2) {
                return false;
            }
            return body2 != null && !(body2 instanceof PsiBlockStatement);
        }

        @Override
        @Nullable
        protected Pair<PsiElement, PsiElement> getOmittedBodyBounds(PsiStatement body2) {
            if (body2 instanceof PsiLoopStatement || body2 instanceof PsiIfStatement) {
                PsiElement lastChild = body2.getLastChild();
                return Pair.create(PsiTreeUtil.skipWhitespacesAndCommentsBackward(body2), PsiUtil.isJavaToken(lastChild, JavaTokenType.SEMICOLON) ? lastChild : null);
            }
            return null;
        }
    }

    private static class ControlFlowStatementFix
    extends InspectionGadgetsFix {
        private final String myKeywordText;

        ControlFlowStatementFix(String keywordText) {
            this.myKeywordText = keywordText;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("control.flow.statement.without.braces.message", this.myKeywordText);
            if (string == null) {
                ControlFlowStatementFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("control.flow.statement.without.braces.add.quickfix", new Object[0]);
            if (string == null) {
                ControlFlowStatementFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiStatement statementWithoutBraces;
            PsiStatement statement2;
            PsiElement element = descriptor2.getStartElement();
            PsiElement parent2 = element.getParent();
            if (element instanceof PsiStatement) {
                statement2 = (PsiStatement)element;
            } else if (parent2 instanceof PsiStatement) {
                statement2 = (PsiStatement)parent2;
            } else {
                return;
            }
            if (statement2 instanceof PsiLoopStatement) {
                PsiLoopStatement loopStatement = (PsiLoopStatement)statement2;
                statementWithoutBraces = loopStatement.getBody();
            } else if (statement2 instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)statement2;
                statementWithoutBraces = element == ifStatement.getElseElement() ? ifStatement.getElseBranch() : ifStatement.getThenBranch();
            } else {
                return;
            }
            if (statementWithoutBraces == null) {
                return;
            }
            BlockUtils.expandSingleStatementToBlockStatement(statementWithoutBraces);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/style/ControlFlowStatementWithoutBracesInspection$ControlFlowStatementFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

