/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessarySuperQualifierInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.super.qualifier.display.name", new Object[0]);
        if (string == null) {
            UnnecessarySuperQualifierInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("unnecessary.super.qualifier.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessarySuperQualifierInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        return new UnnecessarySuperQualifierFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessarySuperQualifierVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/UnnecessarySuperQualifierInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UnnecessarySuperQualifierVisitor
    extends BaseInspectionVisitor {
        private UnnecessarySuperQualifierVisitor() {
        }

        @Override
        public void visitSuperExpression(PsiSuperExpression expression2) {
            PsiMethodCallExpression methodCallExpression;
            super.visitSuperExpression(expression2);
            PsiJavaCodeReferenceElement qualifier = expression2.getQualifier();
            if (qualifier != null) {
                return;
            }
            PsiElement parent2 = expression2.getParent();
            if (!(parent2 instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)parent2;
            PsiElement grandParent = referenceExpression.getParent();
            if (grandParent instanceof PsiMethodCallExpression ? !UnnecessarySuperQualifierVisitor.hasUnnecessarySuperQualifier(methodCallExpression = (PsiMethodCallExpression)grandParent) : !UnnecessarySuperQualifierVisitor.hasUnnecessarySuperQualifier(referenceExpression)) {
                return;
            }
            this.registerError((PsiElement)expression2, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
        }

        private static boolean hasUnnecessarySuperQualifier(PsiReferenceExpression referenceExpression) {
            PsiClass parentClass = PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, PsiClass.class);
            if (parentClass == null) {
                return false;
            }
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiField)) {
                return false;
            }
            PsiField superField = (PsiField)target;
            PsiReferenceExpression copy = (PsiReferenceExpression)referenceExpression.copy();
            PsiElement qualifier = copy.getQualifier();
            if (qualifier == null) {
                return false;
            }
            qualifier.delete();
            JavaResolveResult resolveResult = copy.advancedResolve(false);
            return resolveResult.isValidResult() && superField == resolveResult.getElement();
        }

        private static boolean hasUnnecessarySuperQualifier(PsiMethodCallExpression methodCallExpression) {
            PsiMethod superMethod = methodCallExpression.resolveMethod();
            if (superMethod == null) {
                return false;
            }
            PsiClass aClass2 = PsiTreeUtil.getParentOfType((PsiElement)methodCallExpression, PsiClass.class);
            if (MethodUtils.isOverriddenInHierarchy(superMethod, aClass2)) {
                return false;
            }
            PsiMethodCallExpression copy = (PsiMethodCallExpression)methodCallExpression.copy();
            PsiReferenceExpression methodExpression = copy.getMethodExpression();
            PsiElement qualifier = methodExpression.getQualifier();
            if (qualifier == null) {
                return false;
            }
            qualifier.delete();
            JavaResolveResult resolveResult = copy.resolveMethodGenerics();
            return resolveResult.isValidResult() && superMethod == resolveResult.getElement();
        }
    }

    private static class UnnecessarySuperQualifierFix
    extends InspectionGadgetsFix {
        private UnnecessarySuperQualifierFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.super.qualifier.quickfix", new Object[0]);
            if (string == null) {
                UnnecessarySuperQualifierFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement element = descriptor2.getPsiElement();
            element.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessarySuperQualifierInspection$UnnecessarySuperQualifierFix", "getFamilyName"));
        }
    }
}

