/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UnqualifiedInnerClassAccessInspectionBase
extends BaseInspection {
    public boolean ignoreReferencesToLocalInnerClasses = false;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unqualified.inner.class.access.display.name", new Object[0]);
        if (string == null) {
            UnqualifiedInnerClassAccessInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("unqualified.inner.class.access.problem.descriptor", new Object[0]);
        if (string == null) {
            UnqualifiedInnerClassAccessInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnqualifiedInnerClassAccessVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/UnqualifiedInnerClassAccessInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class UnqualifiedInnerClassAccessVisitor
    extends BaseInspectionVisitor {
        private UnqualifiedInnerClassAccessVisitor() {
        }

        @Override
        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            super.visitReferenceElement(reference);
            if (reference.isQualified()) {
                return;
            }
            PsiElement target = reference.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass aClass2 = (PsiClass)target;
            if (!aClass2.hasModifierProperty("static") && reference.getParent() instanceof PsiNewExpression) {
                return;
            }
            PsiClass containingClass = aClass2.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (UnqualifiedInnerClassAccessInspectionBase.this.ignoreReferencesToLocalInnerClasses) {
                if (PsiTreeUtil.isAncestor(containingClass, reference, true)) {
                    return;
                }
                PsiClass referenceClass = PsiTreeUtil.getParentOfType((PsiElement)reference, PsiClass.class);
                if (referenceClass != null && referenceClass.isInheritor(containingClass, true)) {
                    return;
                }
            }
            this.registerError((PsiElement)reference, containingClass.getName());
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            this.visitReferenceElement(expression2);
        }
    }
}

