/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AccessToNonThreadSafeStaticFieldFromInstanceInspectionBase
extends BaseInspection {
    public final ExternalizableStringSet nonThreadSafeClasses = new ExternalizableStringSet("java.text.SimpleDateFormat", "java.text.MessageFormat", "java.text.DecimalFormat", "java.text.ChoiceFormat", "java.util.Calendar");
    @NonNls
    public String nonThreadSafeTypes = "";

    public AccessToNonThreadSafeStaticFieldFromInstanceInspectionBase() {
        if (!this.nonThreadSafeTypes.isEmpty()) {
            this.nonThreadSafeClasses.clear();
            List<String> strings = StringUtil.split(this.nonThreadSafeTypes, ",");
            for (String string : strings) {
                this.nonThreadSafeClasses.add(string);
            }
            this.nonThreadSafeTypes = "";
        }
    }

    @Override
    @NotNull
    public String getID() {
        if ("AccessToNonThreadSafeStaticField" == null) {
            AccessToNonThreadSafeStaticFieldFromInstanceInspectionBase.$$$reportNull$$$0(0);
        }
        return "AccessToNonThreadSafeStaticField";
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("access.to.non.thread.safe.static.field.from.instance.display.name", new Object[0]);
        if (string == null) {
            AccessToNonThreadSafeStaticFieldFromInstanceInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("access.to.non.thread.safe.static.field.from.instance.field.problem.descriptor", infos2[0]);
        if (string == null) {
            AccessToNonThreadSafeStaticFieldFromInstanceInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AccessToNonThreadSafeStaticFieldFromInstanceVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/threading/AccessToNonThreadSafeStaticFieldFromInstanceInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    class AccessToNonThreadSafeStaticFieldFromInstanceVisitor
    extends BaseInspectionVisitor {
        AccessToNonThreadSafeStaticFieldFromInstanceVisitor() {
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            PsiElement target;
            super.visitReferenceExpression(expression2);
            if (expression2.getQualifierExpression() != null) {
                return;
            }
            PsiType type2 = expression2.getType();
            if (!(type2 instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)type2;
            String className2 = classType.rawType().getCanonicalText();
            boolean deepCheck = false;
            if (!AccessToNonThreadSafeStaticFieldFromInstanceInspectionBase.this.nonThreadSafeClasses.contains(className2)) {
                if (!TypeUtils.isExpressionTypeAssignableWith(expression2, AccessToNonThreadSafeStaticFieldFromInstanceInspectionBase.this.nonThreadSafeClasses)) {
                    return;
                }
                deepCheck = true;
            }
            if (!((target = expression2.resolve()) instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)target;
            if (!field.hasModifierProperty("static")) {
                return;
            }
            PsiModifierListOwner parent2 = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiField.class, PsiMethod.class, PsiClassInitializer.class);
            if (parent2 == null) {
                return;
            }
            if (parent2 instanceof PsiMethod || parent2 instanceof PsiClassInitializer) {
                if (parent2.hasModifierProperty("synchronized")) {
                    return;
                }
                PsiSynchronizedStatement synchronizedStatement = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiSynchronizedStatement.class);
                if (synchronizedStatement != null) {
                    return;
                }
            }
            if ((parent2 instanceof PsiField || parent2 instanceof PsiClassInitializer) && parent2.hasModifierProperty("static")) {
                return;
            }
            if (deepCheck) {
                PsiExpression initializer2 = field.getInitializer();
                if (initializer2 == null) {
                    return;
                }
                PsiType initializerType = initializer2.getType();
                if (!(initializerType instanceof PsiClassType)) {
                    return;
                }
                PsiClassType classType2 = (PsiClassType)initializerType;
                String className22 = classType2.rawType().getCanonicalText();
                if (!AccessToNonThreadSafeStaticFieldFromInstanceInspectionBase.this.nonThreadSafeClasses.contains(className22)) {
                    return;
                }
                this.registerError((PsiElement)expression2, className22);
            } else {
                this.registerError((PsiElement)expression2, className2);
            }
        }
    }
}

