/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class NakedNotifyInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("naked.notify.display.name", new Object[0]);
        if (string == null) {
            NakedNotifyInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("naked.notify.problem.descriptor", new Object[0]);
        if (string == null) {
            NakedNotifyInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NakedNotifyVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/threading/NakedNotifyInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class NakedNotifyVisitor
    extends BaseInspectionVisitor {
        private NakedNotifyVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                NakedNotifyVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            if (!method.hasModifierProperty("synchronized")) {
                return;
            }
            PsiCodeBlock body2 = method.getBody();
            if (body2 != null) {
                this.checkBody(body2);
            }
        }

        @Override
        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement2) {
            if (statement2 == null) {
                NakedNotifyVisitor.$$$reportNull$$$0(1);
            }
            super.visitSynchronizedStatement(statement2);
            this.checkBody(statement2.getBody());
        }

        private void checkBody(PsiCodeBlock body2) {
            PsiStatement firstStatement = ControlFlowUtils.getFirstStatementInBlock(body2);
            if (!(firstStatement instanceof PsiExpressionStatement)) {
                return;
            }
            PsiExpression firstExpression = ((PsiExpressionStatement)firstStatement).getExpression();
            if (!(firstExpression instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)firstExpression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"notify".equals(methodName) && !"notifyAll".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList2 = methodCallExpression.getArgumentList();
            if (argumentList2.getExpressions().length != 0) {
                return;
            }
            this.registerMethodCallError(methodCallExpression, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/threading/NakedNotifyInspection$NakedNotifyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSynchronizedStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

