/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class SystemRunFinalizersOnExitInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("CallToSystemRunFinalizersOnExit" == null) {
            SystemRunFinalizersOnExitInspection.$$$reportNull$$$0(0);
        }
        return "CallToSystemRunFinalizersOnExit";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("system.run.finalizers.on.exit.display.name", new Object[0]);
        if (string == null) {
            SystemRunFinalizersOnExitInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("system.run.finalizers.on.exit.problem.descriptor", new Object[0]);
        if (string == null) {
            SystemRunFinalizersOnExitInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SystemRunFinalizersOnExitVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/threading/SystemRunFinalizersOnExitInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SystemRunFinalizersOnExitVisitor
    extends BaseInspectionVisitor {
        private SystemRunFinalizersOnExitVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                SystemRunFinalizersOnExitVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            if (!SystemRunFinalizersOnExitVisitor.isRunFinalizersOnExit(expression2)) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private static boolean isRunFinalizersOnExit(PsiMethodCallExpression expression2) {
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            String runFinalizers = "runFinalizersOnExit";
            if (!"runFinalizersOnExit".equals(methodName)) {
                return false;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass2 = method.getContainingClass();
            if (aClass2 == null) {
                return false;
            }
            String className2 = aClass2.getQualifiedName();
            if (className2 == null) {
                return false;
            }
            return "java.lang.System".equals(className2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/SystemRunFinalizersOnExitInspection$SystemRunFinalizersOnExitVisitor", "visitMethodCallExpression"));
        }
    }
}

