/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameterList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ThreadWithDefaultRunMethodInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("thread.with.default.run.method.display.name", new Object[0]);
        if (string == null) {
            ThreadWithDefaultRunMethodInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getID() {
        if ("InstantiatingAThreadWithDefaultRunMethod" == null) {
            ThreadWithDefaultRunMethodInspection.$$$reportNull$$$0(1);
        }
        return "InstantiatingAThreadWithDefaultRunMethod";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("thread.with.default.run.method.problem.descriptor", new Object[0]);
        if (string == null) {
            ThreadWithDefaultRunMethodInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThreadWithDefaultRunMethodVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/threading/ThreadWithDefaultRunMethodInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ThreadWithDefaultRunMethodVisitor
    extends BaseInspectionVisitor {
        private ThreadWithDefaultRunMethodVisitor() {
        }

        @Override
        public void visitNewExpression(@NotNull PsiNewExpression expression2) {
            if (expression2 == null) {
                ThreadWithDefaultRunMethodVisitor.$$$reportNull$$$0(0);
            }
            super.visitNewExpression(expression2);
            PsiAnonymousClass anonymousClass = expression2.getAnonymousClass();
            if (anonymousClass != null) {
                if (ThreadWithDefaultRunMethodVisitor.definesRun(anonymousClass)) {
                    return;
                }
                this.processExpression(expression2, anonymousClass.getBaseClassReference());
            } else {
                PsiJavaCodeReferenceElement classReference = expression2.getClassReference();
                if (classReference == null) {
                    return;
                }
                this.processExpression(expression2, classReference);
            }
        }

        private void processExpression(PsiNewExpression expression2, PsiJavaCodeReferenceElement baseClassReference) {
            PsiExpression[] arguments2;
            PsiElement referent = baseClassReference.resolve();
            if (referent == null) {
                return;
            }
            PsiClass referencedClass = (PsiClass)referent;
            String referencedClassName = referencedClass.getQualifiedName();
            if (!"java.lang.Thread".equals(referencedClassName)) {
                return;
            }
            PsiExpressionList argumentList2 = expression2.getArgumentList();
            if (argumentList2 == null) {
                return;
            }
            for (PsiExpression argument : arguments2 = argumentList2.getExpressions()) {
                if (!TypeUtils.expressionHasTypeOrSubtype(argument, "java.lang.Runnable")) continue;
                return;
            }
            this.registerNewExpressionError(expression2, new Object[0]);
        }

        private static boolean definesRun(PsiAnonymousClass aClass2) {
            PsiMethod[] methods2;
            for (PsiMethod method : methods2 = aClass2.findMethodsByName("run", false)) {
                PsiParameterList parameterList = method.getParameterList();
                if (parameterList.getParametersCount() != 0) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/ThreadWithDefaultRunMethodInspection$ThreadWithDefaultRunMethodVisitor", "visitNewExpression"));
        }
    }
}

