/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaParameterHidingMemberVariableInspectionBase
extends BaseInspection {
    public boolean m_ignoreInvisibleFields = true;

    @Override
    @NotNull
    public String getID() {
        if ("LambdaParameterHidesMemberVariable" == null) {
            LambdaParameterHidingMemberVariableInspectionBase.$$$reportNull$$$0(0);
        }
        return "LambdaParameterHidesMemberVariable";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("lambda.parameter.hides.member.variable.display.name", new Object[0]);
        if (string == null) {
            LambdaParameterHidingMemberVariableInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        PsiClass aClass2 = (PsiClass)infos2[0];
        String string = InspectionGadgetsBundle.message("lambda.parameter.hides.member.variable.problem.descriptor", aClass2.getName());
        if (string == null) {
            LambdaParameterHidingMemberVariableInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("lambda.parameter.hides.member.variable.ignore.invisible.option", new Object[0]), "m_ignoreInvisibleFields");
        return optionsPanel;
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel8OrHigher(file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LambdaParameterHidingMemberVariableVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/visibility/LambdaParameterHidingMemberVariableInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class LambdaParameterHidingMemberVariableVisitor
    extends BaseInspectionVisitor {
        private LambdaParameterHidingMemberVariableVisitor() {
        }

        @Override
        public void visitParameter(@NotNull PsiParameter variable2) {
            if (variable2 == null) {
                LambdaParameterHidingMemberVariableVisitor.$$$reportNull$$$0(0);
            }
            super.visitParameter(variable2);
            PsiElement declarationScope = variable2.getDeclarationScope();
            if (!(declarationScope instanceof PsiLambdaExpression)) {
                return;
            }
            PsiClass aClass2 = this.checkFieldName(variable2);
            if (aClass2 == null) {
                return;
            }
            this.registerVariableError(variable2, aClass2);
        }

        @Nullable
        private PsiClass checkFieldName(PsiVariable variable2) {
            String variableName = variable2.getName();
            if (variableName == null) {
                return null;
            }
            PsiClass aClass2 = ClassUtils.getContainingClass(variable2);
            while (aClass2 != null) {
                PsiField field = aClass2.findFieldByName(variableName, true);
                if (field != null) {
                    if (!LambdaParameterHidingMemberVariableInspectionBase.this.m_ignoreInvisibleFields) {
                        return aClass2;
                    }
                    if (ClassUtils.isFieldVisible(field, aClass2) && PsiUtil.getEnclosingStaticElement(variable2, aClass2) == null || field.hasModifierProperty("static")) {
                        return aClass2;
                    }
                }
                aClass2 = ClassUtils.getContainingClass(aClass2);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/visibility/LambdaParameterHidingMemberVariableInspectionBase$LambdaParameterHidingMemberVariableVisitor", "visitParameter"));
        }
    }
}

