/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.TIntProcedure;
import java.io.Serializable;

public class TIntArrayList
implements Serializable,
Cloneable {
    protected transient int[] _data;
    protected transient int _pos;

    public TIntArrayList() {
    }

    public TIntArrayList(int capacity) {
        this._data = new int[capacity];
        this._pos = 0;
    }

    public void ensureCapacity(int capacity) {
        if (this._data == null) {
            this._data = new int[Math.max(4, capacity)];
        }
        if (capacity > this._data.length) {
            int newCap = Math.max(this._data.length << 1, capacity);
            int[] tmp = new int[newCap];
            System.arraycopy(this._data, 0, tmp, 0, this._data.length);
            this._data = tmp;
        }
    }

    public int size() {
        return this._pos;
    }

    public boolean isEmpty() {
        return this._pos == 0;
    }

    public void add(int val) {
        this.ensureCapacity(this._pos + 1);
        this._data[this._pos++] = val;
    }

    public void insert(int offset2, int value) {
        if (offset2 == this._pos) {
            this.add(value);
            return;
        }
        this.ensureCapacity(this._pos + 1);
        System.arraycopy(this._data, offset2, this._data, offset2 + 1, this._pos - offset2);
        this._data[offset2] = value;
        ++this._pos;
    }

    public int get(int offset2) {
        if (offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        return this._data[offset2];
    }

    public int getQuick(int offset2) {
        return this._data[offset2];
    }

    public void clear() {
        this._data = null;
        this._pos = 0;
    }

    public int remove(int offset2) {
        int old = this.get(offset2);
        this.remove(offset2, 1);
        return old;
    }

    public void remove(int offset2, int length) {
        if (offset2 < 0 || offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        if (offset2 == 0) {
            System.arraycopy(this._data, length, this._data, 0, this._pos - length);
        } else if (this._pos - length != offset2) {
            System.arraycopy(this._data, offset2 + length, this._data, offset2, this._pos - (offset2 + length));
        }
        this._pos -= length;
    }

    public void reverse() {
        this.reverse(0, this._pos);
    }

    public void reverse(int from, int to) {
        if (from == to) {
            return;
        }
        if (from > to) {
            throw new IllegalArgumentException("from cannot be greater than to");
        }
        int i2 = from;
        for (int j = to - 1; i2 < j; ++i2, --j) {
            this.swap(i2, j);
        }
    }

    private void swap(int i2, int j) {
        int tmp = this._data[i2];
        this._data[i2] = this._data[j];
        this._data[j] = tmp;
    }

    public Object clone() {
        TIntArrayList clone = null;
        try {
            clone = (TIntArrayList)super.clone();
            clone._data = this._data == null ? null : (int[])this._data.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public int[] toNativeArray() {
        return this.toNativeArray(0, this._pos);
    }

    public int[] toNativeArray(int offset2, int len) {
        int[] rv = new int[len];
        this.toNativeArray(rv, offset2, len);
        return rv;
    }

    public void toNativeArray(int[] dest, int offset2, int len) {
        if (len == 0) {
            return;
        }
        if (offset2 < 0 || offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        System.arraycopy(this._data, offset2, dest, 0, len);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TIntArrayList) {
            TIntArrayList that = (TIntArrayList)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i2 = this._pos;
            while (i2-- > 0) {
                if (this._data[i2] == that._data[i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        int i2 = this._pos;
        while (i2-- > 0) {
            h += HashFunctions.hash(this._data[i2]);
        }
        return h;
    }

    public boolean forEach(TIntProcedure procedure) {
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (procedure.execute(this._data[i2])) continue;
            return false;
        }
        return true;
    }

    public int indexOf(int offset2, int value) {
        for (int i2 = offset2; i2 < this._pos; ++i2) {
            if (this._data[i2] != value) continue;
            return i2;
        }
        return -1;
    }

    public int lastIndexOf(int value) {
        return this.lastIndexOf(this._pos, value);
    }

    public int lastIndexOf(int offset2, int value) {
        int i2 = offset2;
        while (i2-- > 0) {
            if (this._data[i2] != value) continue;
            return i2;
        }
        return -1;
    }

    public String toString() {
        final StringBuffer buf = new StringBuffer("{");
        this.forEach(new TIntProcedure(){

            public boolean execute(int val) {
                buf.append(val);
                buf.append(", ");
                return true;
            }
        });
        buf.append("}");
        return buf.toString();
    }
}

